/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.targets;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.flex.abc.ABCLinker;
import org.apache.flex.compiler.internal.projects.CompilerProject;
import org.apache.flex.compiler.internal.targets.ILibrarySWFTarget;
import org.apache.flex.compiler.internal.targets.ITargetAttributes;
import org.apache.flex.compiler.internal.targets.NilTargetAttributes;
import org.apache.flex.compiler.internal.targets.SWFTarget;
import org.apache.flex.compiler.internal.units.ResourceBundleCompilationUnit;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.targets.ITargetSettings;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.swf.SWFFrame;
import org.apache.flex.swf.tags.DoABCTag;

public class LibrarySWFTarget
extends SWFTarget
implements ILibrarySWFTarget {
    protected final Set<ICompilationUnit> rootedCompilationUnits;
    private ImmutableSet<ICompilationUnit> compilationUnits;

    public LibrarySWFTarget(CompilerProject project, ITargetSettings targetSettings, Set<ICompilationUnit> rootedCompilationUnits) {
        super(project, targetSettings, null);
        this.rootedCompilationUnits = rootedCompilationUnits;
    }

    @Override
    protected ITargetAttributes computeTargetAttributes() throws InterruptedException {
        return NilTargetAttributes.INSTANCE;
    }

    @Override
    protected SWFTarget.FramesInformation computeFramesInformation() throws InterruptedException {
        SWFTarget.SWFFrameInfo frame = new SWFTarget.SWFFrameInfo(this.rootedCompilationUnits, Collections.<ICompilerProblem>emptyList());
        return new SWFTarget.FramesInformation(Collections.singletonList(frame));
    }

    @Override
    public ImmutableSet<ICompilationUnit> getCompilationUnits() {
        return this.compilationUnits != null ? this.compilationUnits : ImmutableSet.of();
    }

    @Override
    public String getRootClassName() {
        return null;
    }

    @Override
    public String getBaseClassQName() {
        return null;
    }

    @Override
    protected boolean testCompilationUnitLinkage(ICompilationUnit cu, boolean allowExternals) throws InterruptedException {
        return super.testCompilationUnitLinkage(cu, allowExternals) && !(cu instanceof ResourceBundleCompilationUnit);
    }

    @Override
    protected void doPostBuildWork(ImmutableSet<ICompilationUnit> compilationUnits, Collection<ICompilerProblem> problems) throws InterruptedException {
        this.compilationUnits = compilationUnits;
    }

    @Override
    protected boolean shouldAddMetadataNamesToTarget(ICompilationUnit cu, boolean linkage) {
        return linkage && super.shouldAddMetadataNamesToTarget(cu, linkage);
    }

    @Override
    protected final void addLinkedABCToFrame(SWFFrame targetFrame, Iterable<DoABCTag> inputABCs, ABCLinker.ABCLinkerSettings linkSettings) throws Exception {
        for (DoABCTag inputABC : inputABCs) {
            byte[] linkedBytes = ABCLinker.linkABC(Collections.singleton(inputABC.getABCData()), 46, 16, linkSettings);
            DoABCTag linkedTag = new DoABCTag(1L, inputABC.getName(), linkedBytes);
            targetFrame.addTag(linkedTag);
        }
    }

    @Override
    protected void setKeepAS3MetadataLinkerSetting(ABCLinker.ABCLinkerSettings linkSettings) {
        linkSettings.setKeepMetadata(null);
    }
}

