/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.scopes;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flex.compiler.common.ASImportTarget;
import org.apache.flex.compiler.common.DependencyType;
import org.apache.flex.compiler.common.NodeReference;
import org.apache.flex.compiler.constants.IASLanguageConstants;
import org.apache.flex.compiler.definitions.IClassDefinition;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.INamespaceDefinition;
import org.apache.flex.compiler.definitions.IQualifiers;
import org.apache.flex.compiler.definitions.IScopedDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.definitions.references.INamespaceReference;
import org.apache.flex.compiler.internal.definitions.AmbiguousDefinition;
import org.apache.flex.compiler.internal.definitions.ClassDefinition;
import org.apache.flex.compiler.internal.definitions.ClassDefinitionBase;
import org.apache.flex.compiler.internal.definitions.FunctionDefinition;
import org.apache.flex.compiler.internal.definitions.InterfaceDefinition;
import org.apache.flex.compiler.internal.definitions.NamespaceDefinition;
import org.apache.flex.compiler.internal.definitions.ScopedDefinitionBase;
import org.apache.flex.compiler.internal.projects.CompilerProject;
import org.apache.flex.compiler.internal.scopes.ASFileScope;
import org.apache.flex.compiler.internal.scopes.ASProjectScope;
import org.apache.flex.compiler.internal.scopes.ASScopeBase;
import org.apache.flex.compiler.internal.scopes.ASScopeCache;
import org.apache.flex.compiler.internal.scopes.NamespaceSetPredicate;
import org.apache.flex.compiler.internal.scopes.PackageScope;
import org.apache.flex.compiler.internal.scopes.TypeScope;
import org.apache.flex.compiler.internal.scopes.WithScope;
import org.apache.flex.compiler.internal.tree.as.ScopedBlockNode;
import org.apache.flex.compiler.internal.workspaces.Workspace;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.scopes.IDefinitionSet;
import org.apache.flex.compiler.tree.as.IScopedNode;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.compiler.workspaces.IWorkspace;
import org.apache.flex.utils.CheapArray;

public abstract class ASScope
extends ASScopeBase {
    private static String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final NamespaceDefinition.IUseNamespaceDirective[] EMPTY_USE_ARRAY = new NamespaceDefinition.IUseNamespaceDirective[0];
    private ASScope containingScope;
    protected NodeReference scopedNodeRef = NodeReference.noReference;
    private Object importsInScope = null;
    private Set<String> packageNames = null;
    private Object usedNamespaces = null;
    private NamespaceDefinition.INamespaceDirective firstNamespaceDirective;
    private NamespaceDefinition.INamespaceDirective lastNamespaceDirective;
    private boolean inWith = false;
    private ScopedDefinitionBase containingDefinition;
    private Map<String, Set<String>> importedNames;

    public ASScope(ASScope containingScope, ScopedBlockNode block) {
        this.setContainingScope(containingScope);
        if (block != null) {
            block.setScope(this);
            this.scopedNodeRef = new NodeReference(block);
        }
    }

    public ASScope(ASScope containingScope) {
        this(containingScope, null);
    }

    public void setContainingScope(ASScope containingScope) {
        this.containingScope = containingScope;
        this.inWith = this.getContainingWithScope() != null;
    }

    @Override
    public void compact() {
        super.compact();
        if (this.importsInScope != null) {
            CheapArray.optimize(this.importsInScope, EMPTY_STRING_ARRAY);
        }
        if (this.usedNamespaces != null) {
            CheapArray.optimize(this.usedNamespaces, EMPTY_USE_ARRAY);
        }
    }

    public void addNamespaceDirective(NamespaceDefinition.INamespaceDirective directive) {
        if (this.lastNamespaceDirective != null) {
            this.lastNamespaceDirective.setNext(directive);
            this.lastNamespaceDirective = directive;
        } else {
            assert (this.firstNamespaceDirective == null);
            this.firstNamespaceDirective = directive;
            this.lastNamespaceDirective = directive;
        }
    }

    public void addUseDirective(NamespaceDefinition.IUseNamespaceDirective useDirective) {
        this.addNamespaceDirective(useDirective);
        if (this.usedNamespaces == null) {
            this.usedNamespaces = CheapArray.create(1);
        }
        CheapArray.add(useDirective, this.usedNamespaces);
    }

    public void addImport(String target) {
        if (this.importsInScope == null) {
            this.importsInScope = CheapArray.create(20);
            this.packageNames = new HashSet<String>();
        }
        CheapArray.add(target, this.importsInScope);
        int idx = target.lastIndexOf(46);
        if (idx != -1) {
            String packName = target.substring(0, idx);
            if (!target.endsWith(".*")) {
                Set<String> s;
                String defName = target.substring(idx + 1, target.length());
                if (this.importedNames == null) {
                    this.importedNames = new HashMap<String, Set<String>>();
                }
                if ((s = this.importedNames.get(defName)) == null) {
                    s = new LinkedHashSet<String>();
                    this.importedNames.put(defName, s);
                }
                s.add(packName);
            }
            this.packageNames.add(packName);
        }
    }

    @Override
    public ASScope getContainingScope() {
        return this.containingScope;
    }

    public void reconnectScopeNode(IScopedNode node) {
        this.scopedNodeRef.reconnectNode(node);
    }

    @Override
    public IScopedNode getScopeNode() {
        IWorkspace w = this.getWorkspace();
        return (IScopedNode)this.scopedNodeRef.getNode(w, this);
    }

    public String[] getImports() {
        return (String[])CheapArray.toArray(this.importsInScope, EMPTY_STRING_ARRAY);
    }

    @Override
    public ScopedDefinitionBase getDefinition() {
        return this.containingDefinition;
    }

    public void setContainingDefinition(ScopedDefinitionBase value) {
        this.containingDefinition = value;
    }

    @Override
    protected String toStringHeader() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toStringHeader());
        ScopedDefinitionBase definition = this.getDefinition();
        if (definition != null) {
            sb.append(" for ");
            sb.append(((Object)definition).toString());
        }
        return sb.toString();
    }

    public boolean isPackageName(String p) {
        if (this.packageNames != null && this.packageNames.contains(p)) {
            return true;
        }
        if (this.containingScope != null) {
            return this.containingScope.isPackageName(p);
        }
        return false;
    }

    public Set<INamespaceDefinition> getExplicitImportQualifiers(CompilerProject project, String name) {
        Set<String> packages;
        LinkedHashSet<INamespaceDefinition> nsSet = new LinkedHashSet<INamespaceDefinition>();
        Workspace workspace = project.getWorkspace();
        this.getContainingScopeExplicitImports(project, name, nsSet);
        if (this.importedNames != null && (packages = this.importedNames.get(name)) != null) {
            for (String s : packages) {
                nsSet.add(workspace.getPackageNamespaceDefinitionCache().get(s, false));
            }
        }
        return nsSet.size() > 0 ? nsSet : Collections.emptySet();
    }

    protected void getContainingScopeExplicitImports(CompilerProject project, String name, Set<INamespaceDefinition> nsSet) {
        if (this.getContainingScope() != null) {
            nsSet.addAll(this.getContainingScope().getExplicitImportQualifiers(project, name));
        }
    }

    protected INamespaceReference[] getUsedNamespaces() {
        return (INamespaceReference[])CheapArray.toArray(this.usedNamespaces, EMPTY_USE_ARRAY);
    }

    public NamespaceDefinition.INamespaceDirective getFirstNamespaceDirective() {
        return this.firstNamespaceDirective;
    }

    public void addLocalImportsToNamespaceSet(IWorkspace workspace, Set<INamespaceDefinition> namespaceSet) {
        String[] imports = this.getImports();
        if (imports != null) {
            for (String importStr : imports) {
                ASImportTarget importTarget = ASImportTarget.get(workspace, importStr);
                if (!importTarget.isWildcard()) continue;
                namespaceSet.add(importTarget.getNamespace());
            }
        }
    }

    public Set<INamespaceDefinition> getNamespaceSetForName(ICompilerProject project, String name) {
        if (this.namespaceSetSameAsContainingScopeNamespaceSet() && this.getContainingScope() != null) {
            return this.getContainingScope().getNamespaceSetForName(project, name);
        }
        CompilerProject compilerProject = (CompilerProject)project;
        ASScopeCache scopeCache = compilerProject.getCacheForScope(this);
        return scopeCache.getNamespaceSetForName(name);
    }

    protected boolean namespaceSetSameAsContainingScopeNamespaceSet() {
        if (this.getImports() != null || this.getUsedNamespaces() != null) {
            return false;
        }
        return this.containingDefinition instanceof FunctionDefinition;
    }

    Set<INamespaceDefinition> getNamespaceSetForNameImpl(ICompilerProject project, String name) {
        ASScope containingScope;
        if (this.namespaceSetSameAsContainingScopeNamespaceSet() && (containingScope = this.getContainingScope()) != null) {
            return containingScope.getNamespaceSetForName(project, name);
        }
        Set<INamespaceDefinition> openNamespaces = this.getNamespaceSet(project);
        Set<INamespaceDefinition> additionalNamespaces = this.getExplicitImportQualifiers((CompilerProject)project, name);
        if (additionalNamespaces != null) {
            LinkedHashSet<INamespaceDefinition> newSet = new LinkedHashSet<INamespaceDefinition>();
            newSet.addAll(openNamespaces);
            newSet.addAll(additionalNamespaces);
            return newSet;
        }
        return openNamespaces;
    }

    public Set<INamespaceDefinition> getNamespaceSet(ICompilerProject project) {
        CompilerProject compilerProject = (CompilerProject)project;
        ASScopeCache scopeCache = compilerProject.getCacheForScope(this);
        return scopeCache.getNamespaceSet();
    }

    Set<INamespaceDefinition> getNamespaceSetImpl(ICompilerProject project) {
        ASScope containingScope;
        if (this.namespaceSetSameAsContainingScopeNamespaceSet() && (containingScope = this.getContainingScope()) != null) {
            return containingScope.getNamespaceSetImpl(project);
        }
        CompilerProject compilerProject = (CompilerProject)project;
        Workspace workspace = compilerProject.getWorkspace();
        Set<INamespaceDefinition> result = new LinkedHashSet<INamespaceDefinition>();
        this.addLocalImportsToNamespaceSet(workspace, result);
        INamespaceReference[] usedNamespaces = this.getUsedNamespaces();
        if (usedNamespaces != null) {
            for (INamespaceReference usedNamespaceReference : usedNamespaces) {
                INamespaceDefinition usedNamespace = usedNamespaceReference.resolveNamespaceReference(compilerProject);
                if (usedNamespace == null) continue;
                result.add(usedNamespace);
            }
        }
        this.addImplicitOpenNamespaces(compilerProject, result);
        this.addNamespacesFromContainingScope(compilerProject, result);
        Set emptyNamespaceSet = Collections.emptySet();
        result = result.size() == 0 ? emptyNamespaceSet : result;
        return result;
    }

    protected void addNamespacesFromContainingScope(CompilerProject compilerProject, Set<INamespaceDefinition> result) {
        ASScope containingScope = this.getContainingScope();
        if (containingScope != null) {
            result.addAll(containingScope.getNamespaceSet(compilerProject));
        }
    }

    public void addImplicitOpenNamespaces(CompilerProject compilerProject, Set<INamespaceDefinition> result) {
    }

    public void getAllPropertiesForScopeChain(CompilerProject project, Collection<IDefinition> defs, Set<INamespaceDefinition> namespaceSet) {
        this.getAllLocalProperties(project, defs, namespaceSet, null);
    }

    public void getAllPropertiesForMemberAccess(CompilerProject project, Collection<IDefinition> defs, Set<INamespaceDefinition> namespaceSet) {
        this.getAllLocalProperties(project, defs, namespaceSet, null);
    }

    public List<IDefinition> getPropertiesByNameForMemberAccess(CompilerProject project, String memberName, Set<INamespaceDefinition> namespaceSet) {
        ArrayList<IDefinition> result = new ArrayList<IDefinition>();
        this.getPropertyForMemberAccess(project, result, memberName, namespaceSet, true);
        return result;
    }

    public IDefinition getPropertyByNameForMemberAccess(CompilerProject project, String memberName, Set<INamespaceDefinition> namespaceSet) {
        ArrayList<IDefinition> defs = new ArrayList<IDefinition>();
        this.getPropertyForMemberAccess(project, defs, memberName, namespaceSet, false);
        return ASScope.getSingleResult(project, defs);
    }

    public void getPropertyForMemberAccess(CompilerProject project, Collection<IDefinition> defs, String baseName, Set<INamespaceDefinition> namespaceSet, boolean findAll) {
        NamespaceSetPredicate nsPred = new NamespaceSetPredicate(project, namespaceSet);
        ASScopeBase.FilteredCollection<IDefinition> filteredDefs = new ASScopeBase.FilteredCollection<IDefinition>(nsPred, defs);
        this.getPropertyForMemberAccess(project, (Collection<IDefinition>)((Object)filteredDefs), baseName, nsPred, findAll);
    }

    protected void getPropertyForMemberAccess(CompilerProject project, Collection<IDefinition> defs, String baseName, NamespaceSetPredicate namespaceSet, boolean findAll) {
        this.getLocalProperty((ICompilerProject)project, defs, baseName, true);
    }

    private Set<INamespaceDefinition> getNamespaceSetForMemberAccess(ICompilerProject project, IDefinition def, boolean isSuperRef) {
        Set<INamespaceDefinition> namespaceSet;
        if (def instanceof InterfaceDefinition) {
            namespaceSet = ((InterfaceDefinition)def).getInterfaceNamespaceSet(project);
        } else if (isSuperRef) {
            namespaceSet = this.getNamespaceSetForSuper(project, def);
        } else {
            namespaceSet = this.getNamespaceSet(project);
            if (def == this.getContainingClass()) {
                namespaceSet.add(((IClassDefinition)def).getProtectedNamespaceReference());
            }
        }
        return namespaceSet;
    }

    public IDefinition getPropertyFromDef(ICompilerProject project, IDefinition def, String name, boolean isSuperRef) {
        CompilerProject compilerProject = (CompilerProject)project;
        Set<INamespaceDefinition> namespaceSet = this.getNamespaceSetForMemberAccess(project, def, isSuperRef);
        return this.getPropertyFromDef(compilerProject, def, name, namespaceSet, false);
    }

    public IDefinition getPropertyFromDef(ICompilerProject project, IDefinition def, String name, Predicate<IDefinition> additional, boolean isSuperRef) {
        NamespaceSetPredicate nsPred = new NamespaceSetPredicate(project, this.getNamespaceSetForMemberAccess(project, def, isSuperRef));
        Predicate combinedPred = Predicates.and(additional, (Predicate)nsPred);
        return this.getPropertyFromDef((CompilerProject)project, def, name, (Predicate<IDefinition>)combinedPred, nsPred, isSuperRef);
    }

    public IDefinition getQualifiedPropertyFromDef(ICompilerProject project, IDefinition def, String name, INamespaceDefinition qualifier, boolean isSuperRef) {
        Object namespaceSet = ImmutableSet.of((Object)qualifier);
        if (isSuperRef) {
            namespaceSet = this.adjustNamespaceSetForSuper(def, (Set<INamespaceDefinition>)namespaceSet);
        }
        return this.getPropertyFromDef((CompilerProject)project, def, name, (Set<INamespaceDefinition>)namespaceSet, false);
    }

    public IDefinition getQualifiedPropertyFromDef(ICompilerProject project, IDefinition def, String name, IQualifiers qualifiers, boolean isSuperRef) {
        Set<INamespaceDefinition> namespaceSet = qualifiers.getNamespaceSet();
        if (isSuperRef) {
            namespaceSet = this.adjustNamespaceSetForSuper(def, namespaceSet);
        }
        return this.getPropertyFromDef((CompilerProject)project, def, name, namespaceSet, false);
    }

    private IDefinition getPropertyFromDef(CompilerProject project, IDefinition def, String name, Set<INamespaceDefinition> namespaceSet, boolean lookForStatics) {
        NamespaceSetPredicate nsPred = new NamespaceSetPredicate(project, namespaceSet);
        return this.getPropertyFromDef(project, def, name, nsPred, nsPred, lookForStatics);
    }

    private IDefinition getPropertyFromDef(CompilerProject project, IDefinition def, String name, Predicate<IDefinition> pred, NamespaceSetPredicate nsPred, boolean lookForStatics) {
        ASScope defScope = (ASScope)(def instanceof IScopedDefinition ? ((IScopedDefinition)def).getContainedScope() : null);
        if (defScope instanceof TypeScope) {
            TypeScope ts = (TypeScope)defScope;
            defScope = lookForStatics ? ts.getStaticScope() : ts.getInstanceScope();
        }
        if (defScope != null) {
            ArrayList<IDefinition> defs = new ArrayList<IDefinition>(1);
            defScope.getPropertyForMemberAccess(project, (Collection<IDefinition>)((Object)new ASScopeBase.FilteredCollection<IDefinition>(pred, defs)), name, nsPred, false);
            return ASScope.getSingleResult(project, defs);
        }
        return null;
    }

    protected void getPropertyForScopeChain(CompilerProject project, Collection<IDefinition> defs, String baseName, NamespaceSetPredicate namespaceSet, boolean findAll) {
        this.getLocalProperty((ICompilerProject)project, defs, baseName, true);
    }

    public List<IDefinition> findProperty(CompilerProject project, String baseName, Set<INamespaceDefinition> namespaceSet, DependencyType dt) {
        return this.findProperty(project, baseName, namespaceSet, dt, false);
    }

    public List<IDefinition> findProperty(CompilerProject project, String baseName, Predicate<IDefinition> additional, Set<INamespaceDefinition> namespaceSet, DependencyType dt) {
        return this.findProperty(project, baseName, additional, namespaceSet, dt, false);
    }

    public void findProperty(Collection<IDefinition> accumulator, CompilerProject project, String baseName, Set<INamespaceDefinition> namespaceSet, DependencyType dt, boolean findAll) {
        NamespaceSetPredicate nsPred = new NamespaceSetPredicate(project, namespaceSet);
        ASScopeBase.FilteredCollection<IDefinition> filteredCollection = new ASScopeBase.FilteredCollection<IDefinition>(nsPred, accumulator);
        this.findProperty((Collection<IDefinition>)((Object)filteredCollection), project, baseName, nsPred, dt, findAll);
    }

    protected void findProperty(Collection<IDefinition> accumulator, CompilerProject project, String baseName, NamespaceSetPredicate nsPred, DependencyType dt, boolean findAll) {
        assert (accumulator.isEmpty()) : "findProperty() should not be called with a non-empty collection";
        assert (baseName.indexOf(46) == -1) : "baseName must not be any sort of qname";
        ASScope lastSearchedScope = null;
        for (ASScope currentScope = this; currentScope != null && (findAll || accumulator.size() == 0); currentScope = currentScope.getContainingScope()) {
            currentScope.getPropertyForScopeChain(project, accumulator, baseName, nsPred, findAll);
            lastSearchedScope = currentScope;
        }
        assert (lastSearchedScope != null || accumulator.size() == 0) : "If accumulator is not empty, which searched scope added to it?";
        boolean searchProjectScope = false;
        if (accumulator.size() == 0) {
            searchProjectScope = true;
        } else if (findAll) {
            searchProjectScope = true;
        } else if (lastSearchedScope instanceof PackageScope || lastSearchedScope instanceof ASFileScope) {
            searchProjectScope = true;
        }
        if (searchProjectScope) {
            ASProjectScope projectScope = project.getScope();
            projectScope.getPropertyForScopeChain(this, accumulator, baseName, nsPred.getNamespaceSet(), dt);
        }
    }

    private static Set<INamespaceDefinition> addStaticProtectedNS(Set<INamespaceDefinition> namespaceSet) {
        Set<INamespaceDefinition> result;
        if (namespaceSet == null) {
            return null;
        }
        HashMap<String, INamespaceDefinition.IStaticProtectedNamespaceDefinition> staticProtectedNamespaces = new HashMap<String, INamespaceDefinition.IStaticProtectedNamespaceDefinition>();
        HashSet<INamespaceDefinition.IProtectedNamespaceDefinition> protectedNamespaces = new HashSet<INamespaceDefinition.IProtectedNamespaceDefinition>();
        for (INamespaceDefinition namespace : namespaceSet) {
            if (namespace instanceof INamespaceDefinition.IStaticProtectedNamespaceDefinition) {
                INamespaceDefinition.IStaticProtectedNamespaceDefinition staticProtectedNamespace = (INamespaceDefinition.IStaticProtectedNamespaceDefinition)namespace;
                staticProtectedNamespaces.put(staticProtectedNamespace.getURI(), staticProtectedNamespace);
                continue;
            }
            if (!(namespace instanceof INamespaceDefinition.IProtectedNamespaceDefinition)) continue;
            protectedNamespaces.add((INamespaceDefinition.IProtectedNamespaceDefinition)namespace);
        }
        HashSet<INamespaceDefinition.IStaticProtectedNamespaceDefinition> addedStaticProtectedNamespaces = new HashSet<INamespaceDefinition.IStaticProtectedNamespaceDefinition>();
        for (INamespaceDefinition.IProtectedNamespaceDefinition protectedNamespace : protectedNamespaces) {
            if (staticProtectedNamespaces.containsKey(protectedNamespace.getURI())) continue;
            addedStaticProtectedNamespaces.add(NamespaceDefinition.createStaticProtectedNamespaceDefinition(protectedNamespace.getURI()));
        }
        if (addedStaticProtectedNamespaces.isEmpty()) {
            result = namespaceSet;
        } else {
            result = new HashSet<INamespaceDefinition>();
            result.addAll(addedStaticProtectedNamespaces);
            result.addAll(namespaceSet);
        }
        return result;
    }

    private List<IDefinition> findProperty(CompilerProject project, String baseName, Set<INamespaceDefinition> namespaceSet, DependencyType dt, boolean findAll) {
        ArrayList<IDefinition> defs = new ArrayList<IDefinition>(1);
        this.findProperty(defs, project, baseName, namespaceSet, dt, findAll);
        return defs;
    }

    private List<IDefinition> findProperty(CompilerProject project, String baseName, Predicate<IDefinition> additional, Set<INamespaceDefinition> namespaceSet, DependencyType dt, boolean findAll) {
        ArrayList<IDefinition> defs = new ArrayList<IDefinition>(1);
        NamespaceSetPredicate nsPred = new NamespaceSetPredicate(project, namespaceSet);
        Predicate pred = Predicates.and(additional, (Predicate)nsPred);
        ASScopeBase.FilteredCollection filteredCollection = new ASScopeBase.FilteredCollection(pred, defs);
        this.findProperty((Collection<IDefinition>)((Object)filteredCollection), project, baseName, nsPred, dt, findAll);
        return defs;
    }

    public boolean isInWith() {
        return this.inWith;
    }

    ASScope getContainingWithScope() {
        ASScope scope;
        for (scope = this; scope != null; scope = scope.getContainingScope()) {
            if (!(scope instanceof WithScope)) continue;
            return scope;
        }
        return scope;
    }

    IDefinition filterWith(IDefinition d, boolean canEscapeWith) {
        if (!this.inWith || canEscapeWith || d == null) {
            return d;
        }
        ASScope withScope = this.getContainingWithScope();
        if (withScope != null) {
            for (ASScope scope = this; scope != null; scope = scope.getContainingScope()) {
                if (scope == withScope) {
                    return null;
                }
                if (scope != d.getContainingScope()) continue;
                return d;
            }
            return null;
        }
        return d;
    }

    public IDefinition findProperty(ICompilerProject project, String baseName, DependencyType dt) {
        return this.findProperty(project, baseName, dt, false);
    }

    public IDefinition findProperty(ICompilerProject project, String baseName, DependencyType dt, boolean canEscapeWith) {
        if (this.canDelegateLookupToContainingScope(baseName)) {
            return this.getContainingScope().findProperty(project, baseName, dt, canEscapeWith);
        }
        assert (baseName.indexOf(46) == -1) : "baseName must not be any sort of qname";
        CompilerProject compilerProject = (CompilerProject)project;
        ASScopeCache scopeCache = compilerProject.getCacheForScope(this);
        return this.filterWith(scopeCache.findProperty(baseName, dt), canEscapeWith);
    }

    public IDefinition findProperty(ICompilerProject project, String baseName, Predicate<IDefinition> additional, DependencyType dt, boolean canEscapeWith) {
        Set<INamespaceDefinition> nsSet = this.getNamespaceSetForName(project, baseName);
        return this.findProperty(project, baseName, additional, nsSet, dt, canEscapeWith);
    }

    public IDefinition findProperty(ICompilerProject project, String baseName, Predicate<IDefinition> additional, Set<INamespaceDefinition> nsSet, DependencyType dt, boolean canEscapeWith) {
        NamespaceSetPredicate nsPred = new NamespaceSetPredicate(project, nsSet);
        ArrayList<IDefinition> storage = new ArrayList<IDefinition>();
        Predicate pred = Predicates.and(additional, (Predicate)nsPred);
        ASScopeBase.FilteredCollection defs = new ASScopeBase.FilteredCollection(pred, storage);
        this.findProperty((Collection<IDefinition>)((Object)defs), (CompilerProject)project, baseName, nsPred, dt, false);
        IDefinition def = null;
        def = ASScope.getSingleResult(project, storage);
        return this.filterWith(def, canEscapeWith);
    }

    static IDefinition getSingleResult(ICompilerProject project, List<IDefinition> defs) {
        IDefinition def;
        switch (defs.size()) {
            case 0: {
                def = null;
                break;
            }
            case 1: {
                def = defs.get(0);
                assert (def.isInProject(project));
                break;
            }
            default: {
                IDefinition d = AmbiguousDefinition.resolveAmbiguities(project, defs);
                def = d != null ? d : AmbiguousDefinition.get();
            }
        }
        return def;
    }

    protected boolean canDelegateLookupToContainingScope(String name) {
        return this.namespaceSetSameAsContainingScopeNamespaceSet() && this.getContainingScope() != null && this.getLocalDefinitionSetByName(name) == null;
    }

    public IDefinition findPropertyQualified(ICompilerProject project, INamespaceDefinition qual, String baseName, DependencyType dt) {
        return this.findPropertyQualified(project, qual, baseName, dt, false);
    }

    public IDefinition findPropertyQualified(ICompilerProject project, Predicate<IDefinition> additional, INamespaceDefinition qual, String baseName, DependencyType dt) {
        if (qual == null) {
            return null;
        }
        NamespaceSetPredicate nsPred = new NamespaceSetPredicate(project, (Set<INamespaceDefinition>)ImmutableSet.of((Object)qual));
        Predicate pred = Predicates.and(additional, (Predicate)nsPred);
        ArrayList<IDefinition> defs = new ArrayList<IDefinition>();
        ASScopeBase.FilteredCollection filteredCollection = new ASScopeBase.FilteredCollection(pred, defs);
        this.findProperty((Collection<IDefinition>)((Object)filteredCollection), (CompilerProject)project, baseName, nsPred, dt, false);
        return ASScope.getSingleResult(project, defs);
    }

    public IDefinition findPropertyQualified(ICompilerProject project, INamespaceDefinition qual, String baseName, DependencyType dt, boolean canEscapeWith) {
        assert (baseName.indexOf(46) == -1) : "baseName must not be any sort of qname";
        if (qual == null) {
            return null;
        }
        CompilerProject compilerProject = (CompilerProject)project;
        ASScopeCache scopeCache = compilerProject.getCacheForScope(this);
        IDefinition definition = scopeCache.findPropertyQualified(qual, baseName, dt);
        return this.filterWith(definition, canEscapeWith);
    }

    public IDefinition findPropertyQualified(ICompilerProject project, IQualifiers qual, String baseName, DependencyType dt, boolean canEscapeWith) {
        if (qual == null || qual.getNamespaceCount() == 0) {
            return null;
        }
        if (qual.getNamespaceCount() == 1) {
            return this.findPropertyQualified(project, qual.getFirst(), baseName, dt, canEscapeWith);
        }
        List<IDefinition> defs = this.findProperty((CompilerProject)project, baseName, qual.getNamespaceSet(), dt);
        return this.filterWith(ASScope.getSingleResult(project, defs), canEscapeWith);
    }

    public Set<INamespaceDefinition> getNamespaceSetForSuper(ICompilerProject project, IDefinition superDef) {
        Set<INamespaceDefinition> nsSet = this.getNamespaceSet(project);
        return this.adjustNamespaceSetForSuper(superDef, nsSet);
    }

    public Set<INamespaceDefinition> adjustNamespaceSetForSuper(IDefinition superDef, Set<INamespaceDefinition> nsSet) {
        ClassDefinitionBase containingClass = this.getContainingClass();
        if (superDef instanceof ClassDefinition && nsSet.contains(containingClass.getProtectedNamespaceReference())) {
            LinkedHashSet<INamespaceDefinition> adjustedSet = new LinkedHashSet<INamespaceDefinition>();
            adjustedSet.addAll(nsSet);
            adjustedSet.remove(containingClass.getProtectedNamespaceReference());
            adjustedSet.add(((ClassDefinition)superDef).getProtectedNamespaceReference());
            return adjustedSet;
        }
        return nsSet;
    }

    public ClassDefinitionBase getContainingClass() {
        ScopedDefinitionBase sdb = null;
        for (ASScope scope = this; scope != null && sdb == null; scope = scope.getContainingScope()) {
            sdb = scope.getDefinition();
        }
        if (sdb instanceof ClassDefinitionBase) {
            return (ClassDefinitionBase)sdb;
        }
        if (sdb != null) {
            return (ClassDefinitionBase)sdb.getAncestorOfType(ClassDefinitionBase.class);
        }
        return null;
    }

    public ASFileScope getFileScope() {
        ASScope scope = this;
        while (!(scope instanceof ASFileScope) && (scope = scope.getContainingScope()) != null) {
        }
        return (ASFileScope)scope;
    }

    public IWorkspace getWorkspace() {
        return this.getFileScope().getWorkspace();
    }

    public String getContainingSourcePath(String qName, ICompilerProject project) {
        ASScope containingScope = this.getContainingScope();
        if (containingScope != null) {
            return containingScope.getContainingSourcePath(qName, project);
        }
        return null;
    }

    public boolean hasAnyBindableDefinitions() {
        for (IDefinitionSet set : this.getAllLocalDefinitionSets()) {
            int n = set.getSize();
            for (int i = 0; i < n; ++i) {
                IDefinition d = set.getDefinition(i);
                if (!d.isBindable() || d.isStatic()) continue;
                return true;
            }
        }
        return false;
    }

    public IScopedDefinition getContainingDefinition() {
        return this.containingDefinition;
    }

    public void setAsContainingScopeOfAnonymousFunction(FunctionDefinition anonymousFunction) {
        anonymousFunction.setContainingScope(this);
    }

    public void addDependencyOnBuiltinType(ICompilerProject project, IASLanguageConstants.BuiltinType builtinType, DependencyType dependencyType) {
        if (this.containingScope != null) {
            this.containingScope.addDependencyOnBuiltinType(project, builtinType, dependencyType);
        }
    }

    void addDependencyOnBuiltinTypeImpl(CompilerProject project, IASLanguageConstants.BuiltinType builtinType, DependencyType dependencyType) {
        ITypeDefinition definition = project.getBuiltinType(builtinType);
        if (definition != null && builtinType != IASLanguageConstants.BuiltinType.ANY_TYPE && builtinType != IASLanguageConstants.BuiltinType.VOID) {
            ASProjectScope projectScope = project.getScope();
            ICompilationUnit from = projectScope.getCompilationUnitForScope(this);
            ICompilationUnit to = projectScope.getCompilationUnitForDefinition(definition);
            String qname = definition.getQualifiedName();
            project.addDependency(from, to, dependencyType, qname);
        }
    }
}

