/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.projects;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.flex.compiler.internal.caches.SWFCache;
import org.apache.flex.compiler.internal.projects.ASProject;
import org.apache.flex.compiler.internal.projects.CompilerProject;
import org.apache.flex.compiler.internal.units.ResourceBundleCompilationUnit;
import org.apache.flex.compiler.internal.units.SWCCompilationUnit;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.projects.IFlexProject;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.swc.ISWC;
import org.apache.flex.swc.ISWCFileEntry;
import org.apache.flex.swc.ISWCLibrary;
import org.apache.flex.swc.ISWCManager;
import org.apache.flex.swc.ISWCScript;
import org.apache.flex.swf.ITagContainer;
import org.apache.flex.utils.FileID;
import org.apache.flex.utils.FilenameNormalization;

public final class LibraryPathManager {
    public static final String SWC_EXT = "swc";
    public static final String ANE_EXT = "ane";
    public static final String DOT_SWC_EXT = ".swc";
    public static final String DOT_ANE_EXT = ".ane";
    private static final FilenameFilter SWC_FILTER = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)".swc", (IOCase)IOCase.INSENSITIVE), FileFilterUtils.suffixFileFilter((String)".ane", (IOCase)IOCase.INSENSITIVE)});
    private final ASProject flashProject;
    private final Map<String, String> libraryFilePaths;

    public static boolean isSWCFile(File file) {
        return SWC_FILTER.accept(file.getParentFile(), file.getName());
    }

    public static Set<FileID> discoverSWCFilePaths(File[] libraryPath) {
        LinkedHashSet<FileID> swcFiles = new LinkedHashSet<FileID>();
        for (File path : libraryPath) {
            if (path.isDirectory()) {
                File[] swcsInFolder;
                for (File file : swcsInFolder = path.listFiles(SWC_FILTER)) {
                    swcFiles.add(new FileID(file));
                }
                continue;
            }
            swcFiles.add(new FileID(path));
        }
        return swcFiles;
    }

    public static Set<File> discoverSWCFilePathsAsFiles(File[] libraryPath) {
        HashSet<File> ret = new HashSet<File>();
        Set<FileID> fileIds = LibraryPathManager.discoverSWCFilePaths(libraryPath);
        for (FileID f : fileIds) {
            ret.add(f.getFile());
        }
        return ret;
    }

    public LibraryPathManager(ASProject flashProject) {
        Preconditions.checkNotNull((Object)flashProject, (Object)"Flash project cannot be null.");
        this.flashProject = flashProject;
        this.libraryFilePaths = new LinkedHashMap<String, String>();
    }

    private List<ICompilationUnit> computeUnitsToAdd(Collection<String> swcFilePaths) {
        int order = 0;
        LinkedList<ICompilationUnit> result = new LinkedList<ICompilationUnit>();
        ISWCManager swcManager = this.flashProject.getWorkspace().getSWCManager();
        for (String swcFilePath : swcFilePaths) {
            File swcFile = new File(swcFilePath);
            ISWC swc = swcManager.get(swcFile);
            this.computeUnitsToAdd(swc, order, result);
            ++order;
        }
        return result;
    }

    private void computeUnitsToAdd(ISWC swc, int order, List<ICompilationUnit> cus) {
        for (ISWCLibrary library : swc.getLibraries()) {
            for (ISWCScript script : library.getScripts()) {
                ArrayList<String> qnames = new ArrayList<String>(script.getDefinitions().size());
                for (String definitionQName : script.getDefinitions()) {
                    qnames.add(definitionQName.replace(":", "."));
                }
                SWCCompilationUnit cu = new SWCCompilationUnit(this.flashProject, swc, library, script, qnames, order);
                cus.add(cu);
            }
        }
        if (this.flashProject instanceof IFlexProject && ((IFlexProject)((Object)this.flashProject)).getLocales().size() > 0) {
            for (ISWCFileEntry entry : swc.getFiles().values()) {
                ICompilationUnit cu;
                if (!FilenameUtils.getExtension((String)entry.getPath()).equals("properties") || (cu = this.createResourceBundleCompilationUnit(swc, entry)) == null) continue;
                cus.add(cu);
            }
        }
    }

    public void setLibraryPath(File[] libraryPath) {
        assert (libraryPath != null) : "Library path cannot be null";
        Set<FileID> swcFilePaths = LibraryPathManager.discoverSWCFilePaths(libraryPath);
        LinkedHashSet<String> swcFilesToAdd = new LinkedHashSet<String>();
        LinkedHashSet<String> swcFilesToRemove = new LinkedHashSet<String>();
        LinkedHashSet<String> swcFilePathStrings = new LinkedHashSet<String>();
        for (FileID f : swcFilePaths) {
            swcFilePathStrings.add(f.getFile().getAbsolutePath());
        }
        this.computeAddRemoveSet(swcFilePathStrings, swcFilesToAdd, swcFilesToRemove);
        this.libraryFilePaths.clear();
        for (FileID path : swcFilePaths) {
            this.libraryFilePaths.put(path.getFile().getAbsolutePath(), null);
        }
        this.updateLibraryPath(swcFilesToAdd, swcFilesToRemove);
    }

    public void setLibrarySourcePath(File library, File sourceDir) {
        if (library == null) {
            return;
        }
        String swcPath = FilenameNormalization.normalize(library.getPath());
        if (sourceDir == null) {
            this.libraryFilePaths.put(swcPath, null);
        } else {
            if (!(sourceDir.exists() && sourceDir.isDirectory() && this.libraryFilePaths.containsKey(swcPath))) {
                return;
            }
            String sourcePath = FilenameNormalization.normalize(sourceDir.getPath());
            this.libraryFilePaths.put(swcPath, sourcePath);
        }
    }

    public String getAttachedSourceDirectory(String libraryFilename) {
        String swcPath = FilenameNormalization.normalize(libraryFilename);
        String attachedSourceDirectory = this.libraryFilePaths.get(swcPath);
        return attachedSourceDirectory;
    }

    public static String getAttachedSourceFilename(String sourceDirectory, String qualifiedName) {
        String[] knownExtensions;
        if (sourceDirectory == null) {
            return null;
        }
        String relativePath = qualifiedName.replace('.', File.separatorChar);
        for (String ext : knownExtensions = new String[]{"mxml", "as", "fxg"}) {
            File f = new File(sourceDirectory, relativePath.concat(".").concat(ext));
            if (!f.exists()) continue;
            return FilenameNormalization.normalize(f).getAbsolutePath();
        }
        return null;
    }

    public File getLibrarySourcePath(File library) {
        String swcPath = FilenameNormalization.normalize(library.getPath());
        String sourcePath = this.libraryFilePaths.get(swcPath);
        if (sourcePath == null) {
            return null;
        }
        return new File(sourcePath);
    }

    private void computeAddRemoveSet(Set<String> swcFilePaths, Collection<String> swcFilesToAdd, Collection<String> swcFilesToRemove) {
        for (String swcPath : swcFilePaths) {
            File f = new File(swcPath);
            if (!f.exists()) continue;
            swcFilesToAdd.add(swcPath);
        }
        Iterator<String> swcFilePathsIter = swcFilePaths.iterator();
        boolean swcOrderDiffers = false;
        for (String existingSWCFilePath : this.libraryFilePaths.keySet()) {
            String newSWCFilePath = null;
            if (!swcOrderDiffers) {
                if (!swcFilePathsIter.hasNext()) {
                    swcOrderDiffers = true;
                } else {
                    newSWCFilePath = swcFilePathsIter.next();
                    if (existingSWCFilePath.equals(newSWCFilePath)) {
                        swcFilesToAdd.remove(existingSWCFilePath);
                        continue;
                    }
                    swcOrderDiffers = true;
                }
            }
            if (!swcOrderDiffers) continue;
            swcFilesToRemove.add(existingSWCFilePath);
            if (swcFilesToAdd.contains(existingSWCFilePath)) continue;
            swcFilesToAdd.remove(existingSWCFilePath);
        }
    }

    private void updateLibraryPath(Collection<String> swcFilesToAdd, Collection<String> swcFilesToRemove) {
        List<ICompilationUnit> unitsToAdd = this.computeUnitsToAdd(swcFilesToAdd);
        List<ICompilationUnit> unitsToRemove = this.computeUnitsToRemove(swcFilesToRemove);
        assert (unitsToAdd != null);
        assert (unitsToRemove != null);
        this.flashProject.updateCompilationUnitsForPathChange(unitsToRemove, unitsToAdd);
    }

    private List<ICompilationUnit> computeUnitsToRemove(Collection<String> swcFilesToRemove) {
        ArrayList<ICompilationUnit> unitsToRemove = new ArrayList<ICompilationUnit>();
        for (String swcFilePath : swcFilesToRemove) {
            Collection<ICompilationUnit> compilationUnits = this.flashProject.getCompilationUnits(swcFilePath);
            ArrayList<ICompilationUnit> swcCompilationUnits = new ArrayList<ICompilationUnit>(compilationUnits.size());
            for (ICompilationUnit cu : compilationUnits) {
                switch (cu.getCompilationUnitType()) {
                    case SWC_UNIT: 
                    case RESOURCE_UNIT: {
                        swcCompilationUnits.add(cu);
                    }
                }
            }
            unitsToRemove.addAll(swcCompilationUnits);
        }
        return unitsToRemove;
    }

    protected ImmutableList<ISWC> getLibrarySWCs() {
        ISWCManager swcManager = this.flashProject.getWorkspace().getSWCManager();
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (String libraryPath : this.libraryFilePaths.keySet()) {
            File swcFile = new File(libraryPath);
            if (!swcFile.exists()) continue;
            ISWC swc = swcManager.get(swcFile);
            builder.add((Object)swc);
        }
        return builder.build();
    }

    protected boolean invalidate(Collection<File> swcFiles) {
        HashSet<String> swcFilePaths = new HashSet<String>(swcFiles.size());
        for (File swcFile : swcFiles) {
            String swcFilePath;
            if (swcFile == null || !this.libraryFilePaths.containsKey(swcFilePath = FilenameNormalization.normalize(swcFile.getPath()))) continue;
            swcFilePaths.add(swcFilePath);
        }
        if (swcFilePaths.isEmpty()) {
            return false;
        }
        this.updateLibraryPath(swcFilePaths, swcFilePaths);
        return true;
    }

    protected void invalidate(ISWC swc) {
        String swcFilename = swc.getSWCFile().getAbsolutePath();
        final Collection<ICompilationUnit> unitsToRemove = this.flashProject.getCompilationUnits(swcFilename);
        final LinkedList<ICompilationUnit> unitsToAdd = new LinkedList<ICompilationUnit>();
        this.computeUnitsToAdd(swc, 0, unitsToAdd);
        this.flashProject.getWorkspace().swcChanged(unitsToRemove, unitsToAdd, new Runnable(){

            @Override
            public final void run() {
                LibraryPathManager.this.flashProject.updateCompilationUnitsForPathChange(unitsToRemove, unitsToAdd);
            }
        });
    }

    public ISWCFileEntry getFileEntryFromLibraryPath(String filename) {
        ISWC swc;
        ImmutableList<ISWC> swcs = this.getLibrarySWCs();
        ISWCFileEntry fileEntry = null;
        Iterator i$ = swcs.iterator();
        while (i$.hasNext() && (fileEntry = (swc = (ISWC)i$.next()).getFile(filename)) == null) {
        }
        return fileEntry;
    }

    private ICompilationUnit createResourceBundleCompilationUnit(ISWC swc, ISWCFileEntry fileEntry) {
        String path = FilenameUtils.separatorsToSystem((String)fileEntry.getPath());
        String[] segments = (String[])Iterables.toArray((Iterable)Splitter.on((String)File.separator).split((CharSequence)path), String.class);
        if (segments.length > 2 && "locale".equals(segments[0])) {
            StringBuilder qName = new StringBuilder();
            for (int i = 2; i < segments.length - 1; ++i) {
                qName.append(segments[i]);
                qName.append('.');
            }
            qName.append(FilenameUtils.getBaseName((String)segments[segments.length - 1]));
            return new ResourceBundleCompilationUnit((CompilerProject)this.flashProject, fileEntry, qName.toString(), segments[1]);
        }
        return null;
    }

    void collectProblems(Collection<ICompilerProblem> problems) {
        ISWCManager swcManager = this.flashProject.getWorkspace().getSWCManager();
        for (String swcPath : this.libraryFilePaths.keySet()) {
            File swcFile = new File(swcPath);
            ISWC swc = swcManager.get(swcFile);
            problems.addAll(swc.getProblems());
            for (ISWCLibrary library : swc.getLibraries()) {
                SWFCache.SWFInSWCCacheKey key = SWFCache.createKey(swc, library.getPath());
                ITagContainer tags = (ITagContainer)swcManager.getSWFCache().get(key);
                problems.addAll(tags.getProblems());
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String libraryFilePath : this.libraryFilePaths.keySet().toArray(new String[0])) {
            sb.append(libraryFilePath);
            sb.append('\n');
        }
        return sb.toString();
    }
}

