/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.fxg.logging;

import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.io.IOUtils;
import org.apache.flex.compiler.internal.fxg.logging.AbstractLogger;

public class SystemLogger
extends AbstractLogger {
    public SystemLogger() {
        super(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(int level, Object message, Throwable t, String location, int line, int column) {
        if (level < this.getLevel()) {
            return;
        }
        PrintStream ps = level > 20000 ? System.err : System.out;
        try {
            StringBuilder sb = new StringBuilder();
            if (location != null) {
                sb.append(location).append(":");
            }
            if (line > 0) {
                sb.append(" Line ").append(line);
                if (column > 0) {
                    sb.append(", Column ").append(column);
                }
            }
            if (message != null) {
                sb.append(": ").append(message);
            }
            if (t != null) {
                sb.append(": ").append(t.getLocalizedMessage());
            }
            ps.println(sb.toString());
        }
        catch (Exception ex) {
        }
        finally {
            IOUtils.closeQuietly((OutputStream)ps);
        }
    }
}

