/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.definitions.mxml;

import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.definitions.references.IReference;
import org.apache.flex.compiler.internal.definitions.ParameterDefinition;
import org.apache.flex.compiler.internal.scopes.ASScope;
import org.apache.flex.compiler.internal.scopes.FunctionScope;
import org.apache.flex.compiler.tree.mxml.IMXMLEventSpecifierNode;

public final class MXMLEventHandlerScope
extends FunctionScope {
    private static final String EVENT_HANDLER_PARAMETER_NAME = "event";
    private ParameterDefinition eventParameter;
    private final IMXMLEventSpecifierNode eventSpecifierNode;

    public MXMLEventHandlerScope(IMXMLEventSpecifierNode eventSpecifierNode) {
        super((ASScope)eventSpecifierNode.getClassDefinitionNode().getClassDefinition().getContainedScope());
        this.eventSpecifierNode = eventSpecifierNode;
    }

    public void buildEventParameter(IReference typeRef) {
        assert (this.eventParameter == null) : "Event parameter should only be built once!";
        this.eventParameter = new ParameterDefinition(EVENT_HANDLER_PARAMETER_NAME);
        this.eventParameter.setTypeReference(typeRef);
        this.eventParameter.setPublic();
        this.eventParameter.setImplicit();
        this.addDefinition(this.eventParameter);
    }

    public ParameterDefinition getEventParameterDefinition() {
        return this.eventParameter;
    }

    public ISourceLocation getLocation() {
        return this.eventSpecifierNode;
    }
}

