/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.definitions;

import com.google.common.collect.Iterables;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.flex.compiler.common.DependencyType;
import org.apache.flex.compiler.common.RecursionGuard;
import org.apache.flex.compiler.constants.IMetaAttributeConstants;
import org.apache.flex.compiler.definitions.IClassDefinition;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.IInterfaceDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.definitions.metadata.IMetaTag;
import org.apache.flex.compiler.definitions.references.IReference;
import org.apache.flex.compiler.internal.definitions.AmbiguousDefinition;
import org.apache.flex.compiler.internal.definitions.InterfaceDefinition;
import org.apache.flex.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.flex.compiler.internal.projects.CompilerProject;
import org.apache.flex.compiler.internal.scopes.ASProjectScope;
import org.apache.flex.compiler.internal.semantics.SemanticUtils;
import org.apache.flex.compiler.internal.tree.as.ClassNode;
import org.apache.flex.compiler.problems.AmbiguousReferenceProblem;
import org.apache.flex.compiler.problems.DuplicateInterfaceProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.problems.UnknownInterfaceProblem;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.scopes.IDefinitionSet;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.as.ITypeNode;
import org.apache.flex.utils.Version;

public abstract class ClassDefinitionBase
extends TypeDefinitionBase
implements IClassDefinition {
    private SoftReference<AlternativeInformation[]> alternatives = null;

    protected ClassDefinitionBase(String name) {
        super(name);
    }

    @Override
    public IClassDefinition[] resolveAncestry(ICompilerProject project) {
        return (IClassDefinition[])Iterables.toArray(this.classIterable(project, true), IClassDefinition.class);
    }

    public InterfaceDefinition resolveImplementedInterface(ICompilerProject project, int i) {
        TypeDefinitionBase typeDefinition;
        IReference[] implementedInterfaces = this.getImplementedInterfaceReferences();
        if (implementedInterfaces != null && implementedInterfaces.length > i && (typeDefinition = this.resolveType(implementedInterfaces[i], project, DependencyType.INHERITANCE)) instanceof IInterfaceDefinition) {
            return (InterfaceDefinition)typeDefinition;
        }
        return null;
    }

    @Override
    public IInterfaceDefinition[] resolveImplementedInterfaces(ICompilerProject project) {
        if (this.getImplementedInterfaceReferences().length > 0) {
            return ((CompilerProject)project).getCacheForScope(this.getContainedScope()).resolveInterfaces();
        }
        return new IInterfaceDefinition[0];
    }

    @Override
    public IInterfaceDefinition[] resolveInterfacesImpl(ICompilerProject project) {
        IInterfaceDefinition[] implementedInterfaces = this.resolveImplementedInterfaces(project, null);
        return this.filterNullInterfaces(implementedInterfaces);
    }

    public InterfaceDefinition[] resolveImplementedInterfaces(ICompilerProject project, Collection<ICompilerProblem> problems) {
        return this.resolveImplementedInterfaces(project, problems, true);
    }

    public InterfaceDefinition[] resolveImplementedInterfaces(ICompilerProject project, Collection<ICompilerProblem> problems, boolean includeImplicits) {
        IReference[] implementedInterfaces = this.getImplementedInterfaceReferences();
        if (implementedInterfaces != null) {
            TypeDefinitionBase iEventDispatcher;
            int n = implementedInterfaces.length;
            InterfaceDefinition[] result = new InterfaceDefinition[n];
            HashSet<InterfaceDefinition> seenInterfaces = null;
            if (problems != null) {
                seenInterfaces = new HashSet<InterfaceDefinition>();
            }
            for (int i = 0; i < n; ++i) {
                IASNode node;
                IReference implementedInterface = implementedInterfaces[i];
                TypeDefinitionBase typeDefinition = this.resolveType(implementedInterface, project, DependencyType.INHERITANCE);
                if (!(typeDefinition instanceof InterfaceDefinition)) {
                    IDefinition idef = null;
                    if (typeDefinition == null) {
                        idef = implementedInterface.resolve(project, this.getContainingASScope(), DependencyType.INHERITANCE, true);
                    }
                    if (problems != null) {
                        if (idef instanceof AmbiguousDefinition) {
                            problems.add(new AmbiguousReferenceProblem(this.getNode(), implementedInterface.getDisplayString()));
                        } else {
                            problems.add(this.unknownInterfaceProblem(implementedInterface, i));
                        }
                    }
                    typeDefinition = null;
                } else if (seenInterfaces != null) {
                    if (seenInterfaces.contains(typeDefinition) && problems != null) {
                        problems.add(this.duplicateInterfaceProblem(implementedInterface, i));
                    }
                    seenInterfaces.add((InterfaceDefinition)typeDefinition);
                }
                if (problems != null && typeDefinition != null && typeDefinition.isDeprecated() && !SemanticUtils.hasDeprecatedAncestor(node = this.getInterfaceNode(i))) {
                    ICompilerProblem problem = SemanticUtils.createDeprecationProblem(typeDefinition, node);
                    problems.add(problem);
                }
                result[i] = (InterfaceDefinition)typeDefinition;
            }
            if (includeImplicits && this.needsEventDispatcher(project) && (iEventDispatcher = this.resolveType("flash.events.IEventDispatcher", project, null)) instanceof InterfaceDefinition) {
                InterfaceDefinition[] newResult = new InterfaceDefinition[result.length + 1];
                System.arraycopy(result, 0, newResult, 0, result.length);
                newResult[result.length] = (InterfaceDefinition)iEventDispatcher;
                result = newResult;
            }
            return result;
        }
        return new InterfaceDefinition[0];
    }

    public boolean needsEventDispatcher(ICompilerProject project) {
        if (this.isImplicit()) {
            return false;
        }
        return ((CompilerProject)project).getCacheForScope(this.getContainedScope()).needsEventDispatcher();
    }

    public boolean computeNeedsEventDispatcher(ICompilerProject project) {
        TypeDefinitionBase iEventDispatcher;
        if ((this.isBindable() || this.getContainedScope().hasAnyBindableDefinitions()) && (iEventDispatcher = this.resolveType("flash.events.IEventDispatcher", project, null)) != null) {
            InterfaceDefinition[] interfs;
            IClassDefinition baseClass = this.resolveBaseClass(project);
            if (baseClass != null && baseClass.isInstanceOf(iEventDispatcher, project)) {
                return false;
            }
            for (InterfaceDefinition interf : interfs = this.resolveImplementedInterfaces(project, null, false)) {
                if (interf == null || !interf.isInstanceOf(iEventDispatcher, project)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean needsStaticEventDispatcher(ICompilerProject project) {
        boolean isBindable = this.isBindable();
        Collection<IDefinitionSet> defs = this.getContainedScope().getAllLocalDefinitionSets();
        for (IDefinitionSet set : defs) {
            int l = set.getSize();
            for (int i = 0; i < l; ++i) {
                IDefinition d = set.getDefinition(i);
                if (isBindable && d.isStatic()) {
                    return true;
                }
                if (!d.isStatic() || !d.isBindable()) continue;
                return true;
            }
        }
        return false;
    }

    private UnknownInterfaceProblem unknownInterfaceProblem(IReference interfRef, int idx) {
        IASNode node = this.getInterfaceNode(idx);
        if (node != null) {
            return new UnknownInterfaceProblem(node, interfRef.getDisplayString());
        }
        return new UnknownInterfaceProblem(this, interfRef.getDisplayString());
    }

    private DuplicateInterfaceProblem duplicateInterfaceProblem(IReference interfRef, int idx) {
        IASNode node = this.getInterfaceNode(idx);
        if (node != null) {
            return new DuplicateInterfaceProblem(node, this.getBaseName(), interfRef.getDisplayString());
        }
        return new DuplicateInterfaceProblem(this, this.getBaseName(), interfRef.getDisplayString());
    }

    private IASNode getInterfaceNode(int i) {
        ITypeNode typeNode;
        IASNode site = typeNode = this.getNode();
        if (typeNode instanceof ClassNode) {
            ClassNode clsNode = (ClassNode)typeNode;
            IExpressionNode[] interfs = clsNode.getImplementedInterfaceNodes();
            site = interfs[i];
        }
        return site;
    }

    public Iterable<IClassDefinition> classIterable(final ICompilerProject project, final boolean includeThis) {
        final ClassDefinitionBase initialClass = this;
        return new Iterable<IClassDefinition>(){

            @Override
            public Iterator<IClassDefinition> iterator() {
                return initialClass.classIterator(project, includeThis);
            }
        };
    }

    @Override
    public IClassDefinition.IClassIterator classIterator(ICompilerProject project, boolean includeThis) {
        return new ClassIterator(this, project, includeThis);
    }

    @Override
    public Iterator<IInterfaceDefinition> interfaceIterator(ICompilerProject project) {
        return new InterfaceDefinition.InterfaceIterator(this, project, null);
    }

    @Override
    public boolean isInstanceOf(ITypeDefinition type, ICompilerProject project) {
        if (type == this) {
            return true;
        }
        if (type instanceof IClassDefinition) {
            IClassDefinition.IClassIterator iter = this.classIterator(project, false);
            while (iter.hasNext()) {
                IClassDefinition cls = (IClassDefinition)iter.next();
                if (cls != type) continue;
                return true;
            }
            return false;
        }
        if (type instanceof IInterfaceDefinition) {
            Iterator<IInterfaceDefinition> iter = this.interfaceIterator(project);
            while (iter.hasNext()) {
                IInterfaceDefinition intf = iter.next();
                if (intf != type) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public Set<IInterfaceDefinition> resolveAllInterfaces(ICompilerProject project) {
        HashSet<IInterfaceDefinition> interfaces = new HashSet<IInterfaceDefinition>();
        Iterator<IInterfaceDefinition> iter = this.interfaceIterator(project);
        while (iter.hasNext()) {
            IInterfaceDefinition intf = iter.next();
            interfaces.add(intf);
        }
        return interfaces;
    }

    private AlternativeInformation[] getAlternatives() {
        AlternativeInformation[] result = null;
        if (this.alternatives != null) {
            result = this.alternatives.get();
        }
        if (result != null) {
            return result;
        }
        result = this.buildAlternatives();
        this.alternatives = new SoftReference<AlternativeInformation[]>(result);
        return result;
    }

    private AlternativeInformation[] buildAlternatives() {
        IMetaTag[] metaTags = this.getMetaTagsByName("Alternative");
        if (metaTags == null || metaTags.length == 0) {
            return new AlternativeInformation[0];
        }
        LinkedList<AlternativeInformation> result = new LinkedList<AlternativeInformation>();
        for (IMetaTag metaTag : metaTags) {
            String replacement = metaTag.getAttributeValue("replacement");
            if (replacement == null || replacement.isEmpty() || replacement.compareTo("none") == 0) continue;
            String sinceString = metaTag.getAttributeValue("since");
            Version sinceVersion = null;
            if (sinceString != null) {
                try {
                    sinceVersion = new Version(sinceString);
                }
                catch (Exception e) {
                    continue;
                }
            }
            result.add(new AlternativeInformation(replacement, sinceVersion));
        }
        return result.toArray(new AlternativeInformation[result.size()]);
    }

    @Override
    public IClassDefinition[] getAlternativeClasses(ICompilerProject project, Version version) {
        AlternativeInformation[] alternatives = this.getAlternatives();
        ArrayList<IClassDefinition> result = new ArrayList<IClassDefinition>(alternatives.length);
        ASProjectScope projectScope = (ASProjectScope)project.getScope();
        for (AlternativeInformation alternative : alternatives) {
            String replacement;
            IDefinition def;
            Version alternativeSinceVersion = alternative.getSinceVersion();
            if (alternativeSinceVersion.compareBugFixVersionTo(version) < 0 || !((def = projectScope.findDefinitionByName(replacement = alternative.getReplacement())) instanceof IClassDefinition)) continue;
            result.add((IClassDefinition)def);
        }
        return result.toArray(new IClassDefinition[result.size()]);
    }

    @Override
    public IMetaTag[] findMetaTagsByName(String name, ICompilerProject project) {
        if (IMetaAttributeConstants.NON_INHERITING_METATAGS.contains(name)) {
            return this.getMetaTagsByName(name);
        }
        ArrayList<IMetaTag> list = new ArrayList<IMetaTag>();
        IClassDefinition.IClassIterator classIterator = this.classIterator(project, true);
        while (classIterator.hasNext()) {
            IClassDefinition c = (IClassDefinition)classIterator.next();
            for (IMetaTag metaTag : c.getMetaTagsByName(name)) {
                list.add(metaTag);
            }
        }
        return list.toArray(new IMetaTag[0]);
    }

    @Override
    public abstract IReference[] getImplementedInterfaceReferences();

    @Override
    public String getIconFile() {
        IMetaTag iconFileMetaTag = this.getMetaTagByName("IconFile");
        return iconFileMetaTag != null ? iconFileMetaTag.getValue() : null;
    }

    private static final class AlternativeInformation {
        private String replacement;
        private Version sinceVersion;

        public AlternativeInformation(String replacement, Version sinceVersion) {
            this.replacement = replacement;
            this.sinceVersion = sinceVersion;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public Version getSinceVersion() {
            return this.sinceVersion;
        }
    }

    public static class ClassIterator
    implements IClassDefinition.IClassIterator {
        private ICompilerProject project;
        private IClassDefinition nextClass;
        private RecursionGuard guard;
        private boolean foundLoop;

        public ClassIterator(IClassDefinition thisClass, ICompilerProject project, boolean includeThis) {
            assert (thisClass != null);
            assert (project != null);
            this.project = project;
            this.nextClass = includeThis ? thisClass : thisClass.resolveBaseClass(project);
            this.guard = new RecursionGuard(this.nextClass);
            this.foundLoop = false;
        }

        @Override
        public boolean hasNext() {
            return this.nextClass != null;
        }

        @Override
        public IClassDefinition next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            IClassDefinition next = this.nextClass;
            this.nextClass = this.nextClass.resolveBaseClass(this.project);
            if (this.guard.isLoop(this.nextClass)) {
                this.foundLoop = true;
                this.nextClass = null;
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean foundLoop() {
            return this.foundLoop;
        }
    }
}

