/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.definitions;

import java.util.Iterator;
import org.apache.flex.compiler.definitions.IAccessorDefinition;
import org.apache.flex.compiler.definitions.IClassDefinition;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.IFunctionDefinition;
import org.apache.flex.compiler.definitions.IGetterDefinition;
import org.apache.flex.compiler.definitions.IInterfaceDefinition;
import org.apache.flex.compiler.definitions.INamespaceDefinition;
import org.apache.flex.compiler.definitions.IPackageDefinition;
import org.apache.flex.compiler.definitions.IScopedDefinition;
import org.apache.flex.compiler.definitions.ISetterDefinition;
import org.apache.flex.compiler.definitions.IVariableDefinition;
import org.apache.flex.compiler.definitions.references.INamespaceReference;
import org.apache.flex.compiler.internal.as.codegen.BindableHelper;
import org.apache.flex.compiler.internal.definitions.FunctionDefinition;
import org.apache.flex.compiler.internal.definitions.NamespaceDefinition;
import org.apache.flex.compiler.internal.scopes.ASScope;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.scopes.IDefinitionSet;
import org.apache.flex.compiler.tree.as.IVariableNode;

public abstract class AccessorDefinition
extends FunctionDefinition
implements IAccessorDefinition {
    public AccessorDefinition(String name) {
        super(name);
    }

    @Override
    public AccessorDefinition resolveCorrespondingAccessor(ICompilerProject project) {
        IDefinition parent = this.getParent();
        if (parent instanceof IClassDefinition) {
            IClassDefinition.IClassIterator iter = ((IClassDefinition)parent).classIterator(project, true);
            while (iter.hasNext()) {
                IClassDefinition cls = (IClassDefinition)iter.next();
                AccessorDefinition correspondingAccessor = this.findCorrespondingAccessor(cls, project);
                if (correspondingAccessor == null) continue;
                return correspondingAccessor;
            }
        } else if (parent instanceof IInterfaceDefinition) {
            Iterator<IInterfaceDefinition> iter = ((IInterfaceDefinition)parent).interfaceIterator(project, true);
            while (iter.hasNext()) {
                IInterfaceDefinition intf = iter.next();
                AccessorDefinition correspondingAccessor = this.findCorrespondingAccessor(intf, project);
                if (correspondingAccessor == null) continue;
                return correspondingAccessor;
            }
        } else {
            if (parent instanceof IPackageDefinition) {
                IPackageDefinition pd = (IPackageDefinition)parent;
                return this.findCorrespondingAccessor(pd, project);
            }
            if (parent == null) {
                ASScope scope = this.getContainingASScope();
                return this.findCorrespondingAccessor(scope, project);
            }
            assert (false);
        }
        return null;
    }

    private AccessorDefinition findCorrespondingAccessor(IScopedDefinition type, ICompilerProject project) {
        ASScope scope = (ASScope)type.getContainedScope();
        return this.findCorrespondingAccessor(scope, project);
    }

    private AccessorDefinition findCorrespondingAccessor(ASScope scope, ICompilerProject project) {
        String name = this.getBaseName();
        INamespaceReference namespaceReference = this.getNamespaceReference();
        boolean isStatic = this.isStatic();
        INamespaceDefinition thisNamespaceDef = namespaceReference.resolveNamespaceReference(project);
        if (thisNamespaceDef == null) {
            return null;
        }
        boolean isBindable = ((NamespaceDefinition)thisNamespaceDef).getAETNamespace().getName().equals(BindableHelper.bindableNamespaceDefinition.getAETNamespace().getName());
        IDefinitionSet definitionSet = scope.getLocalDefinitionSetByName(name);
        if (definitionSet == null) {
            return null;
        }
        int n = definitionSet.getSize();
        for (int i = 0; i < n; ++i) {
            IAccessorDefinition definition;
            IDefinition d = definitionSet.getDefinition(i);
            if (!(d instanceof IAccessorDefinition) || (definition = (IAccessorDefinition)d).isStatic() != isStatic || (!(this instanceof IGetterDefinition) || !(definition instanceof ISetterDefinition)) && (!(this instanceof ISetterDefinition) || !(definition instanceof IGetterDefinition))) continue;
            INamespaceReference testDefRef = definition.getNamespaceReference();
            INamespaceDefinition testNamespaceDef = testDefRef.resolveNamespaceReference(project);
            boolean testBindable = ((NamespaceDefinition)testNamespaceDef).getAETNamespace().getName().equals(BindableHelper.bindableNamespaceDefinition.getAETNamespace().getName());
            if ((!isBindable || !testBindable) && (isBindable || testBindable)) continue;
            return (AccessorDefinition)definition;
        }
        return null;
    }

    @Override
    public IVariableDefinition.VariableClassification getVariableClassification() {
        IDefinition parent = this.getParent();
        if (parent instanceof IFunctionDefinition) {
            return IVariableDefinition.VariableClassification.LOCAL;
        }
        if (parent instanceof IClassDefinition) {
            return IVariableDefinition.VariableClassification.CLASS_MEMBER;
        }
        if (parent instanceof IInterfaceDefinition) {
            return IVariableDefinition.VariableClassification.INTERFACE_MEMBER;
        }
        if (parent instanceof IPackageDefinition) {
            return IVariableDefinition.VariableClassification.PACKAGE_MEMBER;
        }
        if (parent == null) {
            if (this.inPackageNamespace()) {
                return IVariableDefinition.VariableClassification.PACKAGE_MEMBER;
            }
            return IVariableDefinition.VariableClassification.FILE_MEMBER;
        }
        assert (false);
        return null;
    }

    @Override
    public IVariableNode getVariableNode() {
        return (IVariableNode)super.getNode();
    }

    @Override
    public Object resolveInitialValue(ICompilerProject project) {
        return null;
    }

    @Override
    public boolean inlineFunction() {
        return this.canFunctionBeInlined();
    }
}

