/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.config.localization;

import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.flex.compiler.Messages;
import org.apache.flex.compiler.internal.config.localization.ILocalizedText;
import org.apache.flex.compiler.internal.config.localization.ILocalizer;
import org.apache.flex.compiler.internal.config.localization.LocalizationManager;

public class ResourceBundleLocalizer
implements ILocalizer {
    @Override
    public ILocalizedText getLocalizedText(Locale locale, String id) {
        int dot;
        String prefix = id;
        while ((dot = prefix.lastIndexOf(46)) != -1) {
            prefix = prefix.substring(0, dot);
            String suffix = id.substring(dot + 1);
            try {
                String message = Messages.getString(suffix);
                if (message == null) continue;
                return new ResourceBundleText(message);
            }
            catch (MissingResourceException e) {
            }
        }
        return null;
    }

    private class ResourceBundleText
    implements ILocalizedText {
        private String text;

        public ResourceBundleText(String text) {
            this.text = text;
        }

        @Override
        public String format(Map<String, Object> parameters) {
            return LocalizationManager.replaceInlineReferences(this.text, parameters);
        }
    }
}

