/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.config;

import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.apache.flex.compiler.exceptions.ConfigurationException;
import org.apache.flex.compiler.filespecs.FileSpecification;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class FlashBuilderConfigurator {
    public static String[] computeFlashBuilderArgs(String[] args, String suffix) {
        String fbFolder = args[args.length - 1];
        ArrayList<String> fbArgs = new ArrayList<String>();
        boolean isDebug = false;
        String sdkdir = null;
        for (String arg : args) {
            if (arg.equals("-debug") || arg.equals("-debug=true")) {
                isDebug = true;
            }
            if (!arg.contains("+flexlib")) continue;
            sdkdir = arg.substring(9);
        }
        ActionScriptPropertiesReader aspr = new ActionScriptPropertiesReader();
        try {
            aspr.read(fbArgs, fbFolder, isDebug, suffix, sdkdir);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        FlexLibPropertiesReader flpr = new FlexLibPropertiesReader();
        if (suffix.equals(".swc")) {
            try {
                flpr.read(fbArgs, fbFolder);
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
        }
        for (String arg : args) {
            if (arg.startsWith("-output=")) {
                int n = fbArgs.size();
                for (int i = 0; i < n; ++i) {
                    String fbArg = fbArgs.get(i);
                    if (!fbArg.startsWith("-output")) continue;
                    fbArgs.remove(i);
                    break;
                }
            }
            fbArgs.add(arg);
        }
        fbArgs.remove(fbArgs.size() - 1);
        if (!suffix.equals(".swc")) {
            fbArgs.add(aspr.applicationPath);
        }
        System.out.println("using FlashBuilder Project Files");
        System.out.println("FlashBuilder settings:");
        for (String arg : fbArgs) {
            System.out.println("    " + arg);
        }
        return fbArgs.toArray(new String[fbArgs.size()]);
    }

    private static class FlexLibPropertiesHandler
    extends DefaultHandler {
        private Stack<String> contextStack = new Stack();
        private ArrayList<String> fbArgs;
        private final String source;
        private final String contextPath;
        private final String rootElement;
        private Locator locator;
        public boolean allClasses;
        public ArrayList<String> includedClasses = new ArrayList();

        public FlexLibPropertiesHandler(ArrayList<String> fbArgs, String source, String contextPath, String rootElement) {
            this.fbArgs = fbArgs;
            this.source = source;
            this.contextPath = contextPath;
            this.rootElement = rootElement;
        }

        @Override
        public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
            if (this.contextStack.size() == 0) {
                if (!qname.equals(this.rootElement)) {
                    throw new SAXConfigurationException(new ConfigurationException.IncorrectElement(this.rootElement, qname, this.source, this.locator.getLineNumber()), this.locator);
                }
                String all = attributes.getValue("includeAllClasses");
                if ("true".equals(all)) {
                    this.allClasses = true;
                }
                this.contextStack.push(qname);
                return;
            }
            if (qname.equals("classEntry")) {
                String path = attributes.getValue("path");
                this.includedClasses.add(path);
            } else if (qname.equals("namespaceManifestEntry")) {
                String manifest = attributes.getValue("manifest");
                String namespace = attributes.getValue("namespace");
                this.fbArgs.add("-namespace");
                this.fbArgs.add(namespace);
                String mf = this.contextPath + "/" + manifest;
                File f = new File(mf);
                if (!f.exists()) {
                    mf = this.contextPath + "/src/" + manifest;
                }
                this.fbArgs.add(mf);
                this.fbArgs.add("-include-namespaces");
                this.fbArgs.add(namespace);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qname) throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }
    }

    private static class FlexLibPropertiesReader {
        private FlexLibPropertiesReader() {
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void read(ArrayList<String> fbArgs, String fbFolder) throws ConfigurationException {
            String path = fbFolder + "/" + ".flexLibProperties";
            FlexLibPropertiesHandler h = new FlexLibPropertiesHandler(fbArgs, path, fbFolder, "flexLibProperties");
            SAXParserFactory factory = SAXParserFactory.newInstance();
            Reader reader = null;
            try {
                FileSpecification fs = new FileSpecification(path);
                reader = fs.createReader();
                SAXParser parser = factory.newSAXParser();
                InputSource source = new InputSource(reader);
                parser.parse(source, (DefaultHandler)h);
                if (h.allClasses) {
                    fbArgs.add("-include-sources=" + fbFolder + "/src");
                } else {
                    StringBuilder classList = new StringBuilder();
                    boolean first = true;
                    for (String cname : h.includedClasses) {
                        if (!first) {
                            classList.append(", ");
                        }
                        first = false;
                        classList.append(cname);
                    }
                    fbArgs.add("-include-classes=" + classList.toString());
                }
            }
            catch (SAXConfigurationException e) {
                try {
                    throw e.innerException;
                    catch (SAXParseException e2) {
                        throw new ConfigurationException.OtherThrowable(e2, null, path, e2.getLineNumber());
                    }
                    catch (Exception e3) {
                        throw new ConfigurationException.OtherThrowable(e3, null, path, -1);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    private static class ASPropertiesHandler
    extends DefaultHandler {
        private Stack<String> contextStack = new Stack();
        private ArrayList<String> fbArgs;
        private final String source;
        private final String contextPath;
        private final String rootElement;
        private final String suffix;
        private Locator locator;
        private boolean isDebug;
        private String sdkdir;
        public String applicationPath;
        private String outputFileName;
        private boolean inExclude;
        private String workspacePath;
        public String additionalCompilerArguments;
        public String sourcePath;

        public ASPropertiesHandler(ArrayList<String> fbArgs, String source, String contextPath, String rootElement, boolean isDebug, String suffix, String sdkdir) {
            this.isDebug = isDebug;
            this.fbArgs = fbArgs;
            this.source = source;
            this.contextPath = contextPath;
            this.rootElement = rootElement;
            this.suffix = suffix;
            this.sdkdir = sdkdir;
        }

        @Override
        public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
            if (this.contextStack.size() == 0) {
                if (!qname.equals(this.rootElement)) {
                    throw new SAXConfigurationException(new ConfigurationException.IncorrectElement(this.rootElement, qname, this.source, this.locator.getLineNumber()), this.locator);
                }
                this.contextStack.push(qname);
                this.applicationPath = attributes.getValue("mainApplicationPath");
                this.outputFileName = this.applicationPath.substring(0, this.applicationPath.lastIndexOf(46));
                return;
            }
            if (qname.equals("compiler")) {
                String outputFolder;
                String isAccessible;
                String isApollo;
                String srcPath;
                String extras = attributes.getValue("additionalCompilerArguments");
                if (extras != null && extras.length() > 0) {
                    this.additionalCompilerArguments = extras;
                }
                if ((srcPath = attributes.getValue("sourceFolderPath")) != null && srcPath.length() > 0) {
                    this.applicationPath = this.contextPath + "/" + srcPath + "/" + this.applicationPath;
                    this.sourcePath = this.contextPath + "/" + srcPath;
                    this.fbArgs.add("-source-path+=" + this.contextPath + "/" + srcPath);
                }
                if ((isApollo = attributes.getValue("useApolloConfig")) != null && isApollo.length() > 0 && isApollo.equals("true")) {
                    this.fbArgs.add("+configname=air");
                }
                if ((isAccessible = attributes.getValue("generateAccessible")) != null && isAccessible.length() > 0 && isAccessible.equals("true")) {
                    this.fbArgs.add("-compiler.accessible=true");
                }
                if ((outputFolder = attributes.getValue("outputFolderPath")) != null && outputFolder.length() > 0) {
                    if (!this.isDebug) {
                        outputFolder = outputFolder.replace("debug", "release");
                    }
                    String outFile = "-output=";
                    if (!outputFolder.startsWith("/")) {
                        outFile = outFile + this.contextPath + "/";
                    }
                    this.fbArgs.add(outFile + outputFolder + "/" + this.outputFileName + this.suffix);
                }
            } else if (qname.equals("sourcePathEntry")) {
                String kind = attributes.getValue("kind");
                if (kind.equals("1")) {
                    String path = attributes.getValue("path");
                    this.fbArgs.add("-source-path+=" + this.contextPath + "/" + path);
                }
            } else if (qname.equals("libraryPathEntry")) {
                if (!this.inExclude) {
                    String kind = attributes.getValue("kind");
                    String linkType = attributes.getValue("linkType");
                    String path = attributes.getValue("path");
                    if (!kind.equals("4")) {
                        if (path.contains("${DOCUMENTS}")) {
                            if (this.workspacePath == null) {
                                this.workspacePath = this.source;
                                File workspaceFile = new File(this.source);
                                this.workspacePath = workspaceFile.getParent();
                                while (this.workspacePath != null && this.workspacePath.length() > 0 && !(workspaceFile = new File(this.workspacePath + "/.metadata")).exists()) {
                                    this.workspacePath = workspaceFile.getParentFile().getParent();
                                }
                            }
                            path = path.replace("${DOCUMENTS}", this.workspacePath);
                            this.fbArgs.add(linkType.equals("2") ? "-external-library-path+=" + path : "-library-path+=" + path);
                        } else if (path.contains("${PROJECT_FRAMEWORKS}")) {
                            path = path.replace("${PROJECT_FRAMEWORKS}", this.sdkdir);
                            this.fbArgs.add(linkType.equals("2") ? "-external-library-path+=" + path : "-library-path+=" + path);
                        } else if (path.startsWith("/")) {
                            File f = new File(this.contextPath);
                            String parentPath = f.getParent();
                            if ((f = new File(parentPath + path)).exists()) {
                                this.fbArgs.add(linkType.equals("2") ? "-external-library-path+=" + parentPath + path : "-library-path+=" + parentPath + path);
                            } else {
                                this.fbArgs.add(linkType.equals("2") ? "-external-library-path+=" + path : "-library-path+=" + path);
                            }
                        } else {
                            this.fbArgs.add(linkType.equals("2") ? "-external-library-path+=" + this.contextPath + "/" + path : "-library-path+=" + this.contextPath + "/" + path);
                        }
                    }
                }
            } else if (qname.equals("excludedEntries")) {
                this.inExclude = true;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qname) throws SAXException {
            if (qname.equals("excludedEntries")) {
                this.inExclude = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }
    }

    private static class ActionScriptPropertiesReader {
        public String applicationPath;
        public String additionalCompilerArguments;

        private ActionScriptPropertiesReader() {
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void read(ArrayList<String> fbArgs, String fbFolder, boolean isDebug, String suffix, String sdkdir) throws ConfigurationException {
            String path = fbFolder + "/" + ".actionScriptProperties";
            ASPropertiesHandler h = new ASPropertiesHandler(fbArgs, path, fbFolder, "actionScriptProperties", isDebug, suffix, sdkdir);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            Reader reader = null;
            try {
                FileSpecification fs = new FileSpecification(path);
                reader = fs.createReader();
                SAXParser parser = factory.newSAXParser();
                InputSource source = new InputSource(reader);
                parser.parse(source, (DefaultHandler)h);
                this.applicationPath = h.applicationPath;
                if (h.additionalCompilerArguments != null) {
                    String[] parts;
                    for (String part : parts = h.additionalCompilerArguments.split("\\s+")) {
                        if (part.contains("-load-config") && part.contains("..")) {
                            String[] pieces = part.split("=");
                            part = pieces[0] + "=" + h.sourcePath + "/" + pieces[1];
                        }
                        fbArgs.add(part);
                    }
                }
            }
            catch (SAXConfigurationException e) {
                try {
                    throw e.innerException;
                    catch (SAXParseException e2) {
                        throw new ConfigurationException.OtherThrowable(e2, null, path, e2.getLineNumber());
                    }
                    catch (Exception e3) {
                        throw new ConfigurationException.OtherThrowable(e3, null, path, -1);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public static class SAXConfigurationException
    extends SAXParseException {
        private static final long serialVersionUID = -3388781933743434302L;
        public ConfigurationException innerException;

        SAXConfigurationException(ConfigurationException e, Locator locator) {
            super(null, locator);
            this.innerException = e;
        }
    }
}

