/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package flex.messaging.securityadvisories;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import flex.messaging.util.DoubleUtil;
import flex.messaging.util.XMLUtil;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.w3c.dom.Document;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * Created by christoferdutz on 23.07.15.
 */

public class BlazeDsXmlProcessingXXEVulnerability extends TestCase {

    public void testVulnerability() throws Exception {
        int secret = (int) (Math.random() * 1000);

        // Create a temp file containing a secret.
        File temp = File.createTempFile("xxe-test", ".txt");
        PrintWriter out = new PrintWriter(temp);
        out.println(Integer.toString(secret));
        out.close();

        String uri = temp.toURI().toASCIIString();
        StringBuffer xml = new StringBuffer(512);
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        xml.append("<!DOCTYPE foo [\r\n");
        xml.append("<!ELEMENT foo ANY >\r\n");
        xml.append("<!ENTITY xxe SYSTEM \"" + uri + "\" >]>\r\n");
        xml.append("<foo>The Secret is: &xxe;</foo>");

        Document data = XMLUtil.stringToDocument(xml.toString());

        OutputFormat format = new OutputFormat(data);
        StringWriter stringOut = new StringWriter();
        XMLSerializer serial = new XMLSerializer(stringOut, format);
        serial.serialize(data);

        Assert.assertFalse(stringOut.toString().contains("The Secret is: " + Integer.toString(secret)));
    }

}
