////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

/**
 *  Number of text columns.
 * 
 *  <p><b>For the Spark theme, see
 *  flashx.textLayout.formats.ITextLayoutFormat.columnCount.</b></p>
 *
 *  <p><b>For the Mobile theme, this is not supported.</b></p>
 * 
 *  @see flashx.textLayout.formats.ITextLayoutFormat#columnCount
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10
 *  @playerversion AIR 1.5
 *  @productversion Flex 4
 */
[Style(name="columnCount", type="Object", inherit="no")]

/**
 *  Amount of gutter space, in pixels, to leave between the columns.
 * 
 *  <p><b>For the Spark theme, see
 *  flashx.textLayout.formats.ITextLayoutFormat.columnGap.</b></p>
 *
 *  <p><b>For the Mobile theme, this is not supported.</b></p>
 * 
 *  @see flashx.textLayout.formats.ITextLayoutFormat#columnGap
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10
 *  @playerversion AIR 1.5
 *  @productversion Flex 4
 */
[Style(name="columnGap", type="Number", format="Length", inherit="no")]

/**
 *  Column width in pixels. 
 * 
 *  <p><b>For the Spark theme, see
 *  flashx.textLayout.formats.ITextLayoutFormat.columnWidth.</b></p>
 *
 *  <p><b>For the Mobile theme, this is not supported.</b></p>
 * 
 *  @see flashx.textLayout.formats.ITextLayoutFormat#columnWidth
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10
 *  @playerversion AIR 1.5
 *  @productversion Flex 4
 */
[Style(name="columnWidth", type="Object", inherit="no")]
