/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.css;

import flash.css.Descriptor;
import flash.css.MediaList;
import flash.css.StyleDeclaration;
import flash.css.StyleDeclarationBlock;
import flash.css.StyleProperty;
import flash.css.StyleSelector;
import flex2.compiler.Source;
import flex2.compiler.css.Import;
import flex2.compiler.css.Reference;
import flex2.compiler.mxml.MxmlConfiguration;
import flex2.compiler.mxml.lang.FrameworkDefs;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.rep.AtEmbed;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.asc.util.ContextStatics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleDef {
    private String subject;
    private List<String> effectStyles = new ArrayList<String>();
    private Map<String, StyleDeclaration> declarations;
    private boolean advanced;
    private boolean isTypeSelector;
    private Map<String, StyleProperty> styles = new HashMap<String, StyleProperty>();
    private MxmlDocument mxmlDocument;
    private MxmlConfiguration mxmlConfiguration;
    private Source source;
    private int lineNumber;
    private ContextStatics perCompileData;
    private static final String CLASS_REFERENCE = "ClassReference(";
    private static final String EMBED = "Embed(";
    public static final String GLOBAL = "global";
    public static final String UNIVERSAL = "*";
    private static final String PROPERTY_REFERENCE = "PropertyReference(";

    StyleDef(String subject, MxmlDocument mxmlDocument, MxmlConfiguration mxmlConfiguration, Source source, int lineNumber, ContextStatics perCompileData) {
        this.subject = subject;
        this.mxmlDocument = mxmlDocument;
        this.mxmlConfiguration = mxmlConfiguration;
        this.source = source;
        this.lineNumber = lineNumber;
        this.perCompileData = perCompileData;
        this.advanced = true;
        this.isTypeSelector = !GLOBAL.equals(subject) && !UNIVERSAL.equals(subject);
    }

    StyleDef(String name, boolean isTypeSelector, MxmlDocument mxmlDocument, MxmlConfiguration mxmlConfiguration, Source source, int lineNumber, ContextStatics perCompileData) {
        this.subject = name;
        this.isTypeSelector = isTypeSelector;
        this.mxmlDocument = mxmlDocument;
        this.mxmlConfiguration = mxmlConfiguration;
        this.source = source;
        this.lineNumber = lineNumber;
        this.perCompileData = perCompileData;
    }

    void addAdvancedDeclaration(StyleDeclaration declaration, MediaList mediaList) {
        StyleSelector selector;
        String selectorString;
        StyleDeclaration existingDeclaration;
        if (this.declarations == null) {
            this.declarations = new LinkedHashMap<String, StyleDeclaration>();
        }
        if ((existingDeclaration = this.declarations.get(selectorString = (selector = declaration.getSelector()).toString())) == null) {
            existingDeclaration = declaration;
            this.declarations.put(selectorString, existingDeclaration);
        }
        StyleDeclarationBlock block = existingDeclaration.getDeclarationBlock(selector, mediaList);
        this.extractProperties(declaration, block.getProperties(), block.getEffectStyles());
        if (mediaList == null) {
            Map<String, StyleProperty> properties = block.getProperties();
            List<StyleDeclarationBlock> existingBlocks = existingDeclaration.getDeclarationBlocks();
            for (StyleDeclarationBlock existingBlock : existingBlocks) {
                if (existingBlock == block) continue;
                Map<String, StyleProperty> existingProperties = existingBlock.getProperties();
                for (String property : properties.keySet()) {
                    if (existingProperties.get(property) == null) continue;
                    existingProperties.put(property, properties.get(property));
                }
            }
        }
    }

    void addDeclaration(StyleDeclaration declaration) {
        this.extractProperties(declaration, this.styles, this.effectStyles);
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public void setAdvanced(boolean value) {
        this.advanced = value;
    }

    public boolean getAllowDuplicateDefaultStyleDeclarations() {
        if (this.mxmlConfiguration != null) {
            return this.mxmlConfiguration.getAllowDuplicateDefaultStyleDeclarations();
        }
        return false;
    }

    public Set<AtEmbed> getAtEmbeds() {
        HashSet<AtEmbed> result = new HashSet<AtEmbed>();
        if (this.advanced) {
            if (this.declarations != null) {
                for (StyleDeclaration styleDeclaration : this.declarations.values()) {
                    List<StyleDeclarationBlock> declarationBlocks = styleDeclaration.getDeclarationBlocks();
                    for (StyleDeclarationBlock block : declarationBlocks) {
                        Map<String, StyleProperty> properties = block.getProperties();
                        if (properties == null) continue;
                        StyleDef.extractAtEmbeds(result, properties.values());
                    }
                }
            }
        } else if (this.styles != null) {
            StyleDef.extractAtEmbeds(result, this.styles.values());
        }
        return result;
    }

    private static void extractAtEmbeds(Set<AtEmbed> atEmbeds, Collection<StyleProperty> styleProperties) {
        for (StyleProperty styleProperty : styleProperties) {
            Object value = styleProperty.getValue();
            if (!(value instanceof AtEmbed)) continue;
            atEmbeds.add((AtEmbed)value);
        }
    }

    public Map<String, StyleDeclaration> getDeclarations() {
        return this.declarations;
    }

    public List<String> getEffectStyles() {
        return this.effectStyles;
    }

    public Set<Import> getImports() {
        HashSet<Import> result = new HashSet<Import>();
        if (this.advanced) {
            if (this.declarations != null) {
                for (StyleDeclaration styleDeclaration : this.declarations.values()) {
                    List<StyleDeclarationBlock> declarationBlocks = styleDeclaration.getDeclarationBlocks();
                    for (StyleDeclarationBlock block : declarationBlocks) {
                        Map<String, StyleProperty> properties = block.getProperties();
                        if (properties == null) continue;
                        StyleDef.extractImports(result, properties.values());
                    }
                }
            }
        } else if (this.styles != null) {
            StyleDef.extractImports(result, this.styles.values());
        }
        return result;
    }

    private static void extractImports(Set<Import> imports, Collection<StyleProperty> styleProperties) {
        for (StyleProperty styleProperty : styleProperties) {
            Reference reference;
            Object value = styleProperty.getValue();
            if (!(value instanceof Reference) || !(reference = (Reference)value).isClassReference() || reference.getValue().equals("null")) continue;
            imports.add(new Import(reference.getValue(), reference.getLineNumber()));
        }
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Map<String, StyleProperty> getStyles() {
        return this.styles;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getTypeName() {
        if (UNIVERSAL.equals(this.subject)) {
            return GLOBAL;
        }
        return StyleDef.createTypeName(this.subject);
    }

    public boolean isTypeSelector() {
        return this.isTypeSelector;
    }

    public static String createTypeName(String subject) {
        subject = subject.replace('.', '_');
        return subject;
    }

    public static String dehyphenize(String string) {
        StringBuilder stringBuffer = new StringBuilder();
        int start = 0;
        int end = string.indexOf(45);
        while (end >= 0) {
            stringBuffer.append(string.substring(start, end));
            stringBuffer.append(Character.toUpperCase(string.charAt(end + 1)));
            start = end + 2;
            end = string.indexOf(45, start);
        }
        stringBuffer.append(string.substring(start));
        return stringBuffer.toString();
    }

    private void extractProperties(StyleDeclaration declaration, Map<String, StyleProperty> properties, List<String> effectsStyles) {
        Iterator<Map.Entry<String, Descriptor>> propertyIterator = declaration.iterator();
        while (propertyIterator.hasNext()) {
            Map.Entry<String, Descriptor> entry = propertyIterator.next();
            Descriptor descriptor = entry.getValue();
            String propertyName = StyleDef.dehyphenize(descriptor.getName());
            try {
                if (propertyName.equals("fontFamily")) {
                    this.processFontFamily(properties, descriptor);
                    continue;
                }
                this.processPropertyDescriptor(propertyName, descriptor, properties, effectsStyles);
            }
            catch (CompilerMessage.CompilerError compilerError) {
                compilerError.setPath(descriptor.getPath());
                compilerError.setLine(descriptor.getLineNumber());
                ThreadLocalToolkit.log(compilerError);
            }
        }
    }

    private Reference processReference(String value, String styleSheetPath, int line, boolean isClassReference) {
        Reference result = null;
        int prefixLength = isClassReference ? CLASS_REFERENCE.length() : PROPERTY_REFERENCE.length();
        String parameter = value.substring(prefixLength, value.length() - 1).trim();
        if (parameter.charAt(0) == '\"' && parameter.indexOf(34, 1) == parameter.length() - 1) {
            String substring = parameter.substring(1, parameter.length() - 1);
            if (!isClassReference && this.mxmlDocument == null) {
                PropertyReferenceRequiresDocument propertyReferenceRequiresDocument = new PropertyReferenceRequiresDocument();
                propertyReferenceRequiresDocument.path = styleSheetPath;
                propertyReferenceRequiresDocument.line = line;
                ThreadLocalToolkit.log(propertyReferenceRequiresDocument);
            } else {
                result = new Reference(substring, isClassReference, styleSheetPath, line);
            }
        } else if (parameter.equals("null")) {
            result = new Reference(parameter, isClassReference, styleSheetPath, line);
        } else {
            InvalidReference invalidReference = new InvalidReference(isClassReference);
            invalidReference.path = styleSheetPath;
            invalidReference.line = line;
            ThreadLocalToolkit.log(invalidReference);
        }
        return result;
    }

    private void processFontFamily(Map<String, StyleProperty> properties, Descriptor descriptor) {
        String propertyName = "fontFamily";
        String fontFamily = descriptor.getIdentAsString();
        StyleProperty stylesProperty = new StyleProperty(propertyName, "\"" + fontFamily + "\"", descriptor.getPath(), descriptor.getLineNumber());
        properties.put(propertyName, stylesProperty);
    }

    private void processPropertyDescriptor(String propertyName, Descriptor descriptor, Map<String, StyleProperty> properties, List<String> effectStyles) throws CompilerMessage.CompilerError {
        Object value;
        if (propertyName.endsWith("Effect")) {
            effectStyles.add(propertyName);
        }
        if ((value = this.processPropertyValue(descriptor)) != null) {
            StyleProperty styleProperty = new StyleProperty(propertyName, value, descriptor.getPath(), descriptor.getLineNumber());
            properties.put(propertyName, styleProperty);
        }
    }

    private Object processPropertyValue(Descriptor descriptor) throws CompilerMessage.CompilerError {
        String value = descriptor.getValueAsString();
        Object result = value;
        if (value.startsWith(EMBED)) {
            result = AtEmbed.create(this.perCompileData, this.source, value, descriptor.getPath(), descriptor.getLineNumber(), "_embed_css_");
        } else if (value.startsWith(CLASS_REFERENCE)) {
            result = this.processReference(value, descriptor.getPath(), descriptor.getLineNumber(), true);
        } else if (value.startsWith(PROPERTY_REFERENCE)) {
            result = this.processReference(value, descriptor.getPath(), descriptor.getLineNumber(), false);
        }
        if (!(this.advanced || this.mxmlDocument == null || descriptor.getValue().getLexicalUnitType() != 35 || value == null || value.length() <= 2 || value.charAt(0) != '\'' && value.charAt(0) != '\"' || value.charAt(value.length() - 1) != '\'' && value.charAt(value.length() - 1) != '\"')) {
            String potentialProperty = value.substring(1, value.length() - 1);
            Type type = this.mxmlDocument.getRoot().getType();
            if (type != null && type.getProperty(potentialProperty) != null) {
                result = potentialProperty;
            }
            if (FrameworkDefs.isBuiltinEffectName(potentialProperty)) {
                this.mxmlDocument.addTypeRef(this.mxmlDocument.getStandardDefs().getEffectsPackage() + '.' + potentialProperty, descriptor.getLineNumber());
            }
        }
        return result;
    }

    public static class PropertyReferenceRequiresDocument
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 3730898410175891396L;
    }

    public static class InvalidReference
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 3730898410175891394L;
        public String type;

        public InvalidReference(boolean isClassReference) {
            this.type = isClassReference ? "Class" : "Property";
        }
    }
}

