/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.io;

import flex2.compiler.io.VirtualFile;
import java.io.IOException;
import java.io.InputStream;

public class TextFile
implements VirtualFile {
    private String text;
    private String name;
    private String nameForReporting;
    private String parent;
    private String mimeType;
    private long lastModified;
    private long size;

    public TextFile(String text, String name, String parent, String mimeType) {
        this(text, name, name, parent, mimeType, System.currentTimeMillis());
    }

    public TextFile(String text, String name, String parent, String mimeType, long lastModified) {
        this.init(text, name, name, parent, mimeType, lastModified);
    }

    public TextFile(String text, String name, String nameForReporting, String parent, String mimeType, long lastModified) {
        this.init(text, name, nameForReporting, parent, mimeType, lastModified);
    }

    private void init(String text, String name, String nameForReporting, String parent, String mimeType, long lastModified) {
        this.text = text;
        this.size = text == null ? 0L : (long)text.length();
        this.name = name;
        this.nameForReporting = nameForReporting;
        this.parent = parent;
        this.mimeType = mimeType;
        this.lastModified = lastModified;
    }

    public String getName() {
        return this.name;
    }

    public String getNameForReporting() {
        return this.nameForReporting;
    }

    public String getURL() {
        return "memory://" + this.name;
    }

    public String getParent() {
        return this.parent;
    }

    public boolean isDirectory() {
        return false;
    }

    public long size() {
        return this.size;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte[] toByteArray() throws IOException {
        throw new UnsupportedOperationException();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public VirtualFile resolve(String relative) {
        return null;
    }

    public void close() {
        this.text = null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TextFile) {
            return this == obj || this.getName().equals(((TextFile)obj).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isTextBased() {
        return true;
    }

    public String toString() {
        return this.text;
    }
}

