/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.common;

import flash.fonts.FontManager;
import flash.fonts.JREFontManager;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.config.AdvancedConfigurationInfo;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.io.VirtualFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class FontsConfiguration {
    private CompilerConfiguration compilerConfig;
    private ConfigurationPathResolver configResolver;
    private FontManager topLevelManager;
    private boolean flashType = true;
    private Languages languages = new Languages();
    private VirtualFile localFontsSnapshot = null;
    private List<String> resolvedLocalFontPaths;
    private List managers;
    private String max_cached_fonts;
    private String max_glyphs_per_face;

    public void setCompilerConfiguration(CompilerConfiguration compilerConfig) {
        this.compilerConfig = compilerConfig;
    }

    public void setConfigPathResolver(ConfigurationPathResolver resolver) {
        this.configResolver = resolver;
    }

    public FontManager getTopLevelManager() {
        if (this.topLevelManager == null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("max-cached-fonts", this.max_cached_fonts);
            map.put("max-glyphs-per-face", this.max_glyphs_per_face);
            map.put("CompatibilityVersion", this.compilerConfig.getCompatibilityVersionString());
            if (this.localFontsSnapshot != null) {
                map.put(JREFontManager.LOCAL_FONTS_SNAPSHOT, this.localFontsSnapshot.getName());
            }
            if (this.resolvedLocalFontPaths != null) {
                map.put("local-font-paths", this.resolvedLocalFontPaths);
            }
            this.topLevelManager = FontManager.create((List)this.managers, map, (Properties)this.languages);
        }
        return this.topLevelManager;
    }

    public void setTopLevelManager(FontManager manager) {
        this.topLevelManager = manager;
    }

    public boolean getFlashType() {
        return this.flashType;
    }

    public void cfgFlashType(ConfigurationValue cv, boolean val) {
        this.flashType = val;
    }

    public static ConfigurationInfo getFlashTypeInfo() {
        return new ConfigurationInfo(){

            public boolean isDeprecated() {
                return true;
            }

            public String getDeprecatedReplacement() {
                return "compiler.fonts.advanced-anti-aliasing";
            }

            public String getDeprecatedSince() {
                return "3.0";
            }
        };
    }

    public void cfgAdvancedAntiAliasing(ConfigurationValue cv, boolean val) {
        this.cfgFlashType(cv, val);
    }

    public Languages getLanguagesConfiguration() {
        return this.languages;
    }

    public VirtualFile getLocalFontsSnapshot() {
        return this.localFontsSnapshot;
    }

    public void cfgLocalFontsSnapshot(ConfigurationValue cv, String localFontsSnapshotPath) throws ConfigurationException {
        this.localFontsSnapshot = ConfigurationPathResolver.getVirtualFile(localFontsSnapshotPath, this.configResolver, cv);
    }

    public static ConfigurationInfo getLocalFontsSnapshotInfo() {
        return new AdvancedConfigurationInfo();
    }

    public List getLocalFontPaths() {
        return this.resolvedLocalFontPaths;
    }

    public void cfgLocalFontPaths(ConfigurationValue cv, List list) {
        this.resolvedLocalFontPaths = new ArrayList<String>();
        if (list != null) {
            for (String path : list) {
                try {
                    VirtualFile file = ConfigurationPathResolver.getVirtualFile(path, this.configResolver, cv);
                    this.resolvedLocalFontPaths.add(file.getName());
                }
                catch (ConfigurationException configurationException) {}
            }
        }
    }

    public static ConfigurationInfo getLocalFontPathsInfo() {
        return new ConfigurationInfo(-1, "path-element"){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public List getManagers() {
        return this.managers;
    }

    public void cfgManagers(ConfigurationValue cv, List l) {
        this.managers = l;
    }

    public static ConfigurationInfo getManagersInfo() {
        return new ConfigurationInfo(-1, "manager-class"){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public String getMaxCachedFonts() {
        return this.max_cached_fonts;
    }

    public void cfgMaxCachedFonts(ConfigurationValue cv, String val) {
        this.max_cached_fonts = val;
    }

    public static ConfigurationInfo getMaxCachedFontsInfo() {
        return new AdvancedConfigurationInfo();
    }

    public String getMaxGlyphsPerFace() {
        return this.max_glyphs_per_face;
    }

    public void cfgMaxGlyphsPerFace(ConfigurationValue cv, String val) {
        this.max_glyphs_per_face = val;
    }

    public static class Languages
    extends Properties {
        private static final long serialVersionUID = 7123498355710868760L;

        public void cfgLanguageRange(ConfigurationValue cv, String lang, String range) {
            this.setProperty(lang, range);
        }

        public static ConfigurationInfo getLanguageRangeInfo() {
            return new ConfigurationInfo(new String[]{"lang", "range"}){

                public boolean allowMultiple() {
                    return true;
                }

                public boolean isAdvanced() {
                    return true;
                }
            };
        }
    }
}

