/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Algorithms;
import adobe.abc.Binding;
import adobe.abc.Block;
import adobe.abc.Edge;
import adobe.abc.Expr;
import adobe.abc.Method;
import adobe.abc.Name;
import adobe.abc.Namespace;
import adobe.abc.OptimizerConstants;
import adobe.abc.Type;
import adobe.abc.TypeCache;
import adobe.abc.Typeref;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeAnalysis {
    public static Map<Expr, Typeref> getExprTypes(Method m) {
        HashMap<Expr, Typeref> types = new HashMap<Expr, Typeref>();
        HashMap<Expr, Object> values = new HashMap<Expr, Object>();
        TypeAnalysis.analyzeTypes(m, types, values);
        return types;
    }

    public static void analyzeTypes(Method m, Map<Expr, Typeref> types, Map<Expr, Object> values) {
        Algorithms.Deque<Block> code = Algorithms.dfs(m.entry.to);
        Algorithms.EdgeMap<Expr> uses = Algorithms.findUses(code);
        TreeSet<Edge> reached = new TreeSet<Edge>();
        TypeAnalysis.analyzeTypes(m, uses, values, types, reached);
    }

    public static void analyzeTypes(Method m, Algorithms.EdgeMap<Expr> uses, Map<Expr, Object> values, Map<Expr, Typeref> types, Set<Edge> reached) {
        TreeSet<Edge> flowWork = new TreeSet<Edge>();
        TreeSet<Expr> ssaWork = new TreeSet<Expr>();
        TreeSet<Expr> ready = new TreeSet<Expr>();
        flowWork.add(m.entry);
        block0: while (true) {
            if (!flowWork.isEmpty()) {
                Edge edge = Algorithms.getEdge(flowWork);
                if (reached.contains(edge)) continue;
                reached.add(edge);
                Block b = edge.to;
                ready.addAll(b.exprs);
                ssaWork.addAll(b.exprs);
                Edge[] edgeArray = b.xsucc;
                int n = edgeArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block0;
                    Edge x = edgeArray[n2];
                    flowWork.add(x);
                    ++n2;
                }
            }
            while (!ssaWork.isEmpty()) {
                Expr e = Algorithms.getExpr(ssaWork);
                if (!ready.contains(e)) continue;
                TypeAnalysis.evaluateExpr(m, e, values, types, flowWork, ssaWork, uses);
            }
            if (flowWork.isEmpty()) break;
        }
    }

    private static void evaluateExpr(Method m, Expr e, Map<Expr, Object> values, Map<Expr, Typeref> types, Set<Edge> flowWork, Set<Expr> ssaWork, Algorithms.EdgeMap<Expr> uses) {
        Object v = null;
        Object tref = null;
        if (e.op == 10) {
            for (Expr a : e.args) {
                Object av = values.get(a);
                if (av == null) continue;
                if (v == null) {
                    v = av;
                } else if (!av.equals(v)) {
                    v = OptimizerConstants.BOTTOM;
                }
                Typeref aref = types.get(a);
                if (tref == null) {
                    tref = aref;
                    continue;
                }
                if (((Typeref)tref).equals(aref)) continue;
                tref = TypeAnalysis.mdb((Typeref)tref, aref);
            }
        } else {
            for (Expr a : e.args) {
                if (values.containsKey(a)) continue;
                return;
            }
            for (Expr a : e.scopes) {
                if (values.containsKey(a)) continue;
                return;
            }
            for (Expr a : e.locals) {
                if (values.containsKey(a)) continue;
                return;
            }
            v = OptimizerConstants.BOTTOM;
            tref = TypeCache.instance().ANY.ref;
            switch (e.op) {
                default: {
                    System.err.println("unhandled op:" + e.op + ":" + OptimizerConstants.opNames[e.op]);
                    assert (false);
                }
                case 4: 
                case 30: 
                case 35: 
                case 52: 
                case 65: 
                case 69: 
                case 89: {
                    break;
                }
                case 119: {
                    tref = types.get(e.args[0]).nonnull();
                    v = values.get(e.args[0]);
                    break;
                }
                case 113: 
                case 114: {
                    tref = TypeCache.instance().STRING.ref.nonnull();
                    break;
                }
                case 90: {
                    tref = m.handlers[e.imm[0]].activation;
                    break;
                }
                case 85: {
                    tref = TypeCache.instance().OBJECT.ref.nonnull();
                    break;
                }
                case 86: {
                    tref = TypeCache.instance().ARRAY.ref.nonnull();
                    break;
                }
                case 87: {
                    tref = m.activation;
                    break;
                }
                case 100: {
                    if (m.cx.scopes.length > 0) {
                        tref = m.cx.scopes[0];
                        break;
                    }
                    v = values.get(e.scopes[0].args[0]);
                    tref = types.get(e.scopes[0].args[0]);
                    break;
                }
                case 101: {
                    v = values.get(e.scopes[0].args[0]);
                    tref = types.get(e.scopes[0].args[0]);
                    if (tref == null) {
                        tref = TypeCache.instance().ANY.ref;
                    }
                    break;
                }
                case 88: {
                    tref = e.c.ref.nonnull();
                    break;
                }
                case 64: {
                    tref = TypeCache.instance().FUNCTION.ref.nonnull();
                    break;
                }
                case 95: {
                    if (TypeCache.instance().globals.contains(e.ref)) {
                        tref = TypeCache.instance().globals.get(e.ref);
                    }
                    break;
                }
                case 93: 
                case 94: {
                    int i = TypeAnalysis.findInner(e.ref, e.scopes, types);
                    if (i >= 0) {
                        v = values.get(e.scopes[i]);
                        tref = types.get(e.scopes[i]);
                        break;
                    }
                    i = TypeAnalysis.findOuter(e.ref, m.cx.scopes);
                    if (i >= 0) {
                        tref = m.cx.scopes[i];
                        break;
                    }
                    if (TypeCache.instance().globals.contains(e.ref)) {
                        tref = TypeCache.instance().globals.get(e.ref);
                        break;
                    }
                    if (m.cx.scopes.length > 0) {
                        tref = m.cx.scopes[0];
                        break;
                    }
                    v = values.get(e.scopes[0]);
                    tref = types.get(e.scopes[0]);
                    break;
                }
                case 96: {
                    int i = TypeAnalysis.findInner(e.ref, e.scopes, types);
                    Typeref stref = i >= 0 ? types.get(e.scopes[i]) : ((i = TypeAnalysis.findOuter(e.ref, m.cx.scopes)) >= 0 ? m.cx.scopes[i] : (TypeCache.instance().globals.contains(e.ref) ? TypeCache.instance().globals.get(e.ref) : (m.cx.scopes.length > 0 ? m.cx.scopes[0] : types.get(e.scopes[0]))));
                    Binding b = stref.t.findGet(e.ref);
                    if (b != null) {
                        if (b.isSlot()) {
                            tref = b.type;
                            if (b.isConst() && b.defaultValueChanged()) {
                                v = b.value;
                            }
                        } else {
                            if (b.isMethod()) {
                                tref = TypeCache.instance().FUNCTION.ref.nonnull();
                                break;
                            }
                            if (b.isGetter()) {
                                tref = b.method.returns;
                            }
                        }
                    }
                    break;
                }
                case 66: {
                    tref = TypeCache.instance().OBJECT.ref.nonnull();
                    break;
                }
                case 74: {
                    Type ot = TypeAnalysis.type(types, e.args[0]);
                    Binding b = ot.findGet(e.ref);
                    if (b != null && b.type != null && b.type.t.itype != null) {
                        tref = b.type.t.itype.ref.nonnull();
                    }
                    break;
                }
                case 70: 
                case 76: {
                    Type ot = TypeAnalysis.type(types, e.args[0]);
                    Binding b = ot.findGet(e.ref);
                    if (b != null) {
                        if (b.isMethod()) {
                            tref = b.method.returns;
                            break;
                        }
                        if (b.isSlot() && b.type != null) {
                            if (b.type.t.itype == TypeCache.instance().INT) {
                                tref = TypeCache.instance().INT.ref;
                                if (e.args.length > 1) {
                                    v = TypeAnalysis.eval_convert_i(values.get(e.args[1]));
                                }
                            } else if (b.type.t.itype == TypeCache.instance().UINT) {
                                tref = TypeCache.instance().UINT.ref;
                                if (e.args.length > 1) {
                                    v = TypeAnalysis.eval_convert_u(values.get(e.args[1]));
                                }
                            } else if (b.type.t.itype == TypeCache.instance().STRING) {
                                tref = TypeCache.instance().STRING.ref.nonnull();
                                if (e.args.length > 1) {
                                    v = TypeAnalysis.eval_convert_s(values.get(e.args[1]));
                                }
                            } else if (b.type.t.itype == TypeCache.instance().BOOLEAN) {
                                tref = TypeCache.instance().BOOLEAN.ref;
                                if (e.args.length > 1) {
                                    v = TypeAnalysis.eval_convert_b(values.get(e.args[1]));
                                }
                            } else if (b.type.t.itype == TypeCache.instance().NUMBER) {
                                tref = TypeCache.instance().NUMBER.ref;
                                if (e.args.length > 1) {
                                    v = TypeAnalysis.eval_convert_d(values.get(e.args[1]));
                                }
                            }
                        }
                    }
                    break;
                }
                case 83: {
                    tref = types.get(e.args[0]).nonnull();
                    break;
                }
                case 68: {
                    tref = e.m.returns;
                    break;
                }
                case 0: {
                    if (e.imm[0] < m.getParams().length) {
                        tref = m.getParams()[e.imm[0]];
                        break;
                    }
                    if (m.needsArguments() || m.needsRest() && e.imm[0] == m.getParams().length) {
                        tref = TypeCache.instance().ARRAY.ref.nonnull();
                        break;
                    }
                    tref = TypeCache.instance().VOID.ref;
                    break;
                }
                case 11: {
                    tref = m.handlers[e.imm[0]].type;
                    break;
                }
                case 108: {
                    Object t0 = TypeAnalysis.type(types, e.args[0]);
                    Binding b = ((Type)t0).findSlot(e.imm[0]);
                    if (b != null) {
                        tref = b.type;
                    }
                    break;
                }
                case 102: {
                    Object t0 = TypeAnalysis.type(types, e.args[0]);
                    Binding b = ((Type)t0).findGet(e.ref);
                    if (b != null) {
                        if (b.isSlot()) {
                            tref = b.type;
                            if (b.isConst() && b.defaultValueChanged()) {
                                v = b.value;
                            }
                        } else {
                            if (b.isMethod()) {
                                tref = TypeCache.instance().FUNCTION.ref.nonnull();
                                break;
                            }
                            if (b.isGetter()) {
                                tref = b.method.returns;
                            }
                        }
                    }
                    break;
                }
                case 33: {
                    v = e.value;
                    tref = TypeCache.instance().VOID.ref;
                    break;
                }
                case 32: {
                    v = e.value;
                    tref = TypeCache.instance().NULL.ref;
                    break;
                }
                case 38: 
                case 39: {
                    v = e.value;
                    tref = TypeCache.instance().BOOLEAN.ref;
                    break;
                }
                case 36: 
                case 37: 
                case 45: {
                    v = e.value;
                    tref = TypeCache.instance().INT.ref;
                    break;
                }
                case 46: {
                    v = e.value;
                    tref = TypeCache.instance().UINT.ref;
                    break;
                }
                case 44: {
                    v = e.value;
                    tref = TypeCache.instance().STRING.ref.nonnull();
                    break;
                }
                case 40: 
                case 47: {
                    v = e.value;
                    tref = TypeCache.instance().NUMBER.ref;
                    break;
                }
                case 49: {
                    v = e.value;
                    tref = TypeCache.instance().NAMESPACE.ref.nonnull();
                    break;
                }
                case 16: {
                    flowWork.add(e.succ[0]);
                    return;
                }
                case 27: {
                    Object v1 = values.get(e.args[0]);
                    if (v1 == OptimizerConstants.BOTTOM) {
                        for (Edge s : e.succ) {
                            flowWork.add(s);
                        }
                    } else {
                        int i = TypeAnalysis.intValue(v1);
                        if (i < 0 || i >= e.succ.length - 1) {
                            i = e.succ.length - 1;
                        }
                        flowWork.add(e.succ[i]);
                    }
                    return;
                }
                case 17: 
                case 18: {
                    Object v1 = values.get(e.args[0]);
                    if (v1 == OptimizerConstants.BOTTOM) {
                        flowWork.add(e.succ[0]);
                        flowWork.add(e.succ[1]);
                    } else if (e.op == 18) {
                        flowWork.add(e.succ[TypeAnalysis.booleanValue(v1) ? 0 : 1]);
                    } else if (e.op == 17) {
                        flowWork.add(e.succ[TypeAnalysis.booleanValue(v1) ? 1 : 0]);
                    }
                    return;
                }
                case 28: 
                case 48: {
                    v = values.get(e.args[0]);
                    tref = types.get(e.args[0]).nonnull();
                    break;
                }
                case 118: {
                    tref = TypeCache.instance().BOOLEAN.ref;
                    v = TypeAnalysis.eval_convert_b(values.get(e.args[0]));
                    break;
                }
                case 150: {
                    tref = TypeCache.instance().BOOLEAN.ref;
                    Object v0 = values.get(e.args[0]);
                    if (v0 != OptimizerConstants.BOTTOM) {
                        v = TypeAnalysis.booleanValue(v0) ? Boolean.FALSE : Boolean.TRUE;
                    }
                    break;
                }
                case 31: 
                case 50: 
                case 91: 
                case 106: 
                case 171: 
                case 172: 
                case 177: 
                case 178: 
                case 179: 
                case 180: {
                    tref = TypeCache.instance().BOOLEAN.ref;
                    break;
                }
                case 173: 
                case 174: 
                case 175: 
                case 176: {
                    tref = TypeCache.instance().BOOLEAN.ref;
                    Object v0 = values.get(e.args[0]);
                    Object v1 = values.get(e.args[1]);
                    if (v0.equals(OptimizerConstants.NAN) || v0 == OptimizerConstants.UNDEFINED || v1.equals(OptimizerConstants.NAN) || v1 == OptimizerConstants.UNDEFINED) {
                        v = Boolean.FALSE;
                        break;
                    }
                    if (v0 != OptimizerConstants.BOTTOM && v1 != OptimizerConstants.BOTTOM) {
                        v = e.op == 173 ? TypeAnalysis.lessthan(v0, v1) : (e.op == 174 ? !TypeAnalysis.lessthan(v1, v0) : (e.op == 175 ? TypeAnalysis.lessthan(v1, v0) : !TypeAnalysis.lessthan(v0, v1)));
                    }
                    break;
                }
                case 112: {
                    tref = TypeCache.instance().STRING.ref.nonnull();
                    v = TypeAnalysis.eval_convert_s(values.get(e.args[0]));
                    break;
                }
                case 133: {
                    tref = TypeAnalysis.eval_coerce_s(types.get(e.args[0]));
                    v = TypeAnalysis.eval_coerce_s(values.get(e.args[0]));
                    break;
                }
                case 137: {
                    Object t0 = types.get(e.args[0]);
                    tref = TypeAnalysis.eval_coerce_o((Typeref)t0);
                    v = TypeAnalysis.eval_coerce_o(values.get(e.args[0]), ((Typeref)t0).t);
                    break;
                }
                case 130: {
                    if (!types.get(e.args[0]).equals(TypeCache.instance().VOID.ref)) {
                        v = values.get(e.args[0]);
                        tref = types.get(e.args[0]);
                        break;
                    }
                    tref = TypeCache.instance().ANY.ref;
                    break;
                }
                case 128: {
                    Object t0 = types.get(e.args[0]);
                    Object v0 = values.get(e.args[0]);
                    Type t = TypeCache.instance().namedTypes.get(e.ref);
                    assert (t != null);
                    if (t == TypeCache.instance().STRING) {
                        tref = TypeAnalysis.eval_coerce_s((Typeref)t0);
                        v = TypeAnalysis.eval_coerce_s(v0);
                        break;
                    }
                    if (t == TypeCache.instance().OBJECT) {
                        tref = TypeAnalysis.eval_coerce_o((Typeref)t0);
                        v = TypeAnalysis.eval_coerce_o(v0, ((Typeref)t0).t);
                        break;
                    }
                    if (t == TypeCache.instance().INT) {
                        tref = t.ref;
                        v = TypeAnalysis.eval_convert_i(v0);
                        break;
                    }
                    if (t == TypeCache.instance().UINT) {
                        tref = t.ref;
                        v = TypeAnalysis.eval_convert_u(v0);
                        break;
                    }
                    if (t == TypeCache.instance().NUMBER) {
                        tref = t.ref;
                        v = TypeAnalysis.eval_convert_d(v0);
                        break;
                    }
                    if (t == TypeCache.instance().BOOLEAN) {
                        tref = t.ref;
                        v = TypeAnalysis.eval_convert_b(v0);
                        break;
                    }
                    if (((Typeref)t0).t.extendsOrIsBase(t)) {
                        tref = t0;
                        v = v0;
                        break;
                    }
                    if (((Typeref)t0).t == TypeCache.instance().NULL || ((Typeref)t0).t == TypeCache.instance().VOID) {
                        tref = TypeCache.instance().NULL.ref;
                        break;
                    }
                    tref = t.ref;
                    break;
                }
                case 134: {
                    tref = TypeCache.instance().namedTypes.get((Name)e.ref).ref;
                    break;
                }
                case 135: {
                    Typeref t1 = types.get(e.args[1]);
                    if (t1.t.itype != null) {
                        if (t1.t.itype.atom || t1.t.itype.numeric) {
                            tref = TypeCache.instance().OBJECT.ref;
                            break;
                        }
                        tref = t1.t.itype.ref;
                        break;
                    }
                    tref = TypeCache.instance().ANY.ref;
                    break;
                }
                case 149: {
                    Object t0 = TypeAnalysis.type(types, e.args[0]);
                    if (t0 == TypeCache.instance().INT || t0 == TypeCache.instance().UINT || t0 == TypeCache.instance().NUMBER) {
                        v = "number";
                    } else if (t0 == TypeCache.instance().STRING) {
                        v = "string";
                    } else if (((Type)t0).extendsOrIsBase(TypeCache.instance().XML) || ((Type)t0).extendsOrIsBase(TypeCache.instance().XMLLIST)) {
                        v = "xml";
                    } else if (t0 == TypeCache.instance().VOID) {
                        v = "undefined";
                    } else if (t0 == TypeCache.instance().BOOLEAN) {
                        v = "boolean";
                    } else if (((Type)t0).extendsOrIsBase(TypeCache.instance().FUNCTION)) {
                        v = "function";
                    } else if (t0 != TypeCache.instance().OBJECT && ((Type)t0).extendsOrIsBase(TypeCache.instance().OBJECT)) {
                        v = "object";
                    }
                    tref = TypeCache.instance().STRING.ref.nonnull();
                    break;
                }
                case 160: {
                    Expr a0 = e.args[0];
                    Expr a1 = e.args[1];
                    Typeref t0 = types.get(a0);
                    Typeref t1 = types.get(a1);
                    Object v0 = values.get(a0);
                    Object v1 = values.get(a1);
                    if (t0.t == TypeCache.instance().STRING && !t0.nullable || t1.t == TypeCache.instance().STRING && !t1.nullable) {
                        tref = TypeCache.instance().STRING.ref.nonnull();
                        if (v0 != OptimizerConstants.BOTTOM && v1 != OptimizerConstants.BOTTOM) {
                            v = TypeAnalysis.stringValue(v0) + TypeAnalysis.stringValue(v1);
                        }
                        break;
                    }
                    if (t0.t.numeric && t1.t.numeric) {
                        tref = TypeCache.instance().NUMBER.ref;
                        if (v0 instanceof Number && v1 instanceof Number) {
                            v = TypeAnalysis.doubleValue(v0) + TypeAnalysis.doubleValue(v1);
                        }
                        break;
                    }
                    tref = TypeCache.instance().OBJECT.ref.nonnull();
                    break;
                }
                case 163: {
                    tref = TypeCache.instance().NUMBER.ref;
                    Object v0 = values.get(e.args[0]);
                    Object v1 = values.get(e.args[1]);
                    if (v0 instanceof Number && v1 instanceof Number) {
                        v = TypeAnalysis.doubleValue(v0) / TypeAnalysis.doubleValue(v1);
                    }
                    break;
                }
                case 144: 
                case 145: 
                case 147: 
                case 161: 
                case 162: 
                case 164: {
                    tref = TypeCache.instance().NUMBER.ref;
                    break;
                }
                case 117: {
                    tref = TypeCache.instance().NUMBER.ref;
                    v = TypeAnalysis.eval_convert_d(values.get(e.args[0]));
                    break;
                }
                case 115: {
                    tref = TypeCache.instance().INT.ref;
                    v = TypeAnalysis.eval_convert_i(values.get(e.args[0]));
                    break;
                }
                case 116: {
                    tref = TypeCache.instance().UINT.ref;
                    v = TypeAnalysis.eval_convert_u(values.get(e.args[0]));
                    break;
                }
                case 169: {
                    tref = TypeCache.instance().INT.ref;
                    Object v0 = values.get(e.args[0]);
                    Object v1 = values.get(e.args[1]);
                    if (v0 instanceof Number && v1 instanceof Number) {
                        v = TypeAnalysis.intValue(v0) | TypeAnalysis.intValue(v1);
                    }
                    break;
                }
                case 168: {
                    tref = TypeCache.instance().INT.ref;
                    Object v0 = values.get(e.args[0]);
                    Object v1 = values.get(e.args[1]);
                    if (v0 instanceof Number && v1 instanceof Number) {
                        v = TypeAnalysis.intValue(v0) & TypeAnalysis.intValue(v1);
                    }
                    break;
                }
                case 51: 
                case 151: 
                case 165: 
                case 166: 
                case 170: 
                case 192: 
                case 193: 
                case 196: 
                case 197: 
                case 198: 
                case 199: {
                    tref = TypeCache.instance().INT.ref;
                    break;
                }
                case 167: {
                    tref = TypeCache.instance().UINT.ref;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 29: 
                case 71: 
                case 72: 
                case 73: 
                case 78: 
                case 79: 
                case 97: 
                case 104: 
                case 109: 
                case 120: 
                case 239: 
                case 240: 
                case 241: 
                case 242: {
                    return;
                }
            }
        }
        assert (tref != null && ((Typeref)tref).t != null);
        if (((Typeref)tref).t == TypeCache.instance().VOID) {
            v = OptimizerConstants.UNDEFINED;
        } else if (((Typeref)tref).t == TypeCache.instance().NULL) {
            v = TypeCache.instance().NULL;
        }
        if (v != null && !v.equals(values.get(e))) {
            values.put(e, v);
            ssaWork.addAll((Collection<Expr>)uses.get(e));
        }
        if (!((Typeref)tref).equals(types.get(e))) {
            types.put(e, (Typeref)tref);
            ssaWork.addAll((Collection<Expr>)uses.get(e));
        }
    }

    public static boolean isPointer(Type t) {
        return !t.isAtom() && !t.numeric;
    }

    public static Object eval_convert_i(Object v0) {
        return v0 instanceof Number ? Integer.valueOf(TypeAnalysis.intValue(v0)) : (v0 == Boolean.TRUE ? Integer.valueOf(1) : (v0 == Boolean.FALSE ? Integer.valueOf(0) : OptimizerConstants.BOTTOM));
    }

    public static Object eval_convert_u(Object v0) {
        return v0 instanceof Number ? Long.valueOf(TypeAnalysis.uintValue(v0)) : (v0 == Boolean.TRUE ? Integer.valueOf(1) : (v0 == Boolean.FALSE ? Integer.valueOf(0) : OptimizerConstants.BOTTOM));
    }

    public static Object eval_convert_d(Object v0) {
        return v0 instanceof Number ? Double.valueOf(TypeAnalysis.doubleValue(v0)) : (v0 == Boolean.TRUE ? Integer.valueOf(1) : (v0 == Boolean.FALSE ? Integer.valueOf(0) : OptimizerConstants.BOTTOM));
    }

    public static Object eval_convert_b(Object v0) {
        return v0 == OptimizerConstants.BOTTOM ? OptimizerConstants.BOTTOM : (TypeAnalysis.booleanValue(v0) ? Boolean.TRUE : Boolean.FALSE);
    }

    public static Object eval_convert_s(Object v0) {
        return v0 != OptimizerConstants.BOTTOM ? TypeAnalysis.stringValue(v0) : OptimizerConstants.BOTTOM;
    }

    public static Typeref eval_coerce_s(Typeref t0) {
        if (t0.nullable) {
            return t0.t == TypeCache.instance().VOID || t0.t == TypeCache.instance().NULL ? TypeCache.instance().NULL.ref : TypeCache.instance().STRING.ref;
        }
        return TypeCache.instance().STRING.ref.nonnull();
    }

    public static Object eval_coerce_s(Object v0) {
        return v0 == OptimizerConstants.UNDEFINED || v0 == TypeCache.instance().NULL ? TypeCache.instance().NULL : (v0 != OptimizerConstants.BOTTOM ? TypeAnalysis.stringValue(v0) : OptimizerConstants.BOTTOM);
    }

    public static Typeref eval_coerce_o(Typeref t0) {
        if (t0.nullable) {
            return t0.t.extendsOrIsBase(TypeCache.instance().OBJECT) ? t0 : (t0.t == TypeCache.instance().VOID || t0.t == TypeCache.instance().NULL ? TypeCache.instance().NULL.ref : TypeCache.instance().OBJECT.ref);
        }
        return t0.t.extendsOrIsBase(TypeCache.instance().OBJECT) ? t0 : TypeCache.instance().OBJECT.ref.nonnull();
    }

    public static Object eval_coerce_o(Object v0, Type t0) {
        return t0.extendsOrIsBase(TypeCache.instance().OBJECT) ? v0 : (t0 == TypeCache.instance().VOID || t0 == TypeCache.instance().NULL ? TypeCache.instance().NULL : OptimizerConstants.BOTTOM);
    }

    public static boolean lessthan(Object v0, Object v1) {
        if (v0 instanceof String && v1 instanceof String) {
            return ((String)v0).compareTo((String)v1) < 0;
        }
        return TypeAnalysis.doubleValue(v0) < TypeAnalysis.doubleValue(v1);
    }

    public static Type type(Map<Expr, Typeref> types, Expr e) {
        assert (types.containsKey(e));
        return types.get((Object)e).t;
    }

    public static int intValue(Object o) {
        return ((Number)o).intValue();
    }

    public static long uintValue(Object o) {
        return ((Number)o).longValue() & 0xFFFFFFFFL;
    }

    public static double doubleValue(Object o) {
        return o instanceof Number ? ((Number)o).doubleValue() : Double.NaN;
    }

    public static boolean booleanValue(Object o) {
        if (o instanceof Boolean) {
            return o == Boolean.TRUE;
        }
        if (o instanceof String || o instanceof Namespace) {
            return true;
        }
        if (o == TypeCache.instance().NULL || o == OptimizerConstants.UNDEFINED) {
            return false;
        }
        return TypeAnalysis.doubleValue(o) != 0.0;
    }

    public static String stringValue(Object v0) {
        return String.valueOf(v0);
    }

    public static Typeref mdb(Typeref a, Typeref b) {
        assert (a != b && a != null && b != null);
        if (a.t == TypeCache.instance().NULL && TypeAnalysis.isPointer(b.t)) {
            return b;
        }
        if (b.t == TypeCache.instance().NULL && TypeAnalysis.isPointer(a.t)) {
            return a;
        }
        HashSet<Type> bases = new HashSet<Type>();
        Type t = a.t;
        while (t != null) {
            bases.add(t);
            t = t.base;
        }
        t = b.t;
        while (t != null) {
            if (bases.contains(t)) {
                return new Typeref(t, a.nullable | b.nullable);
            }
            t = t.base;
        }
        return new Typeref(TypeCache.instance().ANY, a.nullable | b.nullable);
    }

    public static int findInner(Name ref, Expr[] scopes, Map<Expr, Typeref> types) {
        for (int i = scopes.length - 1; i >= 0; --i) {
            Type st = TypeAnalysis.type(types, scopes[i]);
            Binding b = st.find(ref);
            if (b == null) continue;
            return i;
        }
        return -1;
    }

    public static int findOuter(Name ref, Typeref[] scopes) {
        for (int i = scopes.length - 1; i >= 1; --i) {
            Type st = scopes[i].t;
            Binding b = st.find(ref);
            if (b == null) continue;
            return i;
        }
        Typeref st = TypeCache.instance().globals.get(ref);
        if (st != null) {
            return -1;
        }
        if (scopes.length > 0 && scopes[0].t.find(ref) != null) {
            return 0;
        }
        return -1;
    }
}

