/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Edge;
import adobe.abc.GlobalOptimizer;
import adobe.abc.Method;
import adobe.abc.Name;
import adobe.abc.OptimizerConstants;
import adobe.abc.Type;
import adobe.abc.Typeref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Expr
implements Comparable<Expr> {
    public int op;
    public Expr[] args = OptimizerConstants.noexprs;
    public Expr[] scopes = OptimizerConstants.noexprs;
    public Expr[] locals = OptimizerConstants.noexprs;
    public int[] imm;
    public Edge[] pred = OptimizerConstants.noedges;
    public Edge[] succ;
    public int id;
    public int flags;
    public Name ref;
    public Object value;
    public Type c;
    public Method m;
    boolean is_live_out = false;
    Typeref inferred_type = null;

    public Expr(Method m, int op) {
        this.op = op;
        this.flags = OptimizerConstants.flagTable[op];
        this.id = m.getNextExprId();
    }

    public Expr(Method m, int op, int imm1) {
        this(m, op);
        this.imm = new int[]{imm1};
    }

    public Expr(Method m, int op, Object value) {
        this(m, op);
        this.value = value;
    }

    public Expr(Method m, int op, Expr arg) {
        this(m, op);
        this.args = new Expr[]{arg};
    }

    public Expr(Method m, int op, Expr[] frame, int sp, int argc) {
        this(m, op);
        this.args = GlobalOptimizer.capture(frame, sp, argc);
    }

    public Expr(Method m, int op, int imm1, Expr[] frame, int sp, int argc) {
        this(m, op, frame, sp, argc);
        this.imm = new int[]{imm1};
    }

    public Expr(Method m, int op, Name ref, Expr[] frame, int sp, int argc) {
        this(m, op, frame, sp, argc);
        this.ref = ref;
    }

    public Expr(Method m, int op, Name ref, Expr arg) {
        this(m, op);
        this.ref = ref;
        this.args = new Expr[]{arg};
    }

    public int id() {
        return this.id;
    }

    void append(Expr a, Edge p) {
        this.args = GlobalOptimizer.copyOf(this.args, this.args.length + 1);
        this.args[this.args.length - 1] = a;
        this.pred = GlobalOptimizer.copyOf(this.pred, this.pred.length + 1);
        this.pred[this.pred.length - 1] = p;
    }

    void removePhiInput(int j) {
        assert (10 == this.op);
        Expr[] a = new Expr[this.args.length - 1];
        System.arraycopy(this.args, 0, a, 0, j);
        System.arraycopy(this.args, j + 1, a, j, this.args.length - j - 1);
        this.args = a;
        Edge[] ed = new Edge[this.pred.length - 1];
        System.arraycopy(this.pred, 0, ed, 0, j);
        System.arraycopy(this.pred, j + 1, ed, j, this.pred.length - j - 1);
        this.pred = ed;
    }

    public String toString() {
        return (this.onStack() ? "t" : (this.onScope() ? "s" : (this.inLocal() ? "l" : "i"))) + this.id;
    }

    void clearEffect() {
        this.flags &= 0xFFFFFFFD;
    }

    void clearPx() {
        this.flags &= 0xFFFFFFF7;
    }

    public void setPure() {
        this.clearEffect();
        this.clearPx();
    }

    public boolean hasEffect() {
        return (this.flags & 2) != 0;
    }

    public boolean isPx() {
        return (this.flags & 8) != 0;
    }

    public boolean isSynthetic() {
        return (this.flags & 0x10) != 0;
    }

    public boolean onStack() {
        return (OptimizerConstants.flagTable[this.op] & 0x40) != 0;
    }

    public boolean isOper() {
        return (OptimizerConstants.flagTable[this.op] & 1) != 0;
    }

    public boolean onScope() {
        return (OptimizerConstants.flagTable[this.op] & 0x20) != 0;
    }

    public boolean inLocal() {
        return (OptimizerConstants.flagTable[this.op] & 0x80) != 0;
    }

    public boolean isCoerce() {
        return (OptimizerConstants.flagTable[this.op] & 4) != 0;
    }

    @Override
    public int compareTo(Expr other) {
        assert (this.id != other.id || this == other);
        return this.id - other.id;
    }
}

