/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom;

import com.adobe.fxg.FXGException;
import com.adobe.internal.fxg.dom.AbstractShapeNode;
import com.adobe.internal.fxg.dom.DOMParserHelper;
import flash.swf.types.LineStyle;
import flash.swf.types.Rect;
import flash.swf.types.ShapeRecord;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RectNode
extends AbstractShapeNode {
    public double width = 0.0;
    public double height = 0.0;
    public double radiusX = 0.0;
    public double radiusY = 0.0;
    public double topLeftRadiusX = Double.NaN;
    public double topLeftRadiusY = Double.NaN;
    public double topRightRadiusY = Double.NaN;
    public double topRightRadiusX = Double.NaN;
    public double bottomRightRadiusX = Double.NaN;
    public double bottomRightRadiusY = Double.NaN;
    public double bottomLeftRadiusX = Double.NaN;
    public double bottomLeftRadiusY = Double.NaN;

    @Override
    public String getNodeName() {
        return "Rect";
    }

    @Override
    public void setAttribute(String name, String value) {
        if ("width".equals(name)) {
            this.width = DOMParserHelper.parseDouble(this, value, name);
        } else if ("height".equals(name)) {
            this.height = DOMParserHelper.parseDouble(this, value, name);
        } else if ("radiusX".equals(name)) {
            this.radiusX = DOMParserHelper.parseDouble(this, value, name);
            if (this.radiusX < 0.0) {
                throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidRectRadiusXRadiusYAttribute", new Object[0]);
            }
        } else if ("radiusY".equals(name)) {
            this.radiusY = DOMParserHelper.parseDouble(this, value, name);
            if (this.radiusY < 0.0) {
                throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidRectRadiusXRadiusYAttribute", new Object[0]);
            }
        } else if ("topLeftRadiusX".equals(name)) {
            this.topLeftRadiusX = DOMParserHelper.parseDouble(this, value, name);
            if (this.topLeftRadiusX < 0.0) {
                throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidRectRadiusXRadiusYAttribute", new Object[0]);
            }
        } else if ("topLeftRadiusY".equals(name)) {
            this.topLeftRadiusY = DOMParserHelper.parseDouble(this, value, name);
            if (this.topLeftRadiusY < 0.0) {
                throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidRectRadiusXRadiusYAttribute", new Object[0]);
            }
        } else if ("topRightRadiusX".equals(name)) {
            this.topRightRadiusX = DOMParserHelper.parseDouble(this, value, name);
            if (this.topRightRadiusX < 0.0) {
                throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidRectRadiusXRadiusYAttribute", new Object[0]);
            }
        } else if ("topRightRadiusY".equals(name)) {
            this.topRightRadiusY = DOMParserHelper.parseDouble(this, value, name);
            if (this.topRightRadiusY < 0.0) {
                throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidRectRadiusXRadiusYAttribute", new Object[0]);
            }
        } else if ("bottomLeftRadiusX".equals(name)) {
            this.bottomLeftRadiusX = DOMParserHelper.parseDouble(this, value, name);
            if (this.bottomLeftRadiusX < 0.0) {
                throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidRectRadiusXRadiusYAttribute", new Object[0]);
            }
        } else if ("bottomLeftRadiusY".equals(name)) {
            this.bottomLeftRadiusY = DOMParserHelper.parseDouble(this, value, name);
            if (this.bottomLeftRadiusY < 0.0) {
                throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidRectRadiusXRadiusYAttribute", new Object[0]);
            }
        } else if ("bottomRightRadiusX".equals(name)) {
            this.bottomRightRadiusX = DOMParserHelper.parseDouble(this, value, name);
            if (this.bottomRightRadiusX < 0.0) {
                throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidRectRadiusXRadiusYAttribute", new Object[0]);
            }
        } else if ("bottomRightRadiusY".equals(name)) {
            this.bottomRightRadiusY = DOMParserHelper.parseDouble(this, value, name);
            if (this.bottomRightRadiusY < 0.0) {
                throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidRectRadiusXRadiusYAttribute", new Object[0]);
            }
        } else {
            super.setAttribute(name, value);
        }
    }

    @Override
    public Rect getBounds(List<ShapeRecord> records, LineStyle ls) {
        int x1 = 0;
        int y1 = 0;
        int x2 = (int)(this.width * 20.0);
        int y2 = (int)(this.height * 20.0);
        if (ls != null) {
            int width = 20;
            if (width < ls.width) {
                width = ls.width;
            }
            int stroke = (int)Math.rint((double)width / 2.0);
            x1 -= stroke;
            y1 -= stroke;
            x2 += stroke;
            y2 += stroke;
        }
        return new Rect(x1, x2, y1, y2);
    }
}

