/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.asdoc;

import flex2.tools.ASDocConfiguration;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ASDocConfigHandler
extends DefaultHandler {
    private BufferedWriter writer;
    private Map<String, String> configMap = new HashMap<String, String>();
    private boolean skipCharacters;

    public ASDocConfigHandler(BufferedWriter w, ASDocConfiguration config) {
        this.writer = w;
        if (config.getMainTitle() != null) {
            this.configMap.put("title", config.getMainTitle());
        }
        if (config.getWindowTitle() != null) {
            this.configMap.put("windowTitle", config.getWindowTitle());
        }
        if (config.getFooter() != null) {
            this.configMap.put("footer", config.getFooter());
        }
        if (config.getExamplesPath() != null) {
            this.configMap.put("includeExamplesDirectory", config.getExamplesPath());
        }
        this.configMap.put("dateInFooter", String.valueOf(config.getDateInFooter()));
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if (!this.configMap.containsKey(qName)) {
                this.skipCharacters = false;
                this.writer.newLine();
                this.writer.write("<" + qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.writer.write(" " + attributes.getQName(i) + "=\"" + attributes.getValue(i) + "\"");
                }
                this.writer.write(">");
            } else {
                this.skipCharacters = true;
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (qName.equals("asDocConfig")) {
                for (Map.Entry<String, String> entry : this.configMap.entrySet()) {
                    this.writer.newLine();
                    this.writer.write("<" + entry.getKey() + ">" + entry.getValue() + "</" + entry.getKey() + ">");
                }
            }
            if (this.configMap.get(qName) == null) {
                this.writer.write("</" + qName + ">");
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.skipCharacters) {
            try {
                this.writer.write(new String(ch, start, length));
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
        }
    }
}

