/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.forks.velocity.runtime.resource.loader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.flex.forks.velocity.exception.ResourceNotFoundException;
import org.apache.flex.forks.velocity.runtime.resource.Resource;
import org.apache.flex.forks.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.flex.forks.velocity.util.StringUtils;

public class FileResourceLoader
extends ResourceLoader {
    private Vector paths = null;
    private Hashtable templatePaths = new Hashtable();

    public void init(ExtendedProperties configuration) {
        this.rsvc.info("FileResourceLoader : initialization starting.");
        this.paths = configuration.getVector("path");
        int sz = this.paths.size();
        for (int i = 0; i < sz; ++i) {
            this.rsvc.info("FileResourceLoader : adding path '" + (String)this.paths.get(i) + "'");
        }
        this.rsvc.info("FileResourceLoader : initialization complete.");
    }

    public synchronized InputStream getResourceStream(String templateName) throws ResourceNotFoundException {
        if (templateName == null || templateName.length() == 0) {
            throw new ResourceNotFoundException("Need to specify a file name or file path!");
        }
        String template = StringUtils.normalizePath(templateName);
        if (template == null || template.length() == 0) {
            String msg = "File resource error : argument " + template + " contains .. and may be trying to access " + "content outside of template root.  Rejected.";
            this.rsvc.error("FileResourceLoader : " + msg);
            throw new ResourceNotFoundException(msg);
        }
        if (template.startsWith("/")) {
            template = template.substring(1);
        }
        int size = this.paths.size();
        for (int i = 0; i < size; ++i) {
            String path = (String)this.paths.get(i);
            InputStream inputStream = this.findTemplate(path, template);
            if (inputStream == null) continue;
            this.templatePaths.put(templateName, path);
            return inputStream;
        }
        String msg = "FileResourceLoader Error: cannot find resource " + template;
        throw new ResourceNotFoundException(msg);
    }

    private InputStream findTemplate(String path, String template) {
        try {
            File file = new File(path, template);
            if (file.canRead()) {
                return new BufferedInputStream(new FileInputStream(file.getAbsolutePath()));
            }
            return null;
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
    }

    public boolean isSourceModified(Resource resource) {
        boolean modified = true;
        String fileName = resource.getName();
        String path = (String)this.templatePaths.get(fileName);
        File currentFile = null;
        for (int i = 0; currentFile == null && i < this.paths.size(); ++i) {
            String testPath = (String)this.paths.get(i);
            File testFile = new File(testPath, fileName);
            if (!testFile.canRead()) continue;
            currentFile = testFile;
        }
        File file = new File(path, fileName);
        if (currentFile != null && file.exists() && currentFile.equals(file) && file.canRead()) {
            modified = file.lastModified() != resource.getLastModified();
        }
        return modified;
    }

    public long getLastModified(Resource resource) {
        String path = (String)this.templatePaths.get(resource.getName());
        File file = new File(path, resource.getName());
        if (file.canRead()) {
            return file.lastModified();
        }
        return 0L;
    }
}

