/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.binding;

import flex2.compiler.CompilationUnit;
import flex2.compiler.as3.AbstractSyntaxTreeUtil;
import flex2.compiler.as3.binding.BindableInfo;
import flex2.compiler.as3.binding.ClassInfo;
import flex2.compiler.as3.binding.InterfaceInfo;
import flex2.compiler.as3.binding.TypeAnalyzer;
import flex2.compiler.as3.genext.GenerativeClassInfo;
import flex2.compiler.as3.genext.GenerativeSecondPassEvaluator;
import flex2.compiler.as3.reflect.NodeMagic;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.QName;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.BinaryExpressionNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.ExpressionStatementNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.FunctionNameNode;
import macromedia.asc.parser.FunctionSignatureNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralBooleanNode;
import macromedia.asc.parser.LiteralNullNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.ReturnStatementNode;
import macromedia.asc.parser.SelectorNode;
import macromedia.asc.parser.SetExpressionNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.ThisExpressionNode;
import macromedia.asc.parser.TypeExpressionNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindableSecondPassEvaluator
extends GenerativeSecondPassEvaluator {
    private static final String ADD_EVENT_LISTENER = "addEventListener".intern();
    private static final String BINDABLE = "Bindable".intern();
    private static final String BOOLEAN = "Boolean".intern();
    private static final String CREATE_UPDATE_EVENT = "createUpdateEvent".intern();
    private static final String DISPATCH_EVENT = "dispatchEvent".intern();
    private static final String EVENT_VAR = "event".intern();
    private static final String EVENT_CLASS = "Event".intern();
    private static final String EVENT_DISPATCHER_VAR = "eventDispatcher".intern();
    private static final String EVENT_DISPATCHER_CLASS = "EventDispatcher".intern();
    private static final String FLASH_EVENTS = "flash.events".intern();
    private static final String FUNCTION = "Function".intern();
    private static final String HAS_EVENT_LISTENER = "hasEventListener".intern();
    private static final String INT = "int".intern();
    private static final String I_EVENT_DISPATCHER = "IEventDispatcher".intern();
    private static final String LISTENER = "listener".intern();
    private static final String MX_EVENTS = "mx.events".intern();
    private static final String OBJECT = "Object".intern();
    private static final String OLD_VALUE = "oldValue".intern();
    private static final String PRIORITY = "priority".intern();
    private static final String PROPERTY_CHANGE = "propertyChange".intern();
    private static final String PROPERTY_CHANGE_EVENT = "PropertyChangeEvent".intern();
    private static final String REMOVE_EVENT_LISTENER = "removeEventListener".intern();
    private static final String STRING = "String".intern();
    private static final String TYPE = "type".intern();
    private static final String USE_CAPTURE = "useCapture".intern();
    private static final String VALUE = "value".intern();
    private static final String WEAK_REF = "weakRef".intern();
    private static final String WILL_TRIGGER = "willTrigger".intern();
    private static final String _BINDING_EVENT_DISPATCHER = "_bindingEventDispatcher".intern();
    private static final String _STATIC_BINDING_EVENT_DISPATCHER = "_staticBindingEventDispatcher".intern();
    private static final String DOT = ".";
    private static final String SPACE = " ";
    private static final String CODEGEN_TEMPLATE_PATH = "flex2/compiler/as3/binding/";
    private static final String STATIC_EVENT_DISPATCHER = "staticEventDispatcher";
    private BindableInfo bindableInfo;
    private boolean inClass = false;

    public BindableSecondPassEvaluator(CompilationUnit unit, Map<String, ? extends GenerativeClassInfo> classMap, TypeAnalyzer typeAnalyzer, String generatedOutputDirectory, boolean generateAbstractSyntaxTree, boolean processComments) {
        super(unit, classMap, typeAnalyzer, generatedOutputDirectory, generateAbstractSyntaxTree, processComments);
    }

    private void addIEventDispatcherImplementation(Context context, ClassDefinitionNode classDefinition) {
        NodeFactory nodeFactory = context.getNodeFactory();
        MemberExpressionNode memberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, FLASH_EVENTS, I_EVENT_DISPATCHER, false);
        classDefinition.interfaces = nodeFactory.list(classDefinition.interfaces, (Node)memberExpression);
        VariableDefinitionNode variableDefinition = this.generateBindingEventDispatcherVariable(nodeFactory);
        classDefinition.statements = nodeFactory.statementList(classDefinition.statements, (Node)variableDefinition);
        DocCommentNode docCommentNode = this.generateInheritDocComment(context);
        classDefinition.statements = nodeFactory.statementList(classDefinition.statements, (Node)docCommentNode);
        FunctionDefinitionNode addEventListenerFunctionDefinition = this.generateAddEventListenerFunctionDefinition(context);
        classDefinition.statements = nodeFactory.statementList(classDefinition.statements, (Node)addEventListenerFunctionDefinition);
        docCommentNode = this.generateInheritDocComment(context);
        classDefinition.statements = nodeFactory.statementList(classDefinition.statements, (Node)docCommentNode);
        FunctionDefinitionNode dispatchEventFunctionDefinition = this.generateDispatchEventFunctionDefinition(context);
        classDefinition.statements = nodeFactory.statementList(classDefinition.statements, (Node)dispatchEventFunctionDefinition);
        docCommentNode = this.generateInheritDocComment(context);
        classDefinition.statements = nodeFactory.statementList(classDefinition.statements, (Node)docCommentNode);
        FunctionDefinitionNode hasEventListenerFunctionDefinition = this.generateHasEventListenerFunctionDefinition(context);
        classDefinition.statements = nodeFactory.statementList(classDefinition.statements, (Node)hasEventListenerFunctionDefinition);
        docCommentNode = this.generateInheritDocComment(context);
        classDefinition.statements = nodeFactory.statementList(classDefinition.statements, (Node)docCommentNode);
        FunctionDefinitionNode removeEventListenerFunctionDefinition = this.generateRemoveEventListenerFunctionDefinition(context);
        classDefinition.statements = nodeFactory.statementList(classDefinition.statements, (Node)removeEventListenerFunctionDefinition);
        docCommentNode = this.generateInheritDocComment(context);
        classDefinition.statements = nodeFactory.statementList(classDefinition.statements, (Node)docCommentNode);
        FunctionDefinitionNode willTriggerFunctionDefinition = this.generateWillTriggerFunctionDefinition(context);
        classDefinition.statements = nodeFactory.statementList(classDefinition.statements, (Node)willTriggerFunctionDefinition);
    }

    private void addStaticEventDispatcherImplementation(Context context, ClassDefinitionNode classDefinition) {
        NodeFactory nodeFactory = context.getNodeFactory();
        VariableDefinitionNode variableDefinition = this.generateStaticBindingEventDispatcherVariable(nodeFactory);
        classDefinition.statements = nodeFactory.statementList(classDefinition.statements, (Node)variableDefinition);
        FunctionDefinitionNode addEventListenerFunctionDefinition = this.generateStaticEventDispatcherGetter(context);
        classDefinition.statements = nodeFactory.statementList(classDefinition.statements, (Node)addEventListenerFunctionDefinition);
    }

    @Override
    public Value evaluate(Context context, ClassDefinitionNode node) {
        if (!this.evaluatedClasses.contains(node)) {
            this.inClass = true;
            String className = NodeMagic.getClassName(node);
            this.bindableInfo = (BindableInfo)this.classMap.get(className);
            if (this.bindableInfo != null) {
                ClassInfo classInfo = this.bindableInfo.getClassInfo();
                if (!classInfo.implementsInterface("flash.events", "IEventDispatcher")) {
                    this.bindableInfo.setNeedsToImplementIEventDispatcher(true);
                    MultiName multiName = new MultiName("flash.events", "IEventDispatcher");
                    InterfaceInfo interfaceInfo = this.typeAnalyzer.analyzeInterface(context, multiName, classInfo);
                    if (interfaceInfo == null || this.checkForExistingMethods(context, node, classInfo, interfaceInfo)) {
                        return null;
                    }
                    classInfo.addInterfaceMultiName("flash.events", "IEventDispatcher");
                }
                if (this.bindableInfo.getRequiresStaticEventDispatcher() && !classInfo.definesVariable(STATIC_EVENT_DISPATCHER) && !classInfo.definesGetter(STATIC_EVENT_DISPATCHER, true)) {
                    this.bindableInfo.setNeedsStaticEventDispatcher(true);
                }
                this.postProcessClassInfo(context, this.bindableInfo);
                this.prepClassDef(node);
                if (node.statements != null) {
                    node.statements.evaluate(context, (Evaluator)this);
                    this.modifySyntaxTree(context, node, this.bindableInfo);
                }
                this.bindableInfo = null;
            }
            this.inClass = false;
            this.evaluatedClasses.add(node);
        }
        return null;
    }

    private AttributeListNode generateAttributeList(NodeFactory nodeFactory, String attributeString) {
        AttributeListNode result = null;
        if (attributeString.length() > 0) {
            int index = attributeString.indexOf(SPACE);
            if (index > -1) {
                IdentifierNode identifier = nodeFactory.identifier(attributeString.substring(index + 1));
                AttributeListNode attributeList = nodeFactory.attributeList((Node)identifier, null);
                MemberExpressionNode memberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, attributeString.substring(0, index), true);
                ListNode list = nodeFactory.list(null, (Node)memberExpression);
                result = nodeFactory.attributeList((Node)list, attributeList);
            } else {
                MemberExpressionNode memberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, attributeString, true);
                ListNode list = nodeFactory.list(null, (Node)memberExpression);
                result = nodeFactory.attributeList((Node)list, null);
            }
        }
        return result;
    }

    private VariableDefinitionNode generateBindingEventDispatcherVariable(NodeFactory nodeFactory) {
        AttributeListNode attributeList = AbstractSyntaxTreeUtil.generatePrivateAttribute(nodeFactory);
        IdentifierNode identifier = nodeFactory.identifier(_BINDING_EVENT_DISPATCHER, false);
        QualifiedIdentifierNode eventDispatcherQualifiedIdentifier = AbstractSyntaxTreeUtil.generateQualifiedIdentifier(nodeFactory, FLASH_EVENTS, EVENT_DISPATCHER_CLASS, false);
        QualifiedIdentifierNode iEventDispatcherQualifiedIdentifier = AbstractSyntaxTreeUtil.generateQualifiedIdentifier(nodeFactory, FLASH_EVENTS, I_EVENT_DISPATCHER, false);
        ThisExpressionNode thisExpression = nodeFactory.thisExpression(0);
        ArgumentListNode castArgumentList = nodeFactory.argumentList(null, (Node)thisExpression);
        CallExpressionNode castCallExpression = (CallExpressionNode)nodeFactory.callExpression((Node)iEventDispatcherQualifiedIdentifier, castArgumentList);
        castCallExpression.setRValue(false);
        MemberExpressionNode innerMemberExpression = nodeFactory.memberExpression(null, (SelectorNode)castCallExpression);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)innerMemberExpression);
        CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)eventDispatcherQualifiedIdentifier, argumentList);
        callExpression.is_new = true;
        callExpression.setRValue(false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression(null, (SelectorNode)callExpression);
        return AbstractSyntaxTreeUtil.generateVariable(nodeFactory, attributeList, identifier, FLASH_EVENTS, EVENT_DISPATCHER_CLASS, false, (Node)memberExpression);
    }

    private StatementListNode generateDispatchEventCall(NodeFactory nodeFactory, StatementListNode then, String qualifiedPropertyName) {
        ThisExpressionNode innerThisExpression = nodeFactory.thisExpression(0);
        IdentifierNode dispatchEventIdentifier = nodeFactory.identifier(DISPATCH_EVENT, false);
        MemberExpressionNode propertyChangeEventMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, MX_EVENTS, PROPERTY_CHANGE_EVENT, false);
        IdentifierNode createUpdateEventIdentifier = nodeFactory.identifier(CREATE_UPDATE_EVENT, false);
        ThisExpressionNode thisExpression = nodeFactory.thisExpression(0);
        ArgumentListNode createUpdateEventArgumentList = nodeFactory.argumentList(null, (Node)innerThisExpression);
        LiteralStringNode literalString = nodeFactory.literalString(qualifiedPropertyName);
        createUpdateEventArgumentList = nodeFactory.argumentList(createUpdateEventArgumentList, (Node)literalString);
        MemberExpressionNode oldValueMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, OLD_VALUE, false);
        createUpdateEventArgumentList = nodeFactory.argumentList(createUpdateEventArgumentList, (Node)oldValueMemberExpression);
        MemberExpressionNode valueMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, VALUE, false);
        createUpdateEventArgumentList = nodeFactory.argumentList(createUpdateEventArgumentList, (Node)valueMemberExpression);
        CallExpressionNode createUpdateEventCallExpression = (CallExpressionNode)nodeFactory.callExpression((Node)createUpdateEventIdentifier, createUpdateEventArgumentList);
        createUpdateEventCallExpression.setRValue(false);
        MemberExpressionNode createUpdateEventMemberExpression = nodeFactory.memberExpression((Node)propertyChangeEventMemberExpression, (SelectorNode)createUpdateEventCallExpression);
        ArgumentListNode dispatchEventArgumentList = nodeFactory.argumentList(null, (Node)createUpdateEventMemberExpression);
        CallExpressionNode dispatchEventCallExpression = (CallExpressionNode)nodeFactory.callExpression((Node)dispatchEventIdentifier, dispatchEventArgumentList);
        dispatchEventCallExpression.setRValue(false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)thisExpression, (SelectorNode)dispatchEventCallExpression);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        ExpressionStatementNode expressionStatement = nodeFactory.expressionStatement((Node)list);
        ThisExpressionNode ifThisExpression = nodeFactory.thisExpression(0);
        IdentifierNode hasEventListenerIdentifier = nodeFactory.identifier(HAS_EVENT_LISTENER, false);
        LiteralStringNode propChangeLiteralString = nodeFactory.literalString(PROPERTY_CHANGE);
        CallExpressionNode hasEventListenerCallExpression = (CallExpressionNode)nodeFactory.callExpression((Node)hasEventListenerIdentifier, nodeFactory.argumentList(null, (Node)propChangeLiteralString));
        hasEventListenerCallExpression.setRValue(false);
        MemberExpressionNode ifMemberExpression = nodeFactory.memberExpression((Node)ifThisExpression, (SelectorNode)hasEventListenerCallExpression);
        ListNode iftest = nodeFactory.list(null, (Node)ifMemberExpression);
        Node ifStatement = nodeFactory.ifStatement(iftest, (Node)expressionStatement, null);
        return nodeFactory.statementList(then, ifStatement);
    }

    private DocCommentNode generateInheritDocComment(Context context) {
        NodeFactory nodeFactory = context.getNodeFactory();
        return AbstractSyntaxTreeUtil.generateInheritDocComment(nodeFactory);
    }

    private FunctionDefinitionNode generateAddEventListenerFunctionDefinition(Context context) {
        NodeFactory nodeFactory = context.getNodeFactory();
        AttributeListNode attributeList = AbstractSyntaxTreeUtil.generatePublicAttribute(nodeFactory);
        IdentifierNode addEventListenerIdentifier = nodeFactory.identifier(ADD_EVENT_LISTENER, false);
        FunctionNameNode functionName = nodeFactory.functionName(-133, addEventListenerIdentifier);
        ParameterNode typeParameter = AbstractSyntaxTreeUtil.generateParameter(nodeFactory, TYPE, STRING, false);
        ParameterListNode parameterList = nodeFactory.parameterList(null, typeParameter);
        ParameterNode listenerParameter = AbstractSyntaxTreeUtil.generateParameter(nodeFactory, LISTENER, FUNCTION, false);
        parameterList = nodeFactory.parameterList(parameterList, listenerParameter);
        LiteralBooleanNode literalBoolean = nodeFactory.literalBoolean(false);
        ParameterNode useCaptureParameter = AbstractSyntaxTreeUtil.generateParameter(nodeFactory, USE_CAPTURE, BOOLEAN, false, (Node)literalBoolean);
        parameterList = nodeFactory.parameterList(parameterList, useCaptureParameter);
        LiteralNumberNode literalNumber = nodeFactory.literalNumber(0);
        ParameterNode priorityParameter = AbstractSyntaxTreeUtil.generateParameter(nodeFactory, PRIORITY, INT, false, (Node)literalNumber);
        parameterList = nodeFactory.parameterList(parameterList, priorityParameter);
        literalBoolean = nodeFactory.literalBoolean(false);
        ParameterNode weakRefParameter = AbstractSyntaxTreeUtil.generateParameter(nodeFactory, WEAK_REF, BOOLEAN, false, (Node)literalBoolean);
        parameterList = nodeFactory.parameterList(parameterList, weakRefParameter);
        FunctionSignatureNode functionSignature = nodeFactory.functionSignature(parameterList, null);
        functionSignature.void_anno = true;
        MemberExpressionNode _bindingEventDispatcherGetterSelector = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, _BINDING_EVENT_DISPATCHER, false);
        IdentifierNode identifier = nodeFactory.identifier(ADD_EVENT_LISTENER, false);
        MemberExpressionNode typeGetterSelector = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, TYPE, false);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)typeGetterSelector);
        MemberExpressionNode listenerGetterSelector = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, LISTENER, false);
        argumentList = nodeFactory.argumentList(argumentList, (Node)listenerGetterSelector);
        MemberExpressionNode useCaptureGetterSelector = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, USE_CAPTURE, false);
        argumentList = nodeFactory.argumentList(argumentList, (Node)useCaptureGetterSelector);
        MemberExpressionNode priorityGetterSelector = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, PRIORITY, false);
        argumentList = nodeFactory.argumentList(argumentList, (Node)priorityGetterSelector);
        MemberExpressionNode weakRefGetterSelector = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, WEAK_REF, false);
        argumentList = nodeFactory.argumentList(argumentList, (Node)weakRefGetterSelector);
        CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)identifier, argumentList);
        callExpression.setRValue(false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)_bindingEventDispatcherGetterSelector, (SelectorNode)callExpression);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        ExpressionStatementNode expressionStatement = nodeFactory.expressionStatement((Node)list);
        StatementListNode functionStatementList = nodeFactory.statementList(null, (Node)expressionStatement);
        FunctionCommonNode functionCommon = nodeFactory.functionCommon(context, null, functionSignature, functionStatementList);
        functionCommon.setUserDefinedBody(true);
        return nodeFactory.functionDefinition(context, attributeList, functionName, functionCommon);
    }

    private FunctionDefinitionNode generateDispatchEventFunctionDefinition(Context context) {
        NodeFactory nodeFactory = context.getNodeFactory();
        AttributeListNode attributeList = AbstractSyntaxTreeUtil.generatePublicAttribute(nodeFactory);
        IdentifierNode dispatchEventIdentifier = nodeFactory.identifier(DISPATCH_EVENT, false);
        FunctionNameNode functionName = nodeFactory.functionName(-133, dispatchEventIdentifier);
        ParameterNode parameter = AbstractSyntaxTreeUtil.generateParameter(nodeFactory, EVENT_VAR, FLASH_EVENTS, EVENT_CLASS, false);
        ParameterListNode parameterList = nodeFactory.parameterList(null, parameter);
        MemberExpressionNode returnTypeMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, BOOLEAN, true);
        TypeExpressionNode returnType = nodeFactory.typeExpression((Node)returnTypeMemberExpression, true, false, -1);
        FunctionSignatureNode functionSignature = nodeFactory.functionSignature(parameterList, (Node)returnType);
        MemberExpressionNode _bindingEventDispatcherGetterSelector = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, _BINDING_EVENT_DISPATCHER, false);
        IdentifierNode identifier = nodeFactory.identifier(DISPATCH_EVENT, false);
        MemberExpressionNode eventGetterSelector = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, EVENT_VAR, false);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)eventGetterSelector);
        CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)identifier, argumentList);
        callExpression.setRValue(false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)_bindingEventDispatcherGetterSelector, (SelectorNode)callExpression);
        ListNode returnList = nodeFactory.list(null, (Node)memberExpression);
        ReturnStatementNode returnStatement = nodeFactory.returnStatement((Node)returnList);
        StatementListNode functionStatementList = nodeFactory.statementList(null, (Node)returnStatement);
        FunctionCommonNode functionCommon = nodeFactory.functionCommon(context, null, functionSignature, functionStatementList);
        functionCommon.setUserDefinedBody(true);
        return nodeFactory.functionDefinition(context, attributeList, functionName, functionCommon);
    }

    private ListNode generateEventDispatcherNotNull(NodeFactory nodeFactory) {
        MemberExpressionNode memberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, EVENT_DISPATCHER_VAR, false);
        LiteralNullNode literalNull = nodeFactory.literalNull();
        BinaryExpressionNode binaryExpression = nodeFactory.binaryExpression(-6, (Node)memberExpression, (Node)literalNull);
        return nodeFactory.list(null, (Node)binaryExpression);
    }

    private FunctionDefinitionNode generateGetter(Context context, String className, GenerativeClassInfo.AccessorInfo accessorInfo) {
        ReturnStatementNode returnStatement;
        String qualifiedBackingPropertyName;
        NodeFactory nodeFactory = context.getNodeFactory();
        String typeName = accessorInfo.getTypeName();
        int index = typeName.lastIndexOf(DOT);
        int position = ((GenerativeClassInfo.VariableInfo)accessorInfo).getPosition();
        TypeExpressionNode returnType = AbstractSyntaxTreeUtil.generateTypeExpression(nodeFactory, typeName, true);
        FunctionSignatureNode functionSignature = nodeFactory.functionSignature(null, (Node)returnType);
        AttributeListNode attributeList = this.generateAttributeList(nodeFactory, accessorInfo.getAttributeString());
        IdentifierNode identifier = nodeFactory.identifier(accessorInfo.getPropertyName());
        FunctionNameNode functionName = nodeFactory.functionName(-79, identifier);
        if (accessorInfo.getIsStatic()) {
            MemberExpressionNode getterSelector = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, className, false);
            qualifiedBackingPropertyName = accessorInfo.getQualifiedBackingPropertyName().intern();
            IdentifierNode identifer = AbstractSyntaxTreeUtil.generateIdentifier(nodeFactory, qualifiedBackingPropertyName, false);
            GetExpressionNode getExpression = nodeFactory.getExpression(identifer);
            MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)getterSelector, (SelectorNode)getExpression);
            ListNode returnList = nodeFactory.list(null, (Node)memberExpression);
            returnStatement = nodeFactory.returnStatement((Node)returnList);
        } else {
            ThisExpressionNode thisExpression = nodeFactory.thisExpression(0);
            qualifiedBackingPropertyName = accessorInfo.getQualifiedBackingPropertyName().intern();
            IdentifierNode identifer = AbstractSyntaxTreeUtil.generateIdentifier(nodeFactory, qualifiedBackingPropertyName, false);
            GetExpressionNode getExpression = nodeFactory.getExpression(identifer);
            MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)thisExpression, (SelectorNode)getExpression);
            ListNode returnList = nodeFactory.list(null, (Node)memberExpression);
            returnStatement = nodeFactory.returnStatement((Node)returnList);
        }
        StatementListNode functionStatementList = nodeFactory.statementList(null, (Node)returnStatement);
        FunctionCommonNode functionCommon = nodeFactory.functionCommon(context, null, functionSignature, functionStatementList, position);
        functionCommon.setUserDefinedBody(true);
        return nodeFactory.functionDefinition(context, attributeList, functionName, functionCommon);
    }

    private FunctionDefinitionNode generateHasEventListenerFunctionDefinition(Context context) {
        NodeFactory nodeFactory = context.getNodeFactory();
        AttributeListNode attributeList = AbstractSyntaxTreeUtil.generatePublicAttribute(nodeFactory);
        IdentifierNode hasEventListenerIdentifier = nodeFactory.identifier(HAS_EVENT_LISTENER, false);
        FunctionNameNode functionName = nodeFactory.functionName(-133, hasEventListenerIdentifier);
        ParameterNode typeParameter = AbstractSyntaxTreeUtil.generateParameter(nodeFactory, TYPE, STRING, false);
        ParameterListNode parameterList = nodeFactory.parameterList(null, typeParameter);
        MemberExpressionNode returnTypeMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, BOOLEAN, true);
        TypeExpressionNode returnType = nodeFactory.typeExpression((Node)returnTypeMemberExpression, true, false, -1);
        FunctionSignatureNode functionSignature = nodeFactory.functionSignature(parameterList, (Node)returnType);
        MemberExpressionNode _bindingEventDispatcherGetterSelector = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, _BINDING_EVENT_DISPATCHER, false);
        IdentifierNode identifier = nodeFactory.identifier(HAS_EVENT_LISTENER, false);
        MemberExpressionNode typeGetterSelector = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, TYPE, false);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)typeGetterSelector);
        CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)identifier, argumentList);
        callExpression.setRValue(false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)_bindingEventDispatcherGetterSelector, (SelectorNode)callExpression);
        ListNode returnList = nodeFactory.list(null, (Node)memberExpression);
        ReturnStatementNode returnStatement = nodeFactory.returnStatement((Node)returnList);
        StatementListNode functionStatementList = nodeFactory.statementList(null, (Node)returnStatement);
        FunctionCommonNode functionCommon = nodeFactory.functionCommon(context, null, functionSignature, functionStatementList);
        functionCommon.setUserDefinedBody(true);
        return nodeFactory.functionDefinition(context, attributeList, functionName, functionCommon);
    }

    private ListNode generateOldValueStrictlyNotEqualsValueText(NodeFactory nodeFactory) {
        MemberExpressionNode oldValueMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, OLD_VALUE, false);
        MemberExpressionNode valueMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, VALUE, false);
        BinaryExpressionNode binaryExpression = nodeFactory.binaryExpression(-6, (Node)oldValueMemberExpression, (Node)valueMemberExpression);
        return nodeFactory.list(null, (Node)binaryExpression);
    }

    private VariableDefinitionNode generateOldValueVariable(NodeFactory nodeFactory, String setterAccessPropertyName) {
        ThisExpressionNode thisExpression = nodeFactory.thisExpression(0);
        IdentifierNode identifer = AbstractSyntaxTreeUtil.generateIdentifier(nodeFactory, setterAccessPropertyName, false);
        GetExpressionNode getExpression = nodeFactory.getExpression(identifer);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)thisExpression, (SelectorNode)getExpression);
        return AbstractSyntaxTreeUtil.generateVariable(nodeFactory, OLD_VALUE, OBJECT, false, (Node)memberExpression);
    }

    private FunctionDefinitionNode generateRemoveEventListenerFunctionDefinition(Context context) {
        NodeFactory nodeFactory = context.getNodeFactory();
        AttributeListNode attributeList = AbstractSyntaxTreeUtil.generatePublicAttribute(nodeFactory);
        IdentifierNode removeEventListenerIdentifier = nodeFactory.identifier(REMOVE_EVENT_LISTENER, false);
        FunctionNameNode functionName = nodeFactory.functionName(-133, removeEventListenerIdentifier);
        ParameterNode typeParameter = AbstractSyntaxTreeUtil.generateParameter(nodeFactory, TYPE, STRING, false);
        ParameterListNode parameterList = nodeFactory.parameterList(null, typeParameter);
        ParameterNode listenerParameter = AbstractSyntaxTreeUtil.generateParameter(nodeFactory, LISTENER, FUNCTION, false);
        parameterList = nodeFactory.parameterList(parameterList, listenerParameter);
        LiteralBooleanNode literalBoolean = nodeFactory.literalBoolean(false);
        ParameterNode useCaptureParameter = AbstractSyntaxTreeUtil.generateParameter(nodeFactory, USE_CAPTURE, BOOLEAN, false, (Node)literalBoolean);
        parameterList = nodeFactory.parameterList(parameterList, useCaptureParameter);
        FunctionSignatureNode functionSignature = nodeFactory.functionSignature(parameterList, null);
        functionSignature.void_anno = true;
        MemberExpressionNode _bindingEventDispatcherGetterSelector = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, _BINDING_EVENT_DISPATCHER, false);
        IdentifierNode identifier = nodeFactory.identifier(REMOVE_EVENT_LISTENER, false);
        MemberExpressionNode typeGetterSelector = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, TYPE, false);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)typeGetterSelector);
        MemberExpressionNode listenerGetterSelector = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, LISTENER, false);
        argumentList = nodeFactory.argumentList(argumentList, (Node)listenerGetterSelector);
        MemberExpressionNode useCaptureGetterSelector = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, USE_CAPTURE, false);
        argumentList = nodeFactory.argumentList(argumentList, (Node)useCaptureGetterSelector);
        CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)identifier, argumentList);
        callExpression.setRValue(false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)_bindingEventDispatcherGetterSelector, (SelectorNode)callExpression);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        ExpressionStatementNode expressionStatement = nodeFactory.expressionStatement((Node)list);
        StatementListNode functionStatementList = nodeFactory.statementList(null, (Node)expressionStatement);
        FunctionCommonNode functionCommon = nodeFactory.functionCommon(context, null, functionSignature, functionStatementList);
        functionCommon.setUserDefinedBody(true);
        return nodeFactory.functionDefinition(context, attributeList, functionName, functionCommon);
    }

    private FunctionDefinitionNode generateSetter(Context context, String className, GenerativeClassInfo.AccessorInfo accessorInfo) {
        StatementListNode functionStatementList;
        VariableDefinitionNode variableDefinition;
        NodeFactory nodeFactory = context.getNodeFactory();
        int position = -1;
        if (accessorInfo instanceof GenerativeClassInfo.VariableInfo) {
            position = ((GenerativeClassInfo.VariableInfo)accessorInfo).getPosition();
        } else if (accessorInfo instanceof GenerativeClassInfo.GetterSetterInfo) {
            position = ((GenerativeClassInfo.GetterSetterInfo)accessorInfo).getSetterPosition();
        }
        ParameterNode parameter = AbstractSyntaxTreeUtil.generateParameter(nodeFactory, VALUE, accessorInfo.getTypeName(), true, position);
        ParameterListNode parameterList = nodeFactory.parameterList(null, parameter);
        FunctionSignatureNode functionSignature = nodeFactory.functionSignature(parameterList, null);
        functionSignature.void_anno = true;
        AttributeListNode attributeList = this.generateAttributeList(nodeFactory, accessorInfo.getAttributeString());
        IdentifierNode propertyNameIdentifier = nodeFactory.identifier(accessorInfo.getPropertyName());
        FunctionNameNode functionName = nodeFactory.functionName(-99, propertyNameIdentifier);
        String qualifiedBackingPropertyName = accessorInfo.getQualifiedBackingPropertyName().intern();
        String setterAccessPropertyName = accessorInfo.getIsFunction() ? accessorInfo.getQualifiedPropertyName().intern() : qualifiedBackingPropertyName;
        if (accessorInfo.getIsStatic()) {
            variableDefinition = this.generateStaticOldValueVariable(nodeFactory, className, setterAccessPropertyName);
            functionStatementList = nodeFactory.statementList(null, (Node)variableDefinition);
            ListNode test = this.generateOldValueStrictlyNotEqualsValueText(nodeFactory);
            StatementListNode then = this.generateStaticSetterAssignment(nodeFactory, className, qualifiedBackingPropertyName);
            then = this.generateStaticDispatchEventCall(nodeFactory, then, className, accessorInfo.getQualifiedPropertyName());
            Node ifStatement = nodeFactory.ifStatement(test, (Node)then, null);
            functionStatementList = nodeFactory.statementList(functionStatementList, ifStatement);
        } else {
            variableDefinition = this.generateOldValueVariable(nodeFactory, setterAccessPropertyName);
            functionStatementList = nodeFactory.statementList(null, (Node)variableDefinition);
            ListNode test = this.generateOldValueStrictlyNotEqualsValueText(nodeFactory);
            StatementListNode then = this.generateSetterAssignment(nodeFactory, qualifiedBackingPropertyName);
            then = this.generateDispatchEventCall(nodeFactory, then, accessorInfo.getQualifiedPropertyName());
            Node ifStatement = nodeFactory.ifStatement(test, (Node)then, null);
            functionStatementList = nodeFactory.statementList(functionStatementList, ifStatement);
        }
        FunctionCommonNode functionCommon = nodeFactory.functionCommon(context, null, functionSignature, functionStatementList);
        functionCommon.setUserDefinedBody(true);
        return nodeFactory.functionDefinition(context, attributeList, functionName, functionCommon);
    }

    private StatementListNode generateSetterAssignment(NodeFactory nodeFactory, String qualifiedBackingPropertyName) {
        ThisExpressionNode outerThisExpression = nodeFactory.thisExpression(0);
        IdentifierNode identifier = AbstractSyntaxTreeUtil.generateIdentifier(nodeFactory, qualifiedBackingPropertyName, false);
        MemberExpressionNode getterSelector = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, VALUE, false);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)getterSelector);
        SetExpressionNode setExpression = nodeFactory.setExpression((Node)identifier, argumentList, false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)outerThisExpression, (SelectorNode)setExpression);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        ExpressionStatementNode expressionStatement = nodeFactory.expressionStatement((Node)list);
        return nodeFactory.statementList(null, (Node)expressionStatement);
    }

    private VariableDefinitionNode generateStaticBindingEventDispatcherVariable(NodeFactory nodeFactory) {
        AttributeListNode attributeList = AbstractSyntaxTreeUtil.generatePrivateStaticAttribute(nodeFactory);
        IdentifierNode _staticBindingEventDispatcherIdentifier = nodeFactory.identifier(_STATIC_BINDING_EVENT_DISPATCHER, false);
        QualifiedIdentifierNode qualifiedIdentifier = AbstractSyntaxTreeUtil.generateQualifiedIdentifier(nodeFactory, FLASH_EVENTS, EVENT_DISPATCHER_CLASS, false);
        CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)qualifiedIdentifier, null);
        callExpression.is_new = true;
        callExpression.setRValue(false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression(null, (SelectorNode)callExpression);
        return AbstractSyntaxTreeUtil.generateVariable(nodeFactory, attributeList, _staticBindingEventDispatcherIdentifier, FLASH_EVENTS, EVENT_DISPATCHER_CLASS, false, (Node)memberExpression);
    }

    private StatementListNode generateStaticDispatchEventCall(NodeFactory nodeFactory, StatementListNode outerThen, String className, String qualifiedPropertyName) {
        MemberExpressionNode base = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, className, false);
        IdentifierNode staticEventDispatcherIdentifier = nodeFactory.identifier(STATIC_EVENT_DISPATCHER, false);
        GetExpressionNode selector = nodeFactory.getExpression(staticEventDispatcherIdentifier);
        MemberExpressionNode rvalue = nodeFactory.memberExpression((Node)base, (SelectorNode)selector);
        VariableDefinitionNode variableDefinition = AbstractSyntaxTreeUtil.generateVariable(nodeFactory, EVENT_DISPATCHER_VAR, FLASH_EVENTS, I_EVENT_DISPATCHER, false, (Node)rvalue);
        outerThen = nodeFactory.statementList(outerThen, (Node)variableDefinition);
        ListNode test = this.generateEventDispatcherNotNull(nodeFactory);
        IdentifierNode dispatchEventIdentifier = nodeFactory.identifier(DISPATCH_EVENT, false);
        MemberExpressionNode propertyChangeEventMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, MX_EVENTS, PROPERTY_CHANGE_EVENT, false);
        IdentifierNode createUpdateEventIdentifier = nodeFactory.identifier(CREATE_UPDATE_EVENT, false);
        MemberExpressionNode getterSelector = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, className, false);
        ArgumentListNode createUpdateEventArgumentList = nodeFactory.argumentList(null, (Node)getterSelector);
        LiteralStringNode literalString = nodeFactory.literalString(qualifiedPropertyName);
        createUpdateEventArgumentList = nodeFactory.argumentList(createUpdateEventArgumentList, (Node)literalString);
        MemberExpressionNode oldValueMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, OLD_VALUE, false);
        createUpdateEventArgumentList = nodeFactory.argumentList(createUpdateEventArgumentList, (Node)oldValueMemberExpression);
        MemberExpressionNode valueMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, VALUE, false);
        createUpdateEventArgumentList = nodeFactory.argumentList(createUpdateEventArgumentList, (Node)valueMemberExpression);
        CallExpressionNode createUpdateEventCallExpression = (CallExpressionNode)nodeFactory.callExpression((Node)createUpdateEventIdentifier, createUpdateEventArgumentList);
        createUpdateEventCallExpression.setRValue(false);
        MemberExpressionNode createUpdateEventMemberExpression = nodeFactory.memberExpression((Node)propertyChangeEventMemberExpression, (SelectorNode)createUpdateEventCallExpression);
        ArgumentListNode dispatchEventArgumentList = nodeFactory.argumentList(null, (Node)createUpdateEventMemberExpression);
        CallExpressionNode dispatchEventCallExpression = (CallExpressionNode)nodeFactory.callExpression((Node)dispatchEventIdentifier, dispatchEventArgumentList);
        dispatchEventCallExpression.setRValue(false);
        MemberExpressionNode eventDispatcherMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, EVENT_DISPATCHER_VAR, false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)eventDispatcherMemberExpression, (SelectorNode)dispatchEventCallExpression);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        ExpressionStatementNode expressionStatement = nodeFactory.expressionStatement((Node)list);
        StatementListNode then = nodeFactory.statementList(null, (Node)expressionStatement);
        Node ifStatement = nodeFactory.ifStatement(test, (Node)then, null);
        return nodeFactory.statementList(outerThen, ifStatement);
    }

    private FunctionDefinitionNode generateStaticEventDispatcherGetter(Context context) {
        NodeFactory nodeFactory = context.getNodeFactory();
        MemberExpressionNode returnTypeMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, I_EVENT_DISPATCHER, true);
        TypeExpressionNode returnType = nodeFactory.typeExpression((Node)returnTypeMemberExpression, true, false, -1);
        FunctionSignatureNode functionSignature = nodeFactory.functionSignature(null, (Node)returnType);
        AttributeListNode attributeList = AbstractSyntaxTreeUtil.generatePublicStaticAttribute(nodeFactory);
        IdentifierNode staticEventDispatcherIdentifier = nodeFactory.identifier(STATIC_EVENT_DISPATCHER, false);
        FunctionNameNode functionName = nodeFactory.functionName(-79, staticEventDispatcherIdentifier);
        MemberExpressionNode memberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, _STATIC_BINDING_EVENT_DISPATCHER, false);
        ListNode returnList = nodeFactory.list(null, (Node)memberExpression);
        ReturnStatementNode returnStatement = nodeFactory.returnStatement((Node)returnList);
        StatementListNode functionStatementList = nodeFactory.statementList(null, (Node)returnStatement);
        FunctionCommonNode functionCommon = nodeFactory.functionCommon(context, null, functionSignature, functionStatementList);
        functionCommon.setUserDefinedBody(true);
        return nodeFactory.functionDefinition(context, attributeList, functionName, functionCommon);
    }

    private VariableDefinitionNode generateStaticOldValueVariable(NodeFactory nodeFactory, String className, String qualifiedBackingPropertyName) {
        MemberExpressionNode base = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, className, false);
        IdentifierNode identifer = nodeFactory.identifier(qualifiedBackingPropertyName, false);
        GetExpressionNode getExpression = nodeFactory.getExpression(identifer);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)base, (SelectorNode)getExpression);
        return AbstractSyntaxTreeUtil.generateVariable(nodeFactory, OLD_VALUE, OBJECT, false, (Node)memberExpression);
    }

    private StatementListNode generateStaticSetterAssignment(NodeFactory nodeFactory, String className, String qualifiedBackingPropertyName) {
        MemberExpressionNode base = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, className, false);
        IdentifierNode identifier = AbstractSyntaxTreeUtil.generateIdentifier(nodeFactory, qualifiedBackingPropertyName, false);
        MemberExpressionNode getterSelector = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, VALUE, false);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)getterSelector);
        SetExpressionNode setExpression = nodeFactory.setExpression((Node)identifier, argumentList, false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)base, (SelectorNode)setExpression);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        ExpressionStatementNode expressionStatement = nodeFactory.expressionStatement((Node)list);
        return nodeFactory.statementList(null, (Node)expressionStatement);
    }

    private FunctionDefinitionNode generateWillTriggerFunctionDefinition(Context context) {
        NodeFactory nodeFactory = context.getNodeFactory();
        AttributeListNode attributeList = AbstractSyntaxTreeUtil.generatePublicAttribute(nodeFactory);
        IdentifierNode willTriggerIdentifier = nodeFactory.identifier(WILL_TRIGGER, false);
        FunctionNameNode functionName = nodeFactory.functionName(-133, willTriggerIdentifier);
        ParameterNode typeParameter = AbstractSyntaxTreeUtil.generateParameter(nodeFactory, TYPE, STRING, false);
        ParameterListNode parameterList = nodeFactory.parameterList(null, typeParameter);
        MemberExpressionNode returnTypeMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, BOOLEAN, true);
        TypeExpressionNode returnType = nodeFactory.typeExpression((Node)returnTypeMemberExpression, true, false, -1);
        FunctionSignatureNode functionSignature = nodeFactory.functionSignature(parameterList, (Node)returnType);
        MemberExpressionNode _bindingEventDispatcherGetterSelector = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, _BINDING_EVENT_DISPATCHER, false);
        IdentifierNode identifier = nodeFactory.identifier(WILL_TRIGGER, false);
        MemberExpressionNode typeGetterSelector = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, TYPE, false);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)typeGetterSelector);
        CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)identifier, argumentList);
        callExpression.setRValue(false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)_bindingEventDispatcherGetterSelector, (SelectorNode)callExpression);
        ListNode returnList = nodeFactory.list(null, (Node)memberExpression);
        ReturnStatementNode returnStatement = nodeFactory.returnStatement((Node)returnList);
        StatementListNode functionStatementList = nodeFactory.statementList(null, (Node)returnStatement);
        FunctionCommonNode functionCommon = nodeFactory.functionCommon(context, null, functionSignature, functionStatementList);
        functionCommon.setUserDefinedBody(true);
        return nodeFactory.functionDefinition(context, attributeList, functionName, functionCommon);
    }

    protected void modifySyntaxTree(Context context, ClassDefinitionNode classDefinition, BindableInfo bindableInfo) {
        if (this.generateAbstractSyntaxTree) {
            Map<QName, GenerativeClassInfo.AccessorInfo> accessors = bindableInfo.getAccessors();
            if (accessors != null) {
                for (GenerativeClassInfo.AccessorInfo accessorInfo : accessors.values()) {
                    NodeFactory nodeFactory = context.getNodeFactory();
                    String className = bindableInfo.getClassName().intern();
                    StatementListNode statementList = classDefinition.statements;
                    if (!accessorInfo.getIsFunction()) {
                        FunctionDefinitionNode getter = this.generateGetter(context, className, accessorInfo);
                        this.moveMetaDataToNewDefinition(nodeFactory, accessorInfo.getDefinitionNode(), (DefinitionNode)getter, statementList, true);
                        nodeFactory.statementList(statementList, (Node)getter);
                    }
                    FunctionDefinitionNode setter = this.generateSetter(context, className, accessorInfo);
                    if (accessorInfo.getIsFunction()) {
                        GenerativeClassInfo.GetterSetterInfo getterSetterInfo = (GenerativeClassInfo.GetterSetterInfo)accessorInfo;
                        boolean processedBindable = this.processGetterMetaData(nodeFactory, getterSetterInfo.getGetterFunctionDefinition());
                        this.moveMetaDataToNewDefinition(nodeFactory, (DefinitionNode)getterSetterInfo.getSetterFunctionDefinition(), (DefinitionNode)setter, statementList, !processedBindable);
                    }
                    nodeFactory.statementList(statementList, (Node)setter);
                }
            }
            if (bindableInfo.getNeedsToImplementIEventDispatcher()) {
                this.addIEventDispatcherImplementation(context, classDefinition);
            }
            if (bindableInfo.getNeedsStaticEventDispatcher()) {
                this.addStaticEventDispatcherImplementation(context, classDefinition);
            }
        } else {
            super.modifySyntaxTree(context, classDefinition, bindableInfo);
        }
    }

    private void moveMetaDataToNewDefinition(NodeFactory nodeFactory, DefinitionNode fromDefinition, DefinitionNode toDefinition, StatementListNode classDefinitionStatementList, boolean addBindableMetaData) {
        boolean processedBindableMetaData = false;
        if (fromDefinition != null && fromDefinition.metaData != null) {
            for (Node node : fromDefinition.metaData.items) {
                MetaDataNode metaData = (MetaDataNode)node;
                if (metaData.getId() != null && metaData.getId().equals("Bindable") && metaData.count() == 0) {
                    this.processBindableMetaData(nodeFactory, metaData);
                    processedBindableMetaData = true;
                }
                metaData.def = toDefinition;
                classDefinitionStatementList.items.remove((Object)metaData);
                nodeFactory.statementList(classDefinitionStatementList, (Node)metaData);
                toDefinition.metaData = nodeFactory.statementList(toDefinition.metaData, (Node)metaData);
            }
            fromDefinition.metaData = null;
        }
        if (addBindableMetaData && !processedBindableMetaData) {
            MetaDataNode bindableMetaData = AbstractSyntaxTreeUtil.generateMetaData(nodeFactory, BINDABLE, EVENT_VAR, PROPERTY_CHANGE);
            nodeFactory.statementList(classDefinitionStatementList, (Node)bindableMetaData);
            this.prepMetaDataNode(nodeFactory.getContext(), bindableMetaData);
        }
    }

    private void processBindableMetaData(NodeFactory nodeFactory, MetaDataNode metaData) {
        assert (metaData.count() == 0);
        Value[] vals = new Value[]{new MetaDataEvaluator.KeyValuePair(EVENT_VAR, PROPERTY_CHANGE)};
        metaData.setValues(vals);
        this.prepMetaDataNode(nodeFactory.getContext(), metaData);
    }

    private boolean processGetterMetaData(NodeFactory nodeFactory, FunctionDefinitionNode getter) {
        boolean processedBindableMetaData = false;
        if (getter != null && getter.metaData != null) {
            for (Node node : getter.metaData.items) {
                MetaDataNode metaData = (MetaDataNode)node;
                if (metaData.getId() == null || !metaData.getId().equals("Bindable") || metaData.count() != 0) continue;
                this.processBindableMetaData(nodeFactory, metaData);
                processedBindableMetaData = true;
            }
        }
        return processedBindableMetaData;
    }

    private void prepClassDef(ClassDefinitionNode node) {
        if (node.metaData != null && node.metaData.items != null) {
            Iterator iter = node.metaData.items.iterator();
            while (iter.hasNext()) {
                MetaDataNode md = (MetaDataNode)iter.next();
                if (!"Bindable".equals(md.getId()) || md.count() != 0) continue;
                iter.remove();
            }
        }
    }

    @Override
    public Value evaluate(Context context, FunctionDefinitionNode node) {
        QName qname;
        GenerativeClassInfo.AccessorInfo accessorInfo;
        if (this.inClass && (accessorInfo = this.bindableInfo.getAccessor(qname = new QName(NodeMagic.getUserNamespace((DefinitionNode)node), NodeMagic.getFunctionName(node)))) instanceof GenerativeClassInfo.GetterSetterInfo) {
            if (NodeMagic.functionIsSetter(node)) {
                BindableSecondPassEvaluator.hideFunction(node, accessorInfo);
                this.registerRenamedAccessor(accessorInfo);
                ((GenerativeClassInfo.GetterSetterInfo)accessorInfo).setSetterInfo(node);
            } else {
                ((GenerativeClassInfo.GetterSetterInfo)accessorInfo).setGetterInfo(node);
                if (!this.bindableInfo.getClassInfo().definesSetter(qname.getLocalPart(), false)) {
                    context.localizedError2(node.pos(), (Object)new MissingNonInheritedSetter(qname.getLocalPart()));
                }
            }
        }
        return null;
    }

    @Override
    public Value evaluate(Context context, VariableDefinitionNode node) {
        QName qname;
        GenerativeClassInfo.AccessorInfo accessorInfo;
        if (this.inClass && (accessorInfo = this.bindableInfo.getAccessor(qname = new QName(NodeMagic.getUserNamespace((DefinitionNode)node), NodeMagic.getVariableName(node)))) != null) {
            BindableSecondPassEvaluator.hideVariable(node, accessorInfo);
            this.registerRenamedAccessor(accessorInfo);
        }
        return null;
    }

    @Override
    protected String getTemplateName() {
        return this.standardDefs.getBindablePropertyTemplate();
    }

    @Override
    protected String getTemplatePath() {
        return CODEGEN_TEMPLATE_PATH;
    }

    @Override
    protected Map<String, BindableInfo> getTemplateVars() {
        HashMap<String, BindableInfo> vars = new HashMap<String, BindableInfo>();
        vars.put("bindableInfo", this.bindableInfo);
        return vars;
    }

    @Override
    protected String getGeneratedSuffix() {
        return "-binding-generated.as";
    }

    public static class MissingNonInheritedSetter
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -1787062656834309810L;
        public String getter;

        public MissingNonInheritedSetter(String getter) {
            this.getter = getter;
        }
    }
}

