/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineTag;
import flex2.compiler.AssetInfo;
import flex2.compiler.io.VirtualFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Assets {
    private Map<String, AssetInfo> assets;
    private static final Iterator<Map.Entry<String, AssetInfo>> EMPTY_ITERATOR = new Iterator<Map.Entry<String, AssetInfo>>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Map.Entry<String, AssetInfo> next() {
            return null;
        }

        @Override
        public void remove() {
        }
    };

    public void add(String className, AssetInfo assetInfo) {
        if (this.assets == null) {
            this.assets = new HashMap<String, AssetInfo>(4);
        }
        this.assets.put(className, assetInfo);
    }

    public void add(String className, DefineTag tag) {
        if (this.assets == null) {
            this.assets = new HashMap<String, AssetInfo>(4);
        }
        this.assets.put(className, new AssetInfo(tag));
    }

    public void addAll(Assets ass) {
        if (ass.assets == null) {
            return;
        }
        if (this.assets == null) {
            this.assets = new HashMap<String, AssetInfo>(4);
        }
        this.assets.putAll(ass.assets);
    }

    public int count() {
        return this.assets == null ? 0 : this.assets.size();
    }

    public boolean contains(String className) {
        return this.assets == null ? false : this.assets.containsKey(className);
    }

    public AssetInfo get(String className) {
        return this.assets == null ? null : this.assets.get(className);
    }

    public Iterator<Map.Entry<String, AssetInfo>> iterator() {
        return this.assets == null ? EMPTY_ITERATOR : this.assets.entrySet().iterator();
    }

    public boolean isUpdated() {
        boolean result = false;
        if (this.assets != null) {
            for (AssetInfo assetInfo : this.assets.values()) {
                VirtualFile path = assetInfo.getPath();
                if (path == null || assetInfo.getCreationTime() == path.getLastModified()) continue;
                result = true;
            }
        }
        return result;
    }

    public List<DefineFont> getFonts() {
        LinkedList<DefineFont> fonts = new LinkedList<DefineFont>();
        if (this.assets != null) {
            for (AssetInfo assetInfo : this.assets.values()) {
                DefineTag defineTag = assetInfo.getDefineTag();
                if (!(defineTag instanceof DefineFont)) continue;
                fonts.add((DefineFont)defineTag);
            }
        }
        return fonts;
    }

    public boolean exists(String name) {
        return this.assets != null && this.assets.containsValue(name);
    }

    public int size() {
        return this.assets == null ? 0 : this.assets.size();
    }
}

