/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.upnp.internal;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.upnp.UPnPEventListener;

final class SessionObject
implements HttpSessionBindingListener,
UPnPEventListener {
    static final String LISTENER_CLASS = (class$org$osgi$service$upnp$UPnPEventListener == null ? (class$org$osgi$service$upnp$UPnPEventListener = SessionObject.class$("org.osgi.service.upnp.UPnPEventListener")) : class$org$osgi$service$upnp$UPnPEventListener).getName();
    private final Map vars = new HashMap();
    private final String sessionID;
    private final Map store;
    private String udn;
    private String urn;
    private final BundleContext bc;
    private final Hashtable regProps = new Hashtable(3);
    private ServiceRegistration reg;
    static /* synthetic */ Class class$org$osgi$service$upnp$UPnPEventListener;

    SessionObject(BundleContext bc, String sessionID, Map store) {
        this.bc = bc;
        this.sessionID = sessionID;
        this.store = store;
    }

    public void valueBound(HttpSessionBindingEvent event) {
        this.store.put(this.sessionID, this);
    }

    public final void valueUnbound(HttpSessionBindingEvent event) {
        this.unsubscribe();
        this.store.remove(this.sessionID);
    }

    public final void notifyUPnPEvent(String deviceId, String serviceId, Dictionary events) {
        if (this.sameDevice(deviceId, serviceId)) {
            Enumeration e = events.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                this.vars.put(key, events.get(key));
            }
        }
    }

    private final boolean sameDevice(String udn, String urn) {
        String _udn = this.udn;
        String _urn = this.urn;
        if (_udn == null || _urn == null) {
            return false;
        }
        return _udn.equals(udn) && _urn.equals(urn);
    }

    final synchronized SessionObject subscribe(String udn, String urn) {
        if (!this.sameDevice(udn, urn)) {
            this.unsubscribe();
            this.udn = udn;
            this.urn = urn;
            try {
                this.regProps.put("upnp.filter", this.bc.createFilter("(&(UPnP.device.UDN=" + udn + ")(" + "UPnP.service.id" + '=' + urn + "))"));
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
            this.reg = this.bc.registerService(LISTENER_CLASS, (Object)this, (Dictionary)this.regProps);
        }
        return this;
    }

    final synchronized SessionObject unsubscribe() {
        this.urn = null;
        this.udn = null;
        this.vars.clear();
        if (this.reg != null) {
            try {
                this.reg.unregister();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.reg = null;
        }
        return this;
    }

    final Object getValue(String name) {
        return this.vars.get(name);
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SessionObject [sessionID=").append(this.sessionID).append(", udn=").append(this.udn).append(", urn=").append(this.urn).append(", vars=").append(this.vars).append(']');
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

