/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.servlet.ConfigurationSupport;
import org.apache.felix.webconsole.internal.servlet.ConfigurationUtil;
import org.apache.felix.webconsole.internal.servlet.OsgiManager;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

class ConfigurationMetatypeSupport
extends ConfigurationSupport
implements MetaTypeProvider {
    private static final String[] CONF_PROPS = new String[]{"manager.root", "/system/console", "http.service.filter", "", "default.render", "bundles", "realm", "OSGi Management Console", "username", "admin", "category", "Main", "locale", ""};
    private final Object ocdLock = new Object();
    private String ocdLocale;
    private ObjectClassDefinition ocd;

    ConfigurationMetatypeSupport(OsgiManager osgiManager) {
        super(osgiManager);
    }

    public String[] getLocales() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectClassDefinition getObjectClassDefinition(String id, String locale) {
        if (!this.osgiManager.getConfigurationPid().equals(id)) {
            return null;
        }
        if (locale == null) {
            locale = Locale.ENGLISH.getLanguage();
        }
        Object object = this.ocdLock;
        synchronized (object) {
            if (this.ocd != null && this.ocdLocale != null && this.ocdLocale.equals(locale)) {
                return this.ocd;
            }
        }
        ObjectClassDefinition xocd = null;
        Locale localeObj = Util.parseLocaleString(locale);
        final ResourceBundle rb = this.osgiManager.resourceBundleManager.getResourceBundle(this.osgiManager.getBundleContext().getBundle(), localeObj);
        Map<String, Object> defaultConfig = this.osgiManager.getDefaultConfiguration();
        final ArrayList<AttributeDefinitionImpl> adList = new ArrayList<AttributeDefinitionImpl>();
        for (int i = 0; i < CONF_PROPS.length; ++i) {
            String key = CONF_PROPS[i++];
            String defaultValue = ConfigurationUtil.getProperty(defaultConfig, key, CONF_PROPS[i]);
            String name = ConfigurationMetatypeSupport.getString(rb, "metadata." + key + ".name", key);
            String descr = ConfigurationMetatypeSupport.getString(rb, "metadata." + key + ".description", key);
            adList.add(new AttributeDefinitionImpl(key, name, descr, defaultValue));
        }
        String pwKey = "password";
        adList.add(new AttributeDefinitionImpl("password", ConfigurationMetatypeSupport.getString(rb, "metadata.password.name", "password"), ConfigurationMetatypeSupport.getString(rb, "metadata.password.description", "password")));
        String propKey = "secret.heuristic.enabled";
        adList.add(new AttributeDefinitionImpl("secret.heuristic.enabled", ConfigurationMetatypeSupport.getString(rb, "metadata.secret.heuristic.enabled.name", "secret.heuristic.enabled"), ConfigurationMetatypeSupport.getString(rb, "metadata.secret.heuristic.enabled.description", "secret.heuristic.enabled"), false));
        adList.add(new AttributeDefinitionImpl("loglevel", ConfigurationMetatypeSupport.getString(rb, "metadata.loglevel.name", "loglevel"), ConfigurationMetatypeSupport.getString(rb, "metadata.loglevel.description", "loglevel"), 3, new String[]{String.valueOf(ConfigurationUtil.getProperty(defaultConfig, "loglevel", 2))}, 0, new String[]{ConfigurationMetatypeSupport.getString(rb, "log.level.debug", "Debug"), ConfigurationMetatypeSupport.getString(rb, "log.level.info", "Information"), ConfigurationMetatypeSupport.getString(rb, "log.level.warn", "Warn"), ConfigurationMetatypeSupport.getString(rb, "log.level.error", "Error")}, new String[]{"4", "3", "2", "1"}));
        TreeMap<String, String> namesByClassName = new TreeMap<String, String>();
        String[] defaultPluginsClasses = OsgiManager.PLUGIN_MAP;
        for (int i = 0; i < defaultPluginsClasses.length; ++i) {
            String clazz = defaultPluginsClasses[i++];
            String label = defaultPluginsClasses[i];
            String name = ConfigurationMetatypeSupport.getString(rb, label + ".pluginTitle", label);
            namesByClassName.put(clazz, name);
        }
        String[] classes = namesByClassName.keySet().toArray(new String[namesByClassName.size()]);
        String[] names = namesByClassName.values().toArray(new String[namesByClassName.size()]);
        adList.add(new AttributeDefinitionImpl("plugins", ConfigurationMetatypeSupport.getString(rb, "metadata.plugins.name", "plugins"), ConfigurationMetatypeSupport.getString(rb, "metadata.plugins.description", "plugins"), 1, classes, Integer.MIN_VALUE, names, classes));
        xocd = new ObjectClassDefinition(){
            private final AttributeDefinition[] attrs;
            {
                this.attrs = adList.toArray(new AttributeDefinition[adList.size()]);
            }

            public String getName() {
                return ConfigurationMetatypeSupport.getString(rb, "metadata.name", "Apache Felix OSGi Management Console");
            }

            public InputStream getIcon(int arg0) {
                return null;
            }

            public String getID() {
                return ConfigurationMetatypeSupport.this.osgiManager.getConfigurationPid();
            }

            public String getDescription() {
                return ConfigurationMetatypeSupport.getString(rb, "metadata.description", "Configuration of the Apache Felix OSGi Management Console.");
            }

            public AttributeDefinition[] getAttributeDefinitions(int filter) {
                return filter == 2 ? null : this.attrs;
            }
        };
        Object object2 = this.ocdLock;
        synchronized (object2) {
            this.ocd = xocd;
            this.ocdLocale = locale;
        }
        return this.ocd;
    }

    private static final String getString(ResourceBundle rb, String key, String def) {
        try {
            return rb.getString(key);
        }
        catch (Throwable t) {
            return def;
        }
    }

    private static class AttributeDefinitionImpl
    implements AttributeDefinition {
        private final String id;
        private final String name;
        private final String description;
        private final int type;
        private final String[] defaultValues;
        private final int cardinality;
        private final String[] optionLabels;
        private final String[] optionValues;

        AttributeDefinitionImpl(String id, String name, String description) {
            this(id, name, description, 12, null, 0, null, null);
        }

        AttributeDefinitionImpl(String id, String name, String description, boolean defaultValue) {
            this(id, name, description, 11, new String[]{String.valueOf(defaultValue)}, 0, null, null);
        }

        AttributeDefinitionImpl(String id, String name, String description, String defaultValue) {
            this(id, name, description, 1, new String[]{defaultValue}, 0, null, null);
        }

        AttributeDefinitionImpl(String id, String name, String description, int type, String[] defaultValues, int cardinality, String[] optionLabels, String[] optionValues) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.type = type;
            this.defaultValues = defaultValues;
            this.cardinality = cardinality;
            this.optionLabels = optionLabels;
            this.optionValues = optionValues;
        }

        public int getCardinality() {
            return this.cardinality;
        }

        public String[] getDefaultValue() {
            return this.defaultValues;
        }

        public String getDescription() {
            return this.description;
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String[] getOptionLabels() {
            return this.optionLabels;
        }

        public String[] getOptionValues() {
            return this.optionValues;
        }

        public int getType() {
            return this.type;
        }

        public String validate(String arg0) {
            return null;
        }
    }
}

