/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.configuration;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.configuration.ConfigAdminSupport;
import org.apache.felix.webconsole.internal.configuration.ConfigurationUtil;
import org.apache.felix.webconsole.internal.configuration.MetaTypeServiceSupport;
import org.apache.felix.webconsole.internal.configuration.MetatypePropertyDescriptor;
import org.apache.felix.webconsole.internal.configuration.PropertyDescriptor;
import org.apache.felix.webconsole.internal.misc.ServletSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.metatype.ObjectClassDefinition;

class ConfigJsonSupport {
    private final ServletSupport servletSupport;
    private final MetaTypeServiceSupport mtss;
    private final ConfigurationAdmin configurationAdmin;

    public ConfigJsonSupport(ServletSupport support, MetaTypeServiceSupport mtss, ConfigurationAdmin cfgAdmin) {
        this.servletSupport = support;
        this.mtss = mtss;
        this.configurationAdmin = cfgAdmin;
    }

    public void printConfigurationJson(PrintWriter pw, String pid, Configuration config, String pidFilter, String locale) {
        JSONWriter result = new JSONWriter(pw);
        if (pid != null) {
            try {
                result.object();
                this.configForm(result, pid, config, pidFilter, locale);
                result.endObject();
            }
            catch (Exception e) {
                this.servletSupport.log("Error reading configuration PID " + pid, e);
            }
        }
    }

    void configForm(JSONWriter json, String pid, Configuration config, String pidFilter, String locale) throws IOException {
        json.key("pid");
        json.value(pid);
        if (pidFilter != null) {
            json.key("pidFilter");
            json.value(pidFilter);
        }
        Hashtable<String, Object> props = null;
        if (config != null) {
            props = config.getProperties();
        }
        if (props == null) {
            props = new Hashtable<String, Object>();
        }
        boolean doSimpleMerge = true;
        if (this.mtss != null) {
            ObjectClassDefinition ocd = null;
            if (config != null) {
                ocd = this.mtss.getObjectClassDefinition(config, locale);
            }
            if (ocd == null) {
                ocd = this.mtss.getObjectClassDefinition(pid, locale);
            }
            if (ocd != null) {
                this.mtss.mergeWithMetaType(props, ocd, json, ConfigAdminSupport.CONFIG_PROPERTIES_HIDE);
                doSimpleMerge = false;
            }
        }
        if (doSimpleMerge) {
            json.key("title").value(pid);
            json.key("description").value("This form is automatically generated from existing properties because no property descriptors are available for this configuration. This may be cause by the absence of the OSGi Metatype Service or the absence of a MetaType descriptor for this configuration.");
            json.key("properties").object();
            Enumeration pe = ((Dictionary)props).keys();
            while (pe.hasMoreElements()) {
                String id = (String)pe.nextElement();
                if (id.equals("service.pid") || id.equals("service.description") || id.equals("service.id") || id.equals("service.vendor") || id.equals("service.bundleLocation") || id.equals("service.factoryPid")) continue;
                Object value = ((Dictionary)props).get(id);
                PropertyDescriptor ad = MetaTypeServiceSupport.createAttributeDefinition(id, value);
                json.key(id);
                MetaTypeServiceSupport.attributeToJson(json, ad, value);
            }
            json.endObject();
        }
        if (config != null) {
            this.addConfigurationInfo(config, json, locale);
        }
    }

    void addConfigurationInfo(Configuration config, JSONWriter json, String locale) throws IOException {
        String location;
        String bundleLocation;
        if (config.getFactoryPid() != null) {
            json.key("factoryPid");
            json.value(config.getFactoryPid());
        }
        if ("??unbound:bundle/location".equals(bundleLocation = config.getBundleLocation())) {
            bundleLocation = null;
        }
        if (bundleLocation == null) {
            location = "";
        } else {
            Bundle bundle = MetaTypeServiceSupport.getBundle(this.servletSupport.getBundleContext(), bundleLocation);
            if (bundle == null) {
                location = bundleLocation;
            } else {
                Dictionary headers = bundle.getHeaders(locale);
                String name = (String)headers.get("Bundle-Name");
                location = name == null ? bundle.getSymbolicName() : name + " (" + bundle.getSymbolicName() + ')';
                Version v = Version.parseVersion((String)((String)headers.get("Bundle-Version")));
                location = location + ", Version " + v.toString();
            }
        }
        json.key("bundleLocation");
        json.value(location);
        String pid = config.getPid();
        String serviceLocation = "";
        try {
            ServiceReference[] refs = this.servletSupport.getBundleContext().getServiceReferences((String)null, "(&(objectClass=" + ManagedService.class.getName() + ")(" + "service.pid" + '=' + pid + "))");
            if (refs != null && refs.length > 0) {
                serviceLocation = refs[0].getBundle().getLocation();
            }
        }
        catch (Throwable t) {
            this.servletSupport.log("Error getting service associated with configuration " + pid, t);
        }
        json.key("bundle_location");
        json.value(bundleLocation);
        json.key("service_location");
        json.value(serviceLocation);
    }

    private final Bundle getBoundBundle(Configuration config) {
        if (null == config) {
            return null;
        }
        String location = config.getBundleLocation();
        if (null == location) {
            return null;
        }
        Bundle[] bundles = this.servletSupport.getBundleContext().getBundles();
        for (int i = 0; bundles != null && i < bundles.length; ++i) {
            if (!bundles[i].getLocation().equals(location)) continue;
            return bundles[i];
        }
        return null;
    }

    final boolean listConfigurations(JSONWriter jw, String pidFilter, String locale, Locale loc) {
        boolean hasConfigurations = false;
        try {
            SortedMap<String, String> optionsPlain = this.getServices(ManagedService.class.getName(), pidFilter, locale, true);
            if (this.mtss != null) {
                this.addMetaTypeNames(optionsPlain, this.mtss.getPidObjectClasses(locale), pidFilter, "service.pid");
            }
            Configuration[] cfgs = this.configurationAdmin.listConfigurations(pidFilter);
            for (int i = 0; cfgs != null && i < cfgs.length; ++i) {
                String pid = cfgs[i].getPid();
                if (optionsPlain.containsKey(pid) || !ConfigurationUtil.isAllowedPid(pid)) continue;
                if (this.mtss != null) {
                    try {
                        ObjectClassDefinition ocd = this.mtss.getObjectClassDefinition(cfgs[i], locale);
                        if (ocd != null) {
                            optionsPlain.put(pid, ocd.getName());
                            continue;
                        }
                    }
                    catch (IllegalArgumentException ocd) {
                        // empty catch block
                    }
                }
                optionsPlain.put(pid, pid);
            }
            jw.key("pids");
            jw.array();
            Iterator ii = optionsPlain.keySet().iterator();
            while (ii.hasNext()) {
                hasConfigurations = true;
                String id = (String)ii.next();
                Object name = optionsPlain.get(id);
                Configuration config = ConfigurationUtil.findConfiguration(this.configurationAdmin, id);
                jw.object();
                jw.key("id").value(id);
                jw.key("name").value(name);
                if (null != config) {
                    Bundle bundle;
                    jw.key("has_config").value(true);
                    String fpid = config.getFactoryPid();
                    if (null != fpid) {
                        jw.key("fpid").value(fpid);
                        String val = ConfigJsonSupport.getConfigurationFactoryNameHint(config, this.mtss);
                        if (val != null) {
                            jw.key("nameHint").value(val);
                        }
                    }
                    if (null != (bundle = this.getBoundBundle(config))) {
                        jw.key("bundle").value(bundle.getBundleId());
                        jw.key("bundle_name").value(Util.getName(bundle, loc));
                    }
                }
                jw.endObject();
            }
            jw.endArray();
        }
        catch (Exception e) {
            this.servletSupport.log("listConfigurations: Unexpected problem encountered", e);
        }
        return hasConfigurations;
    }

    private static final String getConfigurationFactoryNameHint(Configuration config, MetaTypeServiceSupport mtss) {
        Map<String, MetatypePropertyDescriptor> adMap;
        Dictionary props = config.getProperties();
        Map<String, MetatypePropertyDescriptor> map = adMap = mtss != null ? mtss.getAttributeDefinitionMap(config, null) : null;
        if (null == adMap) {
            return null;
        }
        String nameHint = ConfigJsonSupport.getConfigurationPropertyValueOrDefault("webconsole.configurationFactory.nameHint", props, adMap);
        if (nameHint == null) {
            return null;
        }
        Matcher matcher = ConfigAdminSupport.NAMEHINT_PLACEHOLER_REGEXP.matcher(nameHint);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String propertyName = matcher.group(1);
            String value = ConfigJsonSupport.getConfigurationPropertyValueOrDefault(propertyName, props, adMap);
            if (value == null) {
                value = "";
            }
            matcher.appendReplacement(sb, ConfigJsonSupport.matcherQuoteReplacement(value));
        }
        matcher.appendTail(sb);
        nameHint = sb.toString().trim();
        if (nameHint.length() == 0) {
            return null;
        }
        return nameHint;
    }

    private static String getConfigurationPropertyValueOrDefault(String propertyName, Dictionary<String, Object> props, Map<String, MetatypePropertyDescriptor> adMap) {
        Object value = props.get(propertyName);
        if (value != null) {
            if (value.getClass().isArray()) {
                StringBuffer valueString = new StringBuffer();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    if (i > 0) {
                        valueString.append(", ");
                    }
                    valueString.append(Array.get(value, i));
                }
                return valueString.toString();
            }
            return value.toString();
        }
        PropertyDescriptor ad = adMap.get(propertyName);
        if (ad != null && ad.getDefaultValue() != null && ad.getDefaultValue().length == 1) {
            return ad.getDefaultValue()[0];
        }
        return null;
    }

    private static String matcherQuoteReplacement(String str) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '$' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    final void listFactoryConfigurations(JSONWriter jw, String pidFilter, String locale) {
        try {
            SortedMap<String, String> optionsFactory = this.getServices(ManagedServiceFactory.class.getName(), pidFilter, locale, true);
            if (this.mtss != null) {
                this.addMetaTypeNames(optionsFactory, this.mtss.getFactoryPidObjectClasses(locale), pidFilter, "service.factoryPid");
            }
            jw.key("fpids");
            jw.array();
            for (String id : optionsFactory.keySet()) {
                Object name = optionsFactory.get(id);
                jw.object();
                jw.key("id").value(id);
                jw.key("name").value(name);
                jw.endObject();
            }
            jw.endArray();
        }
        catch (Exception e) {
            this.servletSupport.log("listFactoryConfigurations: Unexpected problem encountered", e);
        }
    }

    SortedMap<String, String> getServices(String serviceClass, String serviceFilter, String locale, boolean ocdRequired) throws InvalidSyntaxException {
        TreeMap<String, String> optionsFactory = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        ServiceReference[] refs = this.servletSupport.getBundleContext().getServiceReferences(serviceClass, serviceFilter);
        for (int i = 0; refs != null && i < refs.length; ++i) {
            ObjectClassDefinition ocd;
            boolean haveOcd;
            String pid;
            Object pidObject = refs[i].getProperty("service.pid");
            if (!(pidObject instanceof String) || !ConfigurationUtil.isAllowedPid((String)pidObject)) continue;
            String name = pid = (String)pidObject;
            boolean bl = haveOcd = !ocdRequired;
            if (this.mtss != null && (ocd = this.mtss.getObjectClassDefinition(refs[i].getBundle(), pid, locale)) != null) {
                name = ocd.getName();
                haveOcd = true;
            }
            if (!haveOcd) continue;
            optionsFactory.put(pid, name);
        }
        return optionsFactory;
    }

    private void addMetaTypeNames(Map<String, String> pidMap, Map<String, ObjectClassDefinition> ocdCollection, String filterSpec, String type) {
        Filter filter = null;
        if (filterSpec != null) {
            try {
                filter = this.servletSupport.getBundleContext().createFilter(filterSpec);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
        for (Map.Entry<String, ObjectClassDefinition> ociEntry : ocdCollection.entrySet()) {
            String pid = ociEntry.getKey();
            ObjectClassDefinition ocd = ociEntry.getValue();
            if (filter == null) {
                pidMap.put(pid, ocd.getName());
                continue;
            }
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put(type, pid);
            if (!filter.match(props)) continue;
            pidMap.put(pid, ocd.getName());
        }
    }
}

