/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.sslfilter.internal;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Dictionary;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.sslfilter.internal.SslFilterRequest;
import org.apache.felix.http.sslfilter.internal.SslFilterResponse;
import org.apache.felix.http.sslfilter.internal.SystemLogger;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.http.whiteboard.Preprocessor;

public class SslFilter
implements Preprocessor {
    public static final String PID = "org.apache.felix.http.sslfilter.SslFilter";
    private static final String DEFAULT_SSL_HEADER = "X-Forwarded-SSL";
    private static final String DEFAULT_SSL_VALUE = "on";
    private static final String DEFAULT_CERT_HEADER = "X-Forwarded-SSL-Certificate";
    private static final boolean DEFAULT_REWRITE_ABSOLUTE_URLS = false;
    private static final String PROP_SSL_HEADER = "ssl-forward.header";
    private static final String PROP_SSL_VALUE = "ssl-forward.value";
    private static final String PROP_SSL_CERT_KEY = "ssl-forward-cert.header";
    private static final String PROP_REWRITE_ABSOLUTE_URLS = "rewrite.absolute.urls";
    private volatile ConfigHolder config = new ConfigHolder("X-Forwarded-SSL", "on", "X-Forwarded-SSL-Certificate", false);

    SslFilter() {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        ConfigHolder cfg = this.config;
        Object httpReq = (HttpServletRequest)req;
        Object httpResp = (HttpServletResponse)res;
        if (cfg.sslValue.equalsIgnoreCase(httpReq.getHeader(cfg.sslHeader))) {
            try {
                httpResp = new SslFilterResponse((HttpServletResponse)httpResp, (HttpServletRequest)httpReq, cfg);
                httpReq = new SslFilterRequest((HttpServletRequest)httpReq, httpReq.getHeader(cfg.certHeader));
            }
            catch (CertificateException e) {
                SystemLogger.log(2, "Failed to create SSL filter request! Problem parsing client certificates?! Client certificate will *not* be forwarded...", e);
            }
        }
        try {
            chain.doFilter((ServletRequest)httpReq, (ServletResponse)httpResp);
        }
        finally {
            if (httpReq instanceof SslFilterRequest) {
                ((SslFilterRequest)((Object)httpReq)).done();
            }
        }
    }

    public void init(FilterConfig config) {
    }

    void configure(Dictionary properties) throws ConfigurationException {
        String certHeader = DEFAULT_CERT_HEADER;
        String sslHeader = DEFAULT_SSL_HEADER;
        String sslValue = DEFAULT_SSL_VALUE;
        boolean rewriteUrls = false;
        if (properties != null) {
            certHeader = this.getOptionalString(properties, PROP_SSL_CERT_KEY);
            sslHeader = this.getMandatoryString(properties, PROP_SSL_HEADER);
            sslValue = this.getMandatoryString(properties, PROP_SSL_VALUE);
            rewriteUrls = this.getOptionalBoolean(properties, PROP_REWRITE_ABSOLUTE_URLS, rewriteUrls);
        }
        this.config = new ConfigHolder(sslHeader, sslValue, certHeader, rewriteUrls);
        SystemLogger.log(3, "SSL filter (re)configured with: SSL forward header = '" + sslHeader + "'; SSL forward value = '" + sslValue + "'; SSL certificate header = '" + certHeader + "'.");
    }

    private boolean getOptionalBoolean(Dictionary properties, String key, boolean defaultValue) throws ConfigurationException {
        Object raw = properties.get(key);
        if (raw == null) {
            return defaultValue;
        }
        if (raw instanceof Boolean) {
            return (Boolean)raw;
        }
        if (!(raw instanceof String)) {
            throw new ConfigurationException(key, "invalid value");
        }
        return Boolean.valueOf((String)raw);
    }

    private String getOptionalString(Dictionary properties, String key) throws ConfigurationException {
        Object raw = properties.get(key);
        if (raw == null || "".equals(((String)raw).trim())) {
            return null;
        }
        if (!(raw instanceof String)) {
            throw new ConfigurationException(key, "invalid value");
        }
        return ((String)raw).trim();
    }

    private String getMandatoryString(Dictionary properties, String key) throws ConfigurationException {
        String value = this.getOptionalString(properties, key);
        if (value == null) {
            throw new ConfigurationException(key, "missing value");
        }
        return value;
    }

    static class ConfigHolder {
        final String certHeader;
        final String sslHeader;
        final String sslValue;
        final boolean rewriteAbsoluteUrls;

        public ConfigHolder(String sslHeader, String sslValue, String certHeader, boolean rewriteAbsoluteUrls) {
            this.sslHeader = sslHeader;
            this.sslValue = sslValue;
            this.certHeader = certHeader;
            this.rewriteAbsoluteUrls = rewriteAbsoluteUrls;
        }
    }
}

