/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.websocket.api.Configurable;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketContainer;
import org.eclipse.jetty.websocket.api.WebSocketSessionListener;
import org.eclipse.jetty.websocket.common.SessionTracker;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.exception.WebSocketException;
import org.eclipse.jetty.websocket.core.server.FrameHandlerFactory;
import org.eclipse.jetty.websocket.core.server.WebSocketMappings;
import org.eclipse.jetty.websocket.core.server.WebSocketNegotiator;
import org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import org.eclipse.jetty.websocket.server.WebSocketCreator;
import org.eclipse.jetty.websocket.server.internal.ServerFrameHandlerFactory;
import org.eclipse.jetty.websocket.server.internal.ServerUpgradeRequestDelegate;
import org.eclipse.jetty.websocket.server.internal.ServerUpgradeResponseDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerWebSocketContainer
extends ContainerLifeCycle
implements WebSocketContainer,
Configurable,
Invocable,
Request.Handler {
    private static final Logger LOG = LoggerFactory.getLogger(ServerWebSocketContainer.class);
    private final List<WebSocketSessionListener> listeners = new ArrayList<WebSocketSessionListener>();
    private final SessionTracker sessionTracker = new SessionTracker();
    private final Configuration configuration = new Configuration();
    private final WebSocketMappings mappings;
    private final FrameHandlerFactory factory;
    private Invocable.InvocationType invocationType = Invocable.InvocationType.BLOCKING;

    public static ServerWebSocketContainer ensure(Server server, ContextHandler contextHandler) {
        Context context = contextHandler == null ? server.getContext() : contextHandler.getContext();
        ServerWebSocketContainer container = ServerWebSocketContainer.get(context);
        if (container == null) {
            WebSocketComponents components = contextHandler == null ? WebSocketServerComponents.ensureWebSocketComponents(server) : WebSocketServerComponents.ensureWebSocketComponents(server, contextHandler);
            WebSocketMappings mappings = new WebSocketMappings(components);
            container = new ServerWebSocketContainer(mappings);
            container.addBean(mappings);
            context.setAttribute(WebSocketContainer.class.getName(), container);
        }
        return container;
    }

    public static ServerWebSocketContainer ensure(Server server) {
        return ServerWebSocketContainer.ensure(server, null);
    }

    public static ServerWebSocketContainer get(Context context) {
        return (ServerWebSocketContainer)context.getAttribute(WebSocketContainer.class.getName());
    }

    ServerWebSocketContainer(WebSocketMappings mappings) {
        this.mappings = mappings;
        this.factory = new ServerFrameHandlerFactory(this, mappings.getWebSocketComponents());
        this.addSessionListener(this.sessionTracker);
        this.installBean(this.sessionTracker);
    }

    @Override
    public Executor getExecutor() {
        return this.mappings.getWebSocketComponents().getExecutor();
    }

    @Override
    public Collection<Session> getOpenSessions() {
        return this.sessionTracker.getSessions();
    }

    @Override
    public void addSessionListener(WebSocketSessionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeSessionListener(WebSocketSessionListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void notifySessionListeners(Consumer<WebSocketSessionListener> consumer) {
        for (WebSocketSessionListener listener : this.listeners) {
            try {
                consumer.accept(listener);
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Failure while invoking listener {}", (Object)listener, (Object)x);
            }
        }
    }

    @Override
    public Duration getIdleTimeout() {
        return this.configuration.getIdleTimeout();
    }

    @Override
    public void setIdleTimeout(Duration duration) {
        this.configuration.setIdleTimeout(duration);
    }

    @Override
    public int getInputBufferSize() {
        return this.configuration.getInputBufferSize();
    }

    @Override
    public void setInputBufferSize(int size) {
        this.configuration.setInputBufferSize(size);
    }

    @Override
    public int getOutputBufferSize() {
        return this.configuration.getOutputBufferSize();
    }

    @Override
    public void setOutputBufferSize(int size) {
        this.configuration.setOutputBufferSize(size);
    }

    @Override
    public long getMaxBinaryMessageSize() {
        return this.configuration.getMaxBinaryMessageSize();
    }

    @Override
    public void setMaxBinaryMessageSize(long size) {
        this.configuration.setMaxBinaryMessageSize(size);
    }

    @Override
    public long getMaxTextMessageSize() {
        return this.configuration.getMaxTextMessageSize();
    }

    @Override
    public void setMaxTextMessageSize(long size) {
        this.configuration.setMaxTextMessageSize(size);
    }

    @Override
    public long getMaxFrameSize() {
        return this.configuration.getMaxFrameSize();
    }

    @Override
    public void setMaxFrameSize(long maxFrameSize) {
        this.configuration.setMaxFrameSize(maxFrameSize);
    }

    @Override
    public boolean isAutoFragment() {
        return this.configuration.isAutoFragment();
    }

    @Override
    public void setAutoFragment(boolean autoFragment) {
        this.configuration.setAutoFragment(autoFragment);
    }

    @Override
    public int getMaxOutgoingFrames() {
        return this.configuration.getMaxOutgoingFrames();
    }

    @Override
    public void setMaxOutgoingFrames(int maxOutgoingFrames) {
        this.configuration.setMaxOutgoingFrames(maxOutgoingFrames);
    }

    public void addMapping(String pathSpec, WebSocketCreator creator) {
        this.addMapping(WebSocketMappings.parsePathSpec(pathSpec), creator);
    }

    public void addMapping(PathSpec pathSpec, WebSocketCreator creator) {
        if (this.mappings.getWebSocketNegotiator(pathSpec) != null) {
            throw new WebSocketException("Duplicate WebSocket Mapping for PathSpec " + String.valueOf(pathSpec));
        }
        org.eclipse.jetty.websocket.core.server.WebSocketCreator coreCreator = this.newWebSocketCreator(creator);
        this.mappings.addMapping(pathSpec, coreCreator, this.factory, this.configuration);
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws WebSocketException {
        return this.mappings.upgrade(request, response, callback, this.configuration);
    }

    public boolean upgrade(WebSocketCreator creator, Request request, Response response, Callback callback) throws WebSocketException {
        org.eclipse.jetty.websocket.core.server.WebSocketCreator coreCreator = this.newWebSocketCreator(creator);
        WebSocketNegotiator negotiator = WebSocketNegotiator.from(coreCreator, this.factory);
        return this.mappings.upgrade(negotiator, request, response, callback, this.configuration);
    }

    private org.eclipse.jetty.websocket.core.server.WebSocketCreator newWebSocketCreator(WebSocketCreator creator) {
        return (rq, rs, cb) -> {
            try {
                Object webSocket = creator.createWebSocket(new ServerUpgradeRequestDelegate(rq), new ServerUpgradeResponseDelegate(rq, rs), cb);
                if (webSocket == null) {
                    cb.succeeded();
                }
                return webSocket;
            }
            catch (Throwable x) {
                cb.failed(x);
                return null;
            }
        };
    }

    @Override
    public Invocable.InvocationType getInvocationType() {
        return this.invocationType;
    }

    public void setInvocationType(Invocable.InvocationType invocationType) {
        this.invocationType = invocationType;
    }

    private static class Configuration
    extends Configuration.ConfigurationCustomizer
    implements Configurable {
        private Configuration() {
        }
    }
}

