/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.javaxwrappers;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletMapping;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.PushBuilder;
import org.apache.felix.http.jakartawrappers.ServletResponseWrapper;
import org.apache.felix.http.javaxwrappers.CookieWrapper;
import org.apache.felix.http.javaxwrappers.HttpServletMappingWrapper;
import org.apache.felix.http.javaxwrappers.HttpSessionWrapper;
import org.apache.felix.http.javaxwrappers.PartWrapper;
import org.apache.felix.http.javaxwrappers.PushBuilderWrapper;
import org.apache.felix.http.javaxwrappers.ServletExceptionUtil;
import org.apache.felix.http.javaxwrappers.ServletRequestWrapper;
import org.jetbrains.annotations.NotNull;

public class HttpServletRequestWrapper
extends ServletRequestWrapper
implements javax.servlet.http.HttpServletRequest {
    private final HttpServletRequest request;

    public HttpServletRequestWrapper(@NotNull HttpServletRequest r) {
        super((ServletRequest)r);
        this.request = r;
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public Cookie[] getCookies() {
        return CookieWrapper.wrap(this.request.getCookies());
    }

    public long getDateHeader(String name) {
        return this.request.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this.request.getIntHeader(name);
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public String getPathTranslated() {
        return this.request.getPathTranslated();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.request.getRequestURL();
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public HttpSession getSession(boolean create) {
        jakarta.servlet.http.HttpSession session = this.request.getSession(create);
        if (session != null) {
            return new HttpSessionWrapper(session);
        }
        return null;
    }

    public HttpSession getSession() {
        return new HttpSessionWrapper(this.request.getSession());
    }

    public String changeSessionId() {
        return this.request.changeSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        try {
            return this.request.authenticate((jakarta.servlet.http.HttpServletResponse)ServletResponseWrapper.getWrapper((ServletResponse)response));
        }
        catch (jakarta.servlet.ServletException e) {
            throw ServletExceptionUtil.getServletException(e);
        }
    }

    public void login(String username, String password) throws ServletException {
        try {
            this.request.login(username, password);
        }
        catch (jakarta.servlet.ServletException e) {
            throw ServletExceptionUtil.getServletException(e);
        }
    }

    public void logout() throws ServletException {
        try {
            this.request.logout();
        }
        catch (jakarta.servlet.ServletException e) {
            throw ServletExceptionUtil.getServletException(e);
        }
    }

    public Collection<javax.servlet.http.Part> getParts() throws IOException, ServletException {
        try {
            ArrayList<javax.servlet.http.Part> result = new ArrayList<javax.servlet.http.Part>();
            for (Part p : this.request.getParts()) {
                result.add(new PartWrapper(p));
            }
            return result;
        }
        catch (jakarta.servlet.ServletException e) {
            throw ServletExceptionUtil.getServletException(e);
        }
    }

    public javax.servlet.http.Part getPart(String name) throws IOException, ServletException {
        try {
            return new PartWrapper(this.request.getPart(name));
        }
        catch (jakarta.servlet.ServletException e) {
            throw ServletExceptionUtil.getServletException(e);
        }
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public HttpServletMapping getHttpServletMapping() {
        return new HttpServletMappingWrapper(this.request.getHttpServletMapping());
    }

    public PushBuilder newPushBuilder() {
        jakarta.servlet.http.PushBuilder builder = this.request.newPushBuilder();
        if (builder != null) {
            return new PushBuilderWrapper(builder);
        }
        return null;
    }

    public Map<String, String> getTrailerFields() {
        return this.request.getTrailerFields();
    }

    public boolean isTrailerFieldsReady() {
        return this.request.isTrailerFieldsReady();
    }
}

