/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import java.io.Closeable;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.http.base.internal.AbstractHttpActivator;
import org.apache.felix.http.jetty.LoadBalancerCustomizerFactory;
import org.apache.felix.http.jetty.internal.ConfigMetaTypeProvider;
import org.apache.felix.http.jetty.internal.ForwardedRequestCustomizerFactory;
import org.apache.felix.http.jetty.internal.JettyManagedServiceFactory;
import org.apache.felix.http.jetty.internal.JettyService;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public final class JettyActivator
extends AbstractHttpActivator {
    private JettyService jetty;
    private volatile ServiceRegistration<?> metatypeReg;
    private volatile ServiceRegistration<LoadBalancerCustomizerFactory> loadBalancerCustomizerFactoryReg;
    private volatile ServiceRegistration<?> jettyServiceFactoryReg;
    private volatile Closeable managedServiceFactory;

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.description", "Metatype provider for Jetty Http Service");
        ((Dictionary)properties).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)properties).put("metatype.pid", "org.apache.felix.http");
        this.metatypeReg = this.getBundleContext().registerService("org.osgi.service.metatype.MetaTypeProvider", (Object)new ServiceFactory(){

            public Object getService(Bundle bundle, ServiceRegistration registration) {
                return new ConfigMetaTypeProvider(JettyActivator.this.getBundleContext().getBundle());
            }

            public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            }
        }, properties);
        this.jetty = new JettyService(this.getBundleContext(), this.getHttpServiceController());
        this.jetty.start();
        Hashtable<String, String> propertiesCustomizer = new Hashtable<String, String>();
        ((Dictionary)propertiesCustomizer).put("service.description", "Load Balancer Customizer Factory for Jetty Http Service");
        ((Dictionary)propertiesCustomizer).put("service.vendor", "The Apache Software Foundation");
        this.loadBalancerCustomizerFactoryReg = this.getBundleContext().registerService(LoadBalancerCustomizerFactory.class, (ServiceFactory)new ServiceFactory<LoadBalancerCustomizerFactory>(){

            public LoadBalancerCustomizerFactory getService(Bundle bundle, ServiceRegistration<LoadBalancerCustomizerFactory> registration) {
                return new ForwardedRequestCustomizerFactory();
            }

            public void ungetService(Bundle bundle, ServiceRegistration<LoadBalancerCustomizerFactory> registration, LoadBalancerCustomizerFactory service) {
            }
        }, propertiesCustomizer);
        Hashtable<String, String> factoryProps = new Hashtable<String, String>();
        ((Dictionary)factoryProps).put("service.pid", "org.apache.felix.http");
        ((Dictionary)factoryProps).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)factoryProps).put("service.description", "Managed Service Factory for the Jetty Http Service");
        this.jettyServiceFactoryReg = this.getBundleContext().registerService("org.osgi.service.cm.ManagedServiceFactory", (Object)new ServiceFactory(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getService(Bundle bundle, ServiceRegistration registration) {
                JettyService jettyService = JettyActivator.this.jetty;
                synchronized (jettyService) {
                    if (JettyActivator.this.managedServiceFactory == null) {
                        JettyActivator.this.managedServiceFactory = new JettyManagedServiceFactory(JettyActivator.this.getBundleContext());
                    }
                }
                return JettyActivator.this.managedServiceFactory;
            }

            public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            }
        }, factoryProps);
    }

    @Override
    protected void doStop() throws Exception {
        if (this.managedServiceFactory != null) {
            this.managedServiceFactory.close();
        }
        this.jetty.stop();
        if (this.metatypeReg != null) {
            this.metatypeReg.unregister();
            this.metatypeReg = null;
        }
        if (this.loadBalancerCustomizerFactoryReg != null) {
            this.loadBalancerCustomizerFactoryReg.unregister();
            this.loadBalancerCustomizerFactoryReg = null;
        }
        if (this.jettyServiceFactoryReg != null) {
            this.jettyServiceFactoryReg.unregister();
            this.jettyServiceFactoryReg = null;
        }
        super.doStop();
    }
}

