/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.ajax;

import java.util.Map;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.ajax.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONEnumConvertor
implements JSON.Convertor {
    private static final Logger LOG = LoggerFactory.getLogger(JSONEnumConvertor.class);
    private boolean _fromJSON;

    public JSONEnumConvertor() {
        this(false);
    }

    public JSONEnumConvertor(boolean fromJSON) {
        this._fromJSON = fromJSON;
    }

    @Override
    public Object fromJSON(Map<String, Object> map) {
        if (!this._fromJSON) {
            throw new UnsupportedOperationException();
        }
        String clazzname = (String)map.get("class");
        try {
            Class type = Loader.loadClass(clazzname);
            return Enum.valueOf(type, (String)map.get("value"));
        }
        catch (Exception e) {
            LOG.warn("Unable to load class: {}", (Object)clazzname, (Object)e);
            return null;
        }
    }

    @Override
    public void toJSON(Object obj, JSON.Output out) {
        if (this._fromJSON) {
            out.addClass(obj.getClass());
            out.add("value", ((Enum)obj).name());
        } else {
            out.add(((Enum)obj).name());
        }
    }
}

