/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.felix.http.base.internal.HttpServiceController;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.jetty.internal.ConnectorFactoryTracker;
import org.apache.felix.http.jetty.internal.CustomizerWrapper;
import org.apache.felix.http.jetty.internal.FileRequestLog;
import org.apache.felix.http.jetty.internal.JettyConfig;
import org.apache.felix.http.jetty.internal.JettyManagedService;
import org.apache.felix.http.jetty.internal.LoadBalancerCustomizerFactoryTracker;
import org.apache.felix.http.jetty.internal.LogServiceRequestLog;
import org.apache.felix.http.jetty.internal.MBeanServerTracker;
import org.apache.felix.http.jetty.internal.RequestLogTracker;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.ee10.websocket.jakarta.server.config.JakartaWebSocketServletContainerInitializer;
import org.eclipse.jetty.ee10.websocket.server.JettyWebSocketServerContainer;
import org.eclipse.jetty.ee10.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.io.ConnectionStatistics;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.VirtualThreadPool;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public final class JettyService {
    public static final String PID = "org.apache.felix.http";
    private final JettyConfig config;
    private final BundleContext context;
    private final HttpServiceController controller;
    private volatile ServiceRegistration<?> configServiceReg;
    private volatile Server server;
    private volatile ContextHandlerCollection parent;
    private volatile MBeanServerTracker mbeanServerTracker;
    private volatile ConnectorFactoryTracker connectorTracker;
    private volatile RequestLogTracker requestLogTracker;
    private volatile LogServiceRequestLog osgiRequestLog;
    private volatile FileRequestLog fileRequestLog;
    private volatile LoadBalancerCustomizerFactoryTracker loadBalancerCustomizerTracker;
    private volatile CustomizerWrapper customizerWrapper;
    private final boolean registerManagedService;
    private final String jettyVersion;
    private final boolean immediatelyStartJetty;

    private JettyService(BundleContext context, HttpServiceController controller, boolean registerManagedService) {
        this.jettyVersion = JettyService.fixJettyVersion(context);
        this.context = context;
        this.config = new JettyConfig(this.context);
        this.controller = controller;
        this.registerManagedService = registerManagedService;
        this.immediatelyStartJetty = !registerManagedService || !this.config.isRequireConfiguration();
    }

    public JettyService(BundleContext context, HttpServiceController controller) {
        this(context, controller, true);
    }

    public JettyService(BundleContext context, HttpServiceController controller, Dictionary<String, ?> props) {
        this(context, controller, false);
        this.config.update(props);
    }

    public void start() throws Exception {
        if (this.immediatelyStartJetty) {
            this.startJetty();
        }
        if (this.registerManagedService) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("service.pid", PID);
            ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
            ((Dictionary)props).put("service.description", "Managed Service for the Jetty Http Service");
            this.configServiceReg = this.context.registerService("org.osgi.service.cm.ManagedService", (Object)new ServiceFactory(){

                public Object getService(Bundle bundle, ServiceRegistration registration) {
                    return new JettyManagedService(JettyService.this);
                }

                public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
                }
            }, props);
        }
    }

    public void stop() throws Exception {
        if (this.configServiceReg != null) {
            try {
                this.configServiceReg.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.configServiceReg = null;
        }
        this.stopJetty();
    }

    private Hashtable<String, Object> getServiceProperties() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        this.config.setServiceProperties(props);
        this.addEndpointProperties(props, null);
        return props;
    }

    public void updated(Dictionary<String, ?> props) {
        boolean changed = this.config.update(props);
        if (props == null && !this.immediatelyStartJetty) {
            this.stopJetty();
        } else if (changed) {
            this.stopJetty();
            this.startJetty();
        }
    }

    private void startJetty() {
        try {
            this.initializeJetty();
        }
        catch (Exception e) {
            SystemLogger.LOGGER.error("Exception while initializing Jetty", (Throwable)e);
        }
    }

    private void stopJetty() {
        if (this.server != null) {
            this.controller.getEventDispatcher().setActive(false);
            this.controller.unregister();
            if (this.fileRequestLog != null) {
                this.fileRequestLog.stop();
                this.fileRequestLog = null;
            }
            if (this.osgiRequestLog != null) {
                this.osgiRequestLog.unregister();
                this.osgiRequestLog = null;
            }
            if (this.requestLogTracker != null) {
                this.requestLogTracker.close();
                this.requestLogTracker = null;
            }
            if (this.connectorTracker != null) {
                this.connectorTracker.close();
                this.connectorTracker = null;
            }
            if (this.loadBalancerCustomizerTracker != null) {
                this.loadBalancerCustomizerTracker.close();
                this.loadBalancerCustomizerTracker = null;
            }
            try {
                this.server.stop();
                this.server = null;
                SystemLogger.LOGGER.info("Stopped Jetty");
            }
            catch (Exception e) {
                SystemLogger.LOGGER.error("Exception while stopping Jetty", (Throwable)e);
            }
            if (this.mbeanServerTracker != null) {
                this.mbeanServerTracker.close();
                this.mbeanServerTracker = null;
            }
        }
    }

    private void initializeJetty() throws Exception {
        if (this.config.isUseHttp() || this.config.isUseHttps()) {
            int threadPoolMax = this.config.getThreadPoolMax();
            if (!this.config.isUseVirtualThreads() && threadPoolMax >= 0) {
                this.server = new Server(new QueuedThreadPool(threadPoolMax));
            } else if (this.config.isUseVirtualThreads()) {
                Method newVirtualThreadPerTaskExecutorMethod = null;
                try {
                    newVirtualThreadPerTaskExecutorMethod = Executors.class.getMethod("newVirtualThreadPerTaskExecutor", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("Virtual threads are only available in Java 21 or later, or via preview flags in Java 19-20");
                }
                if (threadPoolMax >= 0) {
                    threadPool = new VirtualThreadPool();
                    ((VirtualThreadPool)threadPool).setMaxThreads(threadPoolMax);
                    this.server = new Server((ThreadPool)((Object)threadPool));
                } else {
                    threadPool = new QueuedThreadPool();
                    Executor virtualExecutor = (Executor)newVirtualThreadPerTaskExecutorMethod.invoke(null, new Object[0]);
                    ((QueuedThreadPool)threadPool).setVirtualThreadsExecutor(virtualExecutor);
                    this.server = new Server((ThreadPool)((Object)threadPool));
                }
            } else {
                this.server = new Server();
            }
            HashLoginService loginService = new HashLoginService("OSGi HTTP Service Realm");
            loginService.setUserStore(new UserStore());
            this.server.addBean(loginService);
            ServletContextHandler context = new ServletContextHandler(this.config.getContextPath(), 1);
            this.parent = new ContextHandlerCollection(context);
            this.configureSessionManager(context);
            this.controller.getEventDispatcher().setActive(true);
            context.addEventListener((EventListener)((Object)this.controller.getEventDispatcher()));
            context.getSessionHandler().addEventListener((EventListener)((Object)this.controller.getEventDispatcher()));
            ServletHolder holder = new ServletHolder(this.controller.createDispatcherServlet());
            holder.setAsyncSupported(true);
            context.addServlet(holder, "/*");
            context.setMaxFormContentSize(this.config.getMaxFormSize());
            if (this.config.isRegisterMBeans()) {
                this.mbeanServerTracker = new MBeanServerTracker(this.context, this.server);
                this.mbeanServerTracker.open();
                if (!this.config.isStatisticsHandlerEnabled()) {
                    context.addBean(new StatisticsHandler());
                }
            }
            this.server.setHandler(this.parent);
            if (this.config.isStatisticsHandlerEnabled()) {
                StatisticsHandler statisticsHandler = new StatisticsHandler();
                this.server.insertHandler(statisticsHandler);
                if (this.config.isRegisterMBeans()) {
                    context.addBean(statisticsHandler);
                }
            }
            if (this.config.isGzipHandlerEnabled()) {
                GzipHandler gzipHandler = new GzipHandler();
                gzipHandler.setMinGzipSize(this.config.getGzipMinGzipSize());
                gzipHandler.setInflateBufferSize(this.config.getGzipInflateBufferSize());
                gzipHandler.setSyncFlush(this.config.isGzipSyncFlush());
                gzipHandler.addIncludedMethods(this.config.getGzipIncludedMethods());
                gzipHandler.addExcludedMethods(this.config.getGzipExcludedMethods());
                gzipHandler.addIncludedPaths(this.config.getGzipIncludedPaths());
                gzipHandler.addExcludedPaths(this.config.getGzipExcludedPaths());
                gzipHandler.addIncludedMimeTypes(this.config.getGzipIncludedMimeTypes());
                gzipHandler.addExcludedMimeTypes(this.config.getGzipExcludedMimeTypes());
                this.server.insertHandler(gzipHandler);
            }
            if (this.config.getStopTimeout() != -1L) {
                this.server.setStopTimeout(this.config.getStopTimeout());
            }
            if (this.config.isUseJettyWebsocket()) {
                this.maybeInitializeJettyWebsocket(context);
            }
            if (this.config.isUseJakartaWebsocket()) {
                this.maybeInitializeJakartaWebsocket(context);
            }
            this.server.start();
            this.maybeStoreWebSocketContainerAttributes(context);
            context.getSessionHandler().getSessionIdManager().getSessionHouseKeeper().setIntervalSec(this.config.getLongProperty("org.eclipse.jetty.servlet.SessionScavengingInterval", 600L));
            if (this.config.isProxyLoadBalancerConnection()) {
                this.customizerWrapper = new CustomizerWrapper();
                this.loadBalancerCustomizerTracker = new LoadBalancerCustomizerFactoryTracker(this.context, this.customizerWrapper);
                this.loadBalancerCustomizerTracker.open();
            }
            StringBuilder message = new StringBuilder("Started Jetty ").append(this.jettyVersion).append(" at port(s)");
            if (this.config.isUseHttp() && this.initializeHttp()) {
                message.append(" HTTP:").append(this.config.getHttpPort());
            }
            if (this.config.isUseHttps() && this.initializeHttps()) {
                message.append(" HTTPS:").append(this.config.getHttpsPort());
            }
            this.connectorTracker = new ConnectorFactoryTracker(this.context, this.server);
            this.connectorTracker.open();
            if (this.server.getConnectors() != null && this.server.getConnectors().length > 0) {
                message.append(" on context path ").append(this.config.getContextPath());
                message.append(" [");
                ThreadPool threadPool = this.server.getThreadPool();
                if (threadPool instanceof ThreadPool.SizedThreadPool) {
                    sizedThreadPool = (ThreadPool.SizedThreadPool)threadPool;
                    message.append("minThreads=").append(sizedThreadPool.getMinThreads()).append(",");
                    message.append("maxThreads=").append(sizedThreadPool.getMaxThreads()).append(",");
                } else if (threadPool instanceof VirtualThreadPool) {
                    sizedThreadPool = (VirtualThreadPool)threadPool;
                    message.append("maxVirtualThreads=").append(((VirtualThreadPool)sizedThreadPool).getMaxThreads()).append(",");
                }
                Connector connector = this.server.getConnectors()[0];
                if (connector instanceof ServerConnector) {
                    ServerConnector serverConnector = (ServerConnector)connector;
                    message.append("acceptors=").append(serverConnector.getAcceptors()).append(",");
                    message.append("selectors=").append(serverConnector.getSelectorManager().getSelectorCount());
                }
                message.append(",").append("virtualThreadsEnabled=").append(this.config.isUseVirtualThreads());
                message.append("]");
                SystemLogger.LOGGER.info(message.toString());
                this.controller.register(context.getServletContext(), this.getServiceProperties());
            } else {
                this.stopJetty();
                SystemLogger.LOGGER.error("Jetty stopped (no connectors available)");
            }
            try {
                this.requestLogTracker = new RequestLogTracker(this.context, this.config.getRequestLogFilter());
                this.requestLogTracker.open();
                this.server.setRequestLog(this.requestLogTracker);
            }
            catch (InvalidSyntaxException e) {
                SystemLogger.LOGGER.error("Invalid filter syntax in request log tracker", (Throwable)e);
            }
            if (this.config.isRequestLogOSGiEnabled()) {
                this.osgiRequestLog = new LogServiceRequestLog(this.config);
                this.osgiRequestLog.register(this.context);
                SystemLogger.LOGGER.info("Directing Jetty request logs to the OSGi Log Service");
            }
            if (this.config.getRequestLogFilePath() != null && !this.config.getRequestLogFilePath().isEmpty()) {
                this.fileRequestLog = new FileRequestLog(this.config);
                this.fileRequestLog.start(this.context);
                SystemLogger.LOGGER.info("Directing Jetty request logs to {}", (Object)this.config.getRequestLogFilePath());
            }
        } else {
            SystemLogger.LOGGER.warn("Jetty not started (HTTP and HTTPS disabled)");
        }
    }

    private static String fixJettyVersion(BundleContext ctx) {
        Dictionary headers = ctx.getBundle().getHeaders();
        String version = (String)headers.get("X-Jetty-Version");
        if (version != null) {
            System.setProperty("jetty.version", version);
        } else {
            version = Server.getVersion();
        }
        return version;
    }

    private boolean initializeHttp() {
        HttpConnectionFactory connFactory = new HttpConnectionFactory();
        this.configureHttpConnectionFactory(connFactory);
        ServerConnector connector = new ServerConnector(this.server, this.config.getAcceptors(), this.config.getSelectors(), connFactory);
        this.configureConnector(connector, this.config.getHttpPort());
        if (this.config.isProxyLoadBalancerConnection()) {
            connFactory.getHttpConfiguration().addCustomizer(this.customizerWrapper);
        }
        return this.startConnector(connector);
    }

    private boolean initializeHttps() {
        HttpConnectionFactory connFactory = new HttpConnectionFactory();
        this.configureHttpConnectionFactory(connFactory);
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        this.configureSslContextFactory(sslContextFactory);
        ServerConnector connector = new ServerConnector(this.server, this.config.getAcceptors(), this.config.getSelectors(), new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.toString()), connFactory);
        HttpConfiguration httpConfiguration = connFactory.getHttpConfiguration();
        httpConfiguration.addCustomizer(new SecureRequestCustomizer());
        if (this.config.isProxyLoadBalancerConnection()) {
            httpConfiguration.addCustomizer(this.customizerWrapper);
        }
        if (this.config.isUseHttp2()) {
            SslConnectionFactory alpnConnFactory = new SslConnectionFactory(sslContextFactory, "alpn");
            connector.addConnectionFactory(alpnConnFactory);
            ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(this.config.getAlpnProtocols());
            alpn.setDefaultProtocol(this.config.getAlpnDefaultProtocol());
            connector.addConnectionFactory(alpn);
            HTTP2ServerConnectionFactory http2factory = new HTTP2ServerConnectionFactory(httpConfiguration);
            http2factory.setMaxConcurrentStreams(this.config.getHttp2MaxConcurrentStreams());
            http2factory.setInitialStreamRecvWindow(this.config.getHttp2InitialStreamRecvWindow());
            http2factory.setInitialSessionRecvWindow(this.config.getHttp2InitialSessionRecvWindow());
            connector.addConnectionFactory(http2factory);
            sslContextFactory.setCipherComparator(HTTP2Cipher.COMPARATOR);
            sslContextFactory.setUseCipherSuitesOrder(true);
        }
        this.configureConnector(connector, this.config.getHttpsPort());
        return this.startConnector(connector);
    }

    private void maybeInitializeJakartaWebsocket(ServletContextHandler handler) {
        if (this.isClassNameVisible("org.eclipse.jetty.ee10.websocket.jakarta.server.config.JakartaWebSocketServletContainerInitializer")) {
            JakartaWebSocketServletContainerInitializer.configure((ServletContextHandler)handler, null);
            SystemLogger.LOGGER.info("Jakarta WebSocket EE10 servlet container initialized");
        } else {
            SystemLogger.LOGGER.warn("Failed to initialize jakarta EE10 standard websocket support since the initializer class was not found. Check if the jetty-ee10-websocket-jakarta-server bundle is deployed.");
        }
    }

    private void maybeInitializeJettyWebsocket(ServletContextHandler handler) {
        if (this.isClassNameVisible("org.eclipse.jetty.ee10.websocket.server.config.JettyWebSocketServletContainerInitializer")) {
            JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)handler, null);
            SystemLogger.LOGGER.info("Jetty WebSocket EE10 servlet container initialized");
        } else {
            SystemLogger.LOGGER.warn("Failed to initialize jetty EE10 specific websocket support since the initializer class was not found. Check if the jetty-ee10-websocket-jetty-server bundle is deployed.");
        }
    }

    private void maybeStoreWebSocketContainerAttributes(ServletContextHandler context) {
        String attribute;
        if (this.config.isUseJettyWebsocket() && this.isClassNameVisible("org.eclipse.jetty.ee10.websocket.server.config.JettyWebSocketServletContainerInitializer")) {
            attribute = JettyWebSocketServerContainer.JETTY_WEBSOCKET_CONTAINER_ATTRIBUTE;
            this.controller.setAttributeSharedServletContext(attribute, context.getServletContext().getAttribute(attribute));
        }
        if (this.config.isUseJakartaWebsocket() && this.isClassNameVisible("org.eclipse.jetty.ee10.websocket.jakarta.server.config.JakartaWebSocketServletContainerInitializer")) {
            attribute = JakartaWebSocketServletContainerInitializer.ATTR_JAKARTA_SERVER_CONTAINER;
            this.controller.setAttributeSharedServletContext(attribute, context.getServletContext().getAttribute(attribute));
        }
    }

    private boolean isClassNameVisible(String className) {
        boolean visible;
        try {
            this.getClass().getClassLoader().loadClass(className);
            visible = true;
        }
        catch (ClassNotFoundException e) {
            visible = false;
        }
        return visible;
    }

    private void configureSslContextFactory(SslContextFactory.Server connector) {
        if (this.config.getKeystoreType() != null) {
            connector.setKeyStoreType(this.config.getKeystoreType());
        }
        if (this.config.getKeystore() != null) {
            connector.setKeyStorePath(this.config.getKeystore());
        }
        if (this.config.getPassword() != null) {
            connector.setKeyStorePassword(this.config.getPassword());
        }
        if (this.config.getKeyPassword() != null) {
            connector.setKeyManagerPassword(this.config.getKeyPassword());
        }
        if (this.config.getTruststoreType() != null) {
            connector.setTrustStoreType(this.config.getTruststoreType());
        }
        if (this.config.getTruststore() != null) {
            connector.setTrustStorePath(this.config.getTruststore());
        }
        if (this.config.getTrustPassword() != null) {
            connector.setTrustStorePassword(this.config.getTrustPassword());
        }
        if ("wants".equalsIgnoreCase(this.config.getClientcert())) {
            connector.setWantClientAuth(true);
        } else if ("needs".equalsIgnoreCase(this.config.getClientcert())) {
            connector.setNeedClientAuth(true);
        }
        if (this.config.getExcludedCipherSuites() != null) {
            connector.setExcludeCipherSuites(this.config.getExcludedCipherSuites());
        }
        if (this.config.getIncludedCipherSuites() != null) {
            connector.setIncludeCipherSuites(this.config.getIncludedCipherSuites());
        }
        if (this.config.getIncludedProtocols() != null) {
            connector.setIncludeProtocols(this.config.getIncludedProtocols());
        }
        if (this.config.getExcludedProtocols() != null) {
            connector.setExcludeProtocols(this.config.getExcludedProtocols());
        }
        connector.setRenegotiationAllowed(this.config.isRenegotiationAllowed());
    }

    private void configureConnector(ServerConnector connector, int port) {
        connector.setPort(port);
        connector.setHost(this.config.getHost());
        connector.setIdleTimeout(this.config.getHttpTimeout());
        if (this.config.isRegisterMBeans()) {
            connector.addBean(new ConnectionStatistics());
        }
    }

    private void configureHttpConnectionFactory(HttpConnectionFactory connFactory) {
        HttpConfiguration config = connFactory.getHttpConfiguration();
        config.setRequestHeaderSize(this.config.getHeaderSize());
        config.setResponseHeaderSize(this.config.getHeaderSize());
        config.setOutputBufferSize(this.config.getResponseBufferSize());
        String uriComplianceMode = this.config.getProperty("org.eclipse.jetty.UriComplianceMode", null);
        if (uriComplianceMode != null) {
            try {
                UriCompliance compliance = UriCompliance.valueOf(uriComplianceMode);
                config.setUriCompliance(compliance);
                if (UriCompliance.LEGACY.equals(compliance) || UriCompliance.UNSAFE.equals(compliance) || UriCompliance.UNAMBIGUOUS.equals(compliance)) {
                    this.server.getContainedBeans(ServletHandler.class).forEach(handler -> handler.setDecodeAmbiguousURIs(true));
                }
            }
            catch (IllegalArgumentException e) {
                SystemLogger.LOGGER.warn("Invalid URI compliance mode: {}", (Object)uriComplianceMode);
            }
        }
        config.setSendDateHeader(true);
        config.setSendServerVersion(this.config.isSendServerHeader());
        config.setSendXPoweredBy(this.config.isSendServerHeader());
        connFactory.setInputBufferSize(this.config.getRequestBufferSize());
    }

    private void configureSessionManager(ServletContextHandler context) throws Exception {
        SessionHandler sessionHandler = context.getSessionHandler();
        sessionHandler.setMaxInactiveInterval(this.config.getSessionTimeout() * 60);
        sessionHandler.setSessionIdPathParameterName(this.config.getProperty("org.eclipse.jetty.servlet.SessionIdPathParameterName", "jsessionid"));
        sessionHandler.setCheckingRemoteSessionIdEncoding(this.config.getBooleanProperty("org.eclipse.jetty.servlet.CheckingRemoteSessionIdEncoding", true));
        sessionHandler.setSessionTrackingModes(Collections.singleton(SessionTrackingMode.COOKIE));
        SessionCookieConfig cookieConfig = sessionHandler.getSessionCookieConfig();
        cookieConfig.setName(this.config.getProperty("org.eclipse.jetty.servlet.SessionCookie", "JSESSIONID"));
        cookieConfig.setDomain(this.config.getProperty("org.eclipse.jetty.servlet.SessionDomain", SessionHandler.__DefaultSessionDomain));
        cookieConfig.setPath(this.config.getProperty("org.eclipse.jetty.servlet.SessionPath", context.getContextPath()));
        cookieConfig.setMaxAge(this.config.getIntProperty("org.eclipse.jetty.servlet.MaxAge", -1));
        cookieConfig.setHttpOnly(this.config.getBooleanProperty("org.apache.felix.https.jetty.session.cookie.httpOnly", true));
        cookieConfig.setSecure(this.config.getBooleanProperty("org.apache.felix.https.jetty.session.cookie.secure", false));
    }

    private boolean startConnector(Connector connector) {
        this.server.addConnector(connector);
        try {
            connector.start();
            return true;
        }
        catch (Exception e) {
            this.server.removeConnector(connector);
            SystemLogger.LOGGER.error("Failed to start Connector: {}", (Object)connector, (Object)e);
            return false;
        }
    }

    private String getEndpoint(Connector listener, InetAddress ia) {
        if (ia.isLoopbackAddress()) {
            return null;
        }
        Object address = ia.getHostAddress().trim().toLowerCase();
        if (ia instanceof Inet6Address) {
            if (((String)address).startsWith("fe80:0:0:0:")) {
                return null;
            }
            address = "[" + (String)address + "]";
        } else if (!(ia instanceof Inet4Address)) {
            return null;
        }
        return this.getEndpoint(listener, (String)address);
    }

    private ServerConnector getServerConnector(Connector connector) {
        if (connector instanceof ServerConnector) {
            return (ServerConnector)connector;
        }
        throw new IllegalArgumentException("Connection instance not of type ServerConnector " + String.valueOf(connector));
    }

    private String getEndpoint(Connector listener, String hostname) {
        StringBuilder sb = new StringBuilder();
        sb.append("http");
        int defaultPort = 80;
        if (this.getServerConnector(listener).getDefaultProtocol().startsWith("SSL")) {
            sb.append('s');
            defaultPort = 443;
        }
        sb.append("://");
        sb.append(hostname);
        if (this.getServerConnector(listener).getPort() != defaultPort) {
            sb.append(':');
            sb.append(String.valueOf(this.getServerConnector(listener).getPort()));
        }
        sb.append(this.config.getContextPath());
        return sb.toString();
    }

    private List<String> getEndpoints(Connector connector, List<NetworkInterface> interfaces) {
        ArrayList<String> endpoints = new ArrayList<String>();
        for (NetworkInterface ni : interfaces) {
            Enumeration<InetAddress> ias = ni.getInetAddresses();
            while (ias.hasMoreElements()) {
                InetAddress ia = ias.nextElement();
                String endpoint = this.getEndpoint(connector, ia);
                if (endpoint == null) continue;
                endpoints.add(endpoint);
            }
        }
        return endpoints;
    }

    private void addEndpointProperties(Hashtable<String, Object> props, Object container) {
        ArrayList<String> endpoints = new ArrayList<String>();
        Connector[] connectors = this.server.getConnectors();
        if (connectors != null) {
            for (int i = 0; i < connectors.length; ++i) {
                Connector connector = connectors[i];
                if (this.getServerConnector(connector).getHost() == null || "0.0.0.0".equals(this.getServerConnector(connector).getHost())) {
                    try {
                        ArrayList<NetworkInterface> interfaces = new ArrayList<NetworkInterface>();
                        ArrayList<NetworkInterface> loopBackInterfaces = new ArrayList<NetworkInterface>();
                        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                        while (nis.hasMoreElements()) {
                            NetworkInterface ni = nis.nextElement();
                            if (ni.isLoopback()) {
                                loopBackInterfaces.add(ni);
                                continue;
                            }
                            interfaces.add(ni);
                        }
                        if (!interfaces.isEmpty()) {
                            endpoints.addAll(this.getEndpoints(connector, interfaces));
                            continue;
                        }
                        endpoints.addAll(this.getEndpoints(connector, loopBackInterfaces));
                    }
                    catch (SocketException interfaces) {}
                    continue;
                }
                String endpoint = this.getEndpoint(connector, this.getServerConnector(connector).getHost());
                if (endpoint == null) continue;
                endpoints.add(endpoint);
            }
        }
        props.put("osgi.http.endpoint", endpoints.toArray(new String[endpoints.size()]));
    }
}

