/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.jetty.http.CookieCache;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Components;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.FormFields;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.server.TunnelSupport;
import org.eclipse.jetty.server.internal.CompletionStreamWrapper;
import org.eclipse.jetty.server.internal.HttpChannelState;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Request
extends Attributes,
Content.Source {
    public static final Logger LOG = LoggerFactory.getLogger(Request.class);
    public static final String CACHE_ATTRIBUTE = Request.class.getCanonicalName() + ".CookieCache";
    public static final String COOKIE_ATTRIBUTE = Request.class.getCanonicalName() + ".Cookies";
    public static final List<Locale> DEFAULT_LOCALES = List.of(Locale.getDefault());

    public String getId();

    public Components getComponents();

    public ConnectionMetaData getConnectionMetaData();

    public String getMethod();

    public HttpURI getHttpURI();

    public Context getContext();

    public static String getContextPath(Request request) {
        return request.getContext().getContextPath();
    }

    public static String getPathInContext(Request request) {
        return request.getContext().getPathInContext(request.getHttpURI().getCanonicalPath());
    }

    public HttpFields getHeaders();

    @Override
    public void demand(Runnable var1);

    public HttpFields getTrailers();

    public static long getTimeStamp(Request request) {
        return System.currentTimeMillis() - NanoTime.millisSince(request.getHeadersNanoTime());
    }

    public long getBeginNanoTime();

    public long getHeadersNanoTime();

    public boolean isSecure();

    @Override
    public Content.Chunk read();

    public boolean consumeAvailable();

    default public void push(MetaData.Request resource) {
        throw new UnsupportedOperationException();
    }

    public void addIdleTimeoutListener(Predicate<TimeoutException> var1);

    public void addFailureListener(Consumer<Throwable> var1);

    public TunnelSupport getTunnelSupport();

    public void addHttpStreamWrapper(Function<HttpStream, HttpStream> var1);

    public static void addCompletionListener(Request request, Consumer<Throwable> listener) {
        request.addHttpStreamWrapper(stream -> {
            if (stream instanceof CompletionStreamWrapper) {
                CompletionStreamWrapper completionStreamWrapper = (CompletionStreamWrapper)stream;
                return completionStreamWrapper.addListener(listener);
            }
            return new CompletionStreamWrapper((HttpStream)stream, listener);
        });
    }

    public Session getSession(boolean var1);

    public static Request asReadOnly(Request request) {
        return new Wrapper(request){

            @Override
            public void addHttpStreamWrapper(Function<HttpStream, HttpStream> wrapper) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Content.Chunk read() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void demand(Runnable demandCallback) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void fail(Throwable failure) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static String getHostName(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress.isUnresolved()) {
            return inetSocketAddress.getHostString();
        }
        InetAddress address = inetSocketAddress.getAddress();
        String result = address == null ? inetSocketAddress.getHostString() : address.getHostAddress();
        return HostPort.normalizeHost(result);
    }

    public static String getLocalAddr(Request request) {
        if (request == null) {
            return null;
        }
        SocketAddress local = request.getConnectionMetaData().getLocalSocketAddress();
        if (local instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)local;
            return Request.getHostName(inetSocketAddress);
        }
        return local == null ? null : local.toString();
    }

    public static int getLocalPort(Request request) {
        if (request == null) {
            return -1;
        }
        SocketAddress local = request.getConnectionMetaData().getLocalSocketAddress();
        if (local instanceof InetSocketAddress) {
            return ((InetSocketAddress)local).getPort();
        }
        return -1;
    }

    public static String getRemoteAddr(Request request) {
        if (request == null) {
            return null;
        }
        SocketAddress remote = request.getConnectionMetaData().getRemoteSocketAddress();
        if (remote instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)remote;
            return Request.getHostName(inetSocketAddress);
        }
        return remote == null ? null : remote.toString();
    }

    public static int getRemotePort(Request request) {
        if (request == null) {
            return -1;
        }
        SocketAddress remote = request.getConnectionMetaData().getRemoteSocketAddress();
        if (remote instanceof InetSocketAddress) {
            return ((InetSocketAddress)remote).getPort();
        }
        return -1;
    }

    public static String getServerName(Request request) {
        if (request == null) {
            return null;
        }
        HttpURI uri = request.getHttpURI();
        if (uri.hasAuthority()) {
            return HostPort.normalizeHost(uri.getHost());
        }
        HostPort authority = request.getConnectionMetaData().getServerAuthority();
        if (authority != null) {
            return authority.getHost();
        }
        return null;
    }

    public static int getServerPort(Request request) {
        InetSocketAddress inetSocketAddress;
        if (request == null) {
            return -1;
        }
        HttpURI uri = request.getHttpURI();
        if (uri.hasAuthority() && uri.getPort() > 0) {
            return uri.getPort();
        }
        HostPort authority = request.getConnectionMetaData().getHttpConfiguration().getServerAuthority();
        if (authority != null && authority.getPort() > 0) {
            return authority.getPort();
        }
        HttpScheme scheme = HttpScheme.CACHE.get(request.getHttpURI().getScheme());
        if (scheme != null && scheme.getDefaultPort() > 0) {
            return scheme.getDefaultPort();
        }
        SocketAddress local = request.getConnectionMetaData().getLocalSocketAddress();
        if (local instanceof InetSocketAddress && (inetSocketAddress = (InetSocketAddress)local).getPort() > 0) {
            return inetSocketAddress.getPort();
        }
        return -1;
    }

    public static List<Locale> getLocales(Request request) {
        HttpFields fields = request.getHeaders();
        if (fields == null) {
            return DEFAULT_LOCALES;
        }
        List<String> acceptable = fields.getQualityCSV(HttpHeader.ACCEPT_LANGUAGE);
        return switch (acceptable.size()) {
            case 0 -> DEFAULT_LOCALES;
            case 1 -> List.of(Locale.forLanguageTag(acceptable.get(0)));
            default -> {
                List<Locale> locales = acceptable.stream().map(Locale::forLanguageTag).toList();
                List<Locale> known = locales.stream().filter(MimeTypes::isKnownLocale).toList();
                if (known.size() == locales.size()) {
                    yield locales;
                }
                List<Locale> unknown = locales.stream().filter(l -> !MimeTypes.isKnownLocale(l)).toList();
                locales = new ArrayList<Locale>(known);
                locales.addAll(unknown);
                yield locales;
            }
        };
    }

    public static InputStream asInputStream(Request request) {
        return Content.Source.asInputStream(request);
    }

    public static Charset getCharset(Request request) throws IllegalCharsetNameException, UnsupportedCharsetException {
        String contentType = request.getHeaders().get(HttpHeader.CONTENT_TYPE);
        return Objects.requireNonNullElse(request.getContext().getMimeTypes(), MimeTypes.DEFAULTS).getCharset(contentType);
    }

    public static Fields extractQueryParameters(Request request) {
        String query = request.getHttpURI().getQuery();
        if (StringUtil.isBlank(query)) {
            return Fields.EMPTY;
        }
        Fields fields = new Fields(true);
        if (StringUtil.isNotBlank(query)) {
            UrlEncoded.decodeUtf8To(query, fields);
        }
        return fields;
    }

    public static Fields extractQueryParameters(Request request, Charset charset) {
        Fields fields = new Fields(true);
        String query = request.getHttpURI().getQuery();
        if (StringUtil.isNotBlank(query)) {
            UrlEncoded.decodeTo(query, fields::add, charset);
        }
        return fields;
    }

    public static Fields getParameters(Request request) throws Exception {
        return Request.getParametersAsync(request).get();
    }

    public static CompletableFuture<Fields> getParametersAsync(Request request) {
        Fields queryFields = Request.extractQueryParameters(request);
        CompletableFuture<Fields> contentFields = FormFields.from(request);
        return contentFields.thenApply(formFields -> Fields.combine(queryFields, formFields));
    }

    public static List<HttpCookie> getCookies(Request request) {
        List<HttpCookie> cookies = (List<HttpCookie>)request.getAttribute(COOKIE_ATTRIBUTE);
        if (cookies != null) {
            return cookies;
        }
        CookieCache cookieCache = (CookieCache)request.getComponents().getCache().getAttribute(CACHE_ATTRIBUTE);
        if (cookieCache == null) {
            cookieCache = new CookieCache(request.getConnectionMetaData().getHttpConfiguration().getRequestCookieCompliance(), null);
            request.getComponents().getCache().setAttribute(CACHE_ATTRIBUTE, cookieCache);
        }
        cookies = cookieCache.getCookies(request.getHeaders());
        request.setAttribute(COOKIE_ATTRIBUTE, cookies);
        return cookies;
    }

    @Deprecated
    public static String toRedirectURI(Request request, String location) {
        return Response.toRedirectURI(request, location);
    }

    public static Request serveAs(Request request, final HttpURI uri) {
        if (request.getHttpURI().equals(uri)) {
            return request;
        }
        ServeAs serveAs = Request.as(request, ServeAs.class);
        if (serveAs != null) {
            return serveAs.wrap(request, uri);
        }
        return new Wrapper(request){

            @Override
            public HttpURI getHttpURI() {
                return uri;
            }
        };
    }

    public static <T> T as(Request request, Class<T> type) {
        while (request != null) {
            Request request2;
            if (type.isInstance(request)) {
                return (T)request;
            }
            if (request instanceof Wrapper) {
                Wrapper wrapper = (Wrapper)request;
                request2 = wrapper.getWrapped();
            } else {
                request2 = null;
            }
            request = request2;
        }
        return null;
    }

    public static <T, R> R get(Request request, Class<T> type, Function<T, R> getter) {
        T t = Request.as(request, type);
        return t == null ? null : (R)getter.apply(t);
    }

    public static Request unWrap(Request request) {
        while (request instanceof Wrapper) {
            Wrapper wrapped = (Wrapper)request;
            request = wrapped.getWrapped();
        }
        return request;
    }

    public static long getContentBytesRead(Request request) {
        Request originalRequest = Request.unWrap(request);
        if (originalRequest instanceof HttpChannelState.ChannelRequest) {
            HttpChannelState.ChannelRequest channelRequest = (HttpChannelState.ChannelRequest)originalRequest;
            return channelRequest.getContentBytesRead();
        }
        return -1L;
    }

    public static HttpURI newHttpURIFrom(Request request, String newEncodedPathInContext) {
        return HttpURI.build(request.getHttpURI()).path(URIUtil.addPaths(Request.getContextPath(request), newEncodedPathInContext)).asImmutable();
    }

    public static AuthenticationState getAuthenticationState(Request request) {
        Object object = request.getAttribute(AuthenticationState.class.getName());
        if (object instanceof AuthenticationState) {
            AuthenticationState authenticationState = (AuthenticationState)object;
            return authenticationState;
        }
        return null;
    }

    public static void setAuthenticationState(Request request, AuthenticationState state) {
        request.setAttribute(AuthenticationState.class.getName(), state);
    }

    public static interface ServeAs
    extends Request {
        public Request wrap(Request var1, HttpURI var2);
    }

    public static class Wrapper
    implements Request,
    Attributes {
        private final Request _request;

        public Wrapper(Request wrapped) {
            this._request = Objects.requireNonNull(wrapped);
        }

        @Override
        public String getId() {
            return this.getWrapped().getId();
        }

        @Override
        public Components getComponents() {
            return this.getWrapped().getComponents();
        }

        @Override
        public ConnectionMetaData getConnectionMetaData() {
            return this.getWrapped().getConnectionMetaData();
        }

        @Override
        public String getMethod() {
            return this.getWrapped().getMethod();
        }

        @Override
        public HttpURI getHttpURI() {
            return this.getWrapped().getHttpURI();
        }

        @Override
        public Context getContext() {
            return this.getWrapped().getContext();
        }

        @Override
        public HttpFields getHeaders() {
            return this.getWrapped().getHeaders();
        }

        @Override
        public HttpFields getTrailers() {
            return this.getWrapped().getTrailers();
        }

        @Override
        public long getBeginNanoTime() {
            return this.getWrapped().getBeginNanoTime();
        }

        @Override
        public long getHeadersNanoTime() {
            return this.getWrapped().getHeadersNanoTime();
        }

        @Override
        public boolean isSecure() {
            return this.getWrapped().isSecure();
        }

        @Override
        public long getLength() {
            return this.getWrapped().getLength();
        }

        @Override
        public Content.Chunk read() {
            return this.getWrapped().read();
        }

        @Override
        public boolean consumeAvailable() {
            return this.getWrapped().consumeAvailable();
        }

        @Override
        public void demand(Runnable demandCallback) {
            this.getWrapped().demand(demandCallback);
        }

        @Override
        public void fail(Throwable failure) {
            this.getWrapped().fail(failure);
        }

        @Override
        public void push(MetaData.Request resource) {
            this.getWrapped().push(resource);
        }

        @Override
        public void addIdleTimeoutListener(Predicate<TimeoutException> onIdleTimeout) {
            this.getWrapped().addIdleTimeoutListener(onIdleTimeout);
        }

        @Override
        public void addFailureListener(Consumer<Throwable> onFailure) {
            this.getWrapped().addFailureListener(onFailure);
        }

        @Override
        public TunnelSupport getTunnelSupport() {
            return this.getWrapped().getTunnelSupport();
        }

        @Override
        public void addHttpStreamWrapper(Function<HttpStream, HttpStream> wrapper) {
            this.getWrapped().addHttpStreamWrapper(wrapper);
        }

        @Override
        public Session getSession(boolean create) {
            return this.getWrapped().getSession(create);
        }

        @Override
        public Object removeAttribute(String name) {
            return this.getWrapped().removeAttribute(name);
        }

        @Override
        public Object setAttribute(String name, Object attribute) {
            return this.getWrapped().setAttribute(name, attribute);
        }

        @Override
        public Object getAttribute(String name) {
            return this.getWrapped().getAttribute(name);
        }

        @Override
        public Set<String> getAttributeNameSet() {
            return this.getWrapped().getAttributeNameSet();
        }

        @Override
        public Map<String, Object> asAttributeMap() {
            return this.getWrapped().asAttributeMap();
        }

        @Override
        public void clearAttributes() {
            this.getWrapped().clearAttributes();
        }

        public Request getWrapped() {
            return this._request;
        }
    }

    public static interface AuthenticationState {
        default public Principal getUserPrincipal() {
            return null;
        }
    }

    public static class AttributesWrapper
    extends Wrapper {
        private final Attributes _attributes;

        public AttributesWrapper(Request wrapped, Attributes attributes) {
            super(wrapped);
            this._attributes = Objects.requireNonNull(attributes);
        }

        @Override
        public Map<String, Object> asAttributeMap() {
            return this._attributes.asAttributeMap();
        }

        @Override
        public void clearAttributes() {
            this._attributes.clearAttributes();
        }

        @Override
        public Object removeAttribute(String name) {
            return this._attributes.removeAttribute(name);
        }

        @Override
        public Object setAttribute(String name, Object attribute) {
            return this._attributes.setAttribute(name, attribute);
        }

        @Override
        public Object getAttribute(String name) {
            return this._attributes.getAttribute(name);
        }

        @Override
        public Set<String> getAttributeNameSet() {
            return this._attributes.getAttributeNameSet();
        }
    }

    @ManagedObject
    @FunctionalInterface
    public static interface Handler
    extends Invocable {
        public boolean handle(Request var1, Response var2, Callback var3) throws Exception;

        @Override
        @ManagedAttribute(value="The InvocationType of this Handler")
        default public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.BLOCKING;
        }
    }
}

