/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.security.AuthenticationState;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.Constraint;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.security.authentication.SessionAuthentication;
import org.eclipse.jetty.server.FormFields;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(FormAuthenticator.class);
    public static final String __FORM_LOGIN_PAGE = "org.eclipse.jetty.security.form_login_page";
    public static final String __FORM_ERROR_PAGE = "org.eclipse.jetty.security.form_error_page";
    public static final String __FORM_DISPATCH = "org.eclipse.jetty.security.dispatch";
    public static final String __J_URI = "org.eclipse.jetty.security.form_URI";
    public static final String __J_POST = "org.eclipse.jetty.security.form_POST";
    public static final String __J_METHOD = "org.eclipse.jetty.security.form_METHOD";
    public static final String __J_SECURITY_CHECK = "/j_security_check";
    public static final String __J_USERNAME = "j_username";
    public static final String __J_PASSWORD = "j_password";
    private String _formErrorPage;
    private String _formErrorPath;
    private String _formLoginPage;
    private String _formLoginPath;
    private boolean _dispatch;
    private boolean _alwaysSaveUri;

    public FormAuthenticator() {
    }

    public FormAuthenticator(String login, String error, boolean dispatch) {
        this();
        if (login != null) {
            this.setLoginPage(login);
        }
        if (error != null) {
            this.setErrorPage(error);
        }
        this._dispatch = dispatch;
    }

    public void setAlwaysSaveUri(boolean alwaysSave) {
        this._alwaysSaveUri = alwaysSave;
    }

    public boolean getAlwaysSaveUri() {
        return this._alwaysSaveUri;
    }

    @Override
    public void setConfiguration(Authenticator.Configuration configuration) {
        String dispatch;
        String error;
        super.setConfiguration(configuration);
        String login = configuration.getParameter(__FORM_LOGIN_PAGE);
        if (login != null) {
            this.setLoginPage(login);
        }
        if ((error = configuration.getParameter(__FORM_ERROR_PAGE)) != null) {
            this.setErrorPage(error);
        }
        this._dispatch = (dispatch = configuration.getParameter(__FORM_DISPATCH)) == null ? this._dispatch : Boolean.parseBoolean(dispatch);
    }

    @Override
    public String getAuthenticationType() {
        return "FORM";
    }

    private void setLoginPage(String path) {
        if (!((String)path).startsWith("/")) {
            LOG.warn("form-login-page must start with /");
            path = "/" + (String)path;
        }
        this._formLoginPage = path;
        this._formLoginPath = path;
        if (this._formLoginPath.indexOf(63) > 0) {
            this._formLoginPath = this._formLoginPath.substring(0, this._formLoginPath.indexOf(63));
        }
    }

    private void setErrorPage(String path) {
        if (path == null || ((String)path).trim().length() == 0) {
            this._formErrorPath = null;
            this._formErrorPage = null;
        } else {
            if (!((String)path).startsWith("/")) {
                LOG.warn("form-error-page must start with /");
                path = "/" + (String)path;
            }
            this._formErrorPage = path;
            this._formErrorPath = path;
            if (this._formErrorPath.indexOf(63) > 0) {
                this._formErrorPath = this._formErrorPath.substring(0, this._formErrorPath.indexOf(63));
            }
        }
    }

    @Override
    public UserIdentity login(String username, Object password, Request request, Response response) {
        UserIdentity user = super.login(username, password, request, response);
        if (user != null) {
            Session session = request.getSession(true);
            SessionAuthentication cached = new SessionAuthentication(this.getAuthenticationType(), user, password);
            session.setAttribute("org.eclipse.jetty.security.UserIdentity", cached);
        }
        return user;
    }

    @Override
    public void logout(Request request, Response response) {
        super.logout(request, response);
        Session session = request.getSession(false);
        if (session == null) {
            return;
        }
        session.removeAttribute("org.eclipse.jetty.security.UserIdentity");
    }

    @Override
    public Request prepareRequest(Request request, AuthenticationState authenticationState) {
        if (authenticationState instanceof AuthenticationState.Succeeded) {
            Session session = request.getSession(false);
            HttpURI juri = (HttpURI)session.getAttribute(__J_URI);
            HttpURI uri = request.getHttpURI();
            if (uri.equals(juri)) {
                String method;
                session.removeAttribute(__J_URI);
                Object post = session.removeAttribute(__J_POST);
                if (post instanceof CompletableFuture) {
                    CompletableFuture futureFields = (CompletableFuture)post;
                    FormFields.set(request, futureFields);
                }
                if ((method = (String)session.removeAttribute(__J_METHOD)) != null && request.getMethod().equals(method)) {
                    return new Request.Wrapper(request){

                        @Override
                        public String getMethod() {
                            return method;
                        }
                    };
                }
            }
        }
        return request;
    }

    protected Fields getParameters(Request request) {
        try {
            Fields queryFields = Request.extractQueryParameters(request);
            Fields formFields = FormFields.from(request).get();
            return Fields.combine(queryFields, formFields);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    protected String encodeURL(String url, Request request) {
        Session session = request.getSession(false);
        if (session == null) {
            return url;
        }
        return session.encodeURI(request, url, request.getHeaders().contains(HttpHeader.COOKIE));
    }

    @Override
    public Constraint.Authorization getConstraintAuthentication(String pathInContext, Constraint.Authorization existing, Function<Boolean, Session> getSession) {
        if (this.isJSecurityCheck(pathInContext)) {
            return Constraint.Authorization.ANY_USER;
        }
        if (this.isLoginOrErrorPage(pathInContext)) {
            return Constraint.Authorization.ALLOWED;
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthenticationState validateRequest(Request request, Response response, Callback callback) throws ServerAuthException {
        AuthenticationState authenticationState;
        String pathInContext = Request.getPathInContext(request);
        boolean jSecurityCheck = this.isJSecurityCheck(pathInContext);
        if (jSecurityCheck) {
            Fields parameters = this.getParameters(request);
            String username = parameters.getValue(__J_USERNAME);
            String password = parameters.getValue(__J_PASSWORD);
            UserIdentity user = this.login(username, password, request, response);
            if (LOG.isDebugEnabled()) {
                LOG.debug("jsecuritycheck {} {}", (Object)username, (Object)user);
            }
            if (user != null) {
                String originalURI;
                Session session = request.getSession(false);
                HttpURI savedURI = (HttpURI)session.getAttribute(__J_URI);
                String string = originalURI = savedURI != null ? savedURI.asString() : Request.getContextPath(request);
                if (originalURI == null) {
                    originalURI = "/";
                }
                LoginAuthenticator.UserAuthenticationSent formAuth = new LoginAuthenticator.UserAuthenticationSent(this.getAuthenticationType(), user);
                Response.sendRedirect(request, response, callback, this.encodeURL(originalURI, request), true);
                return formAuth;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("auth failed {}=={}", (Object)username, (Object)this._formErrorPage);
            }
            return this.sendError(request, response, callback);
        }
        Session session = request.getSession(false);
        AuthenticationState authenticationState2 = authenticationState = session == null ? null : (AuthenticationState)session.getAttribute("org.eclipse.jetty.security.UserIdentity");
        if (LOG.isDebugEnabled()) {
            LOG.debug("auth {}", (Object)authenticationState);
        }
        if (authenticationState instanceof AuthenticationState.Succeeded) {
            AuthenticationState.Succeeded succeeded = (AuthenticationState.Succeeded)authenticationState;
            if (this._loginService != null && !this._loginService.validate(succeeded.getUserIdentity())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("auth revoked {}", (Object)authenticationState);
                }
                session.removeAttribute("org.eclipse.jetty.security.UserIdentity");
                authenticationState = null;
            }
        }
        if (authenticationState != null) {
            return authenticationState;
        }
        if (response.isCommitted()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("auth deferred {}", (Object)(session == null ? null : session.getId()));
            }
            return null;
        }
        Session session2 = session = session != null ? session : request.getSession(true);
        synchronized (session2) {
            if (session.getAttribute(__J_URI) == null || this._alwaysSaveUri) {
                HttpURI juri = request.getHttpURI();
                session.setAttribute(__J_URI, juri.asImmutable());
                if (!HttpMethod.GET.is(request.getMethod())) {
                    session.setAttribute(__J_METHOD, request.getMethod());
                }
                if (HttpMethod.POST.is(request.getMethod())) {
                    try {
                        CompletableFuture<Fields> futureFields = FormFields.from(request);
                        futureFields.get();
                        session.setAttribute(__J_POST, futureFields);
                    }
                    catch (ExecutionException e) {
                        throw new ServerAuthException(e.getCause());
                    }
                    catch (InterruptedException e) {
                        throw new ServerAuthException(e);
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("challenge {}->{}", (Object)session.getId(), (Object)this._formLoginPage);
        }
        return this.sendChallenge(request, response, callback);
    }

    private AuthenticationState dispatch(String path, Request request, Response response, Callback callback) {
        try {
            String newPath = URIUtil.addPaths(request.getContext().getContextPath(), path);
            HttpURI.Mutable newUri = HttpURI.build(request.getHttpURI()).pathQuery(newPath);
            return new AuthenticationState.ServeAs(newUri);
        }
        catch (Throwable t) {
            Response.writeError(request, response, callback, t);
            return AuthenticationState.SEND_FAILURE;
        }
    }

    private AuthenticationState sendError(Request request, Response response, Callback callback) {
        if (this._formErrorPage == null) {
            Response.writeError(request, response, callback, 403);
        } else {
            if (this._dispatch) {
                return this.dispatch(this._formErrorPage, request, response, callback);
            }
            Response.sendRedirect(request, response, callback, this.encodeURL(URIUtil.addPaths(request.getContext().getContextPath(), this._formErrorPage), request), true);
        }
        return AuthenticationState.SEND_FAILURE;
    }

    private AuthenticationState sendChallenge(Request request, Response response, Callback callback) {
        if (this._dispatch) {
            return this.dispatch(this._formLoginPage, request, response, callback);
        }
        Response.sendRedirect(request, response, callback, this.encodeURL(URIUtil.addPaths(request.getContext().getContextPath(), this._formLoginPage), request), true);
        return AuthenticationState.SEND_FAILURE;
    }

    public boolean isJSecurityCheck(String uri) {
        int jsc = uri.indexOf(__J_SECURITY_CHECK);
        if (jsc < 0) {
            return false;
        }
        int e = jsc + __J_SECURITY_CHECK.length();
        if (e == uri.length()) {
            return true;
        }
        char c = uri.charAt(e);
        return c == ';' || c == '#' || c == '/' || c == '?';
    }

    public boolean isLoginOrErrorPage(String pathInContext) {
        return pathInContext != null && (pathInContext.equals(this._formErrorPath) || pathInContext.equals(this._formLoginPath));
    }
}

