/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.runtime;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.felix.http.base.internal.jakartawrappers.FilterWrapper;
import org.apache.felix.http.base.internal.runtime.AbstractInfo;
import org.apache.felix.http.base.internal.runtime.WhiteboardServiceInfo;
import org.apache.felix.http.base.internal.util.PatternUtil;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.ServiceReference;

public class FilterInfo
extends WhiteboardServiceInfo<Filter> {
    private final String name;
    private final String[] patterns;
    private final String[] servletNames;
    private final String[] regexs;
    private final boolean asyncSupported;
    private final DispatcherType[] dispatcher;
    private final Map<String, String> initParams;

    public FilterInfo(ServiceReference<Filter> ref) {
        super(ref);
        this.name = this.getStringProperty(ref, "osgi.http.whiteboard.filter.name");
        this.asyncSupported = this.getBooleanProperty(ref, "osgi.http.whiteboard.filter.asyncSupported");
        this.servletNames = this.getStringArrayProperty(ref, "osgi.http.whiteboard.filter.servlet");
        this.patterns = this.getStringArrayProperty(ref, "osgi.http.whiteboard.filter.pattern");
        this.regexs = this.getStringArrayProperty(ref, "osgi.http.whiteboard.filter.regex");
        this.initParams = this.getInitParams(ref, "filter.init.");
        String[] dispatcherNames = this.getStringArrayProperty(ref, "osgi.http.whiteboard.filter.dispatcher");
        if (dispatcherNames != null && dispatcherNames.length > 0) {
            DispatcherType[] dispatchers = new DispatcherType[dispatcherNames.length];
            for (int i = 0; i < dispatchers.length; ++i) {
                try {
                    dispatchers[i] = DispatcherType.valueOf((String)dispatcherNames[i].toUpperCase());
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    dispatchers = null;
                    break;
                }
            }
            this.dispatcher = dispatchers;
        } else {
            this.dispatcher = new DispatcherType[]{DispatcherType.REQUEST};
        }
    }

    @Override
    public boolean isValid() {
        boolean valid;
        boolean bl = valid = super.isValid() && (!this.isEmpty(this.patterns) || !this.isEmpty(this.regexs) || !this.isEmpty(this.servletNames));
        if (valid) {
            if (this.patterns != null) {
                for (String p : this.patterns) {
                    if (PatternUtil.isValidPattern(p)) continue;
                    valid = false;
                    break;
                }
            }
            if (valid && this.regexs != null) {
                for (String p : this.regexs) {
                    try {
                        Pattern.compile(p);
                    }
                    catch (PatternSyntaxException pse) {
                        valid = false;
                        break;
                    }
                }
            }
        }
        if (valid && (this.dispatcher == null || this.dispatcher.length == 0)) {
            valid = false;
        }
        return valid;
    }

    public String getName() {
        return this.name;
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public String[] getServletNames() {
        return this.servletNames;
    }

    public String[] getRegexs() {
        return this.regexs;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public DispatcherType[] getDispatcher() {
        return this.dispatcher;
    }

    public Map<String, String> getInitParameters() {
        return this.initParams;
    }

    @Override
    @NotNull
    public String getType() {
        return "Filter";
    }

    @NotNull
    public String getClassName(@NotNull Filter filter) {
        if (filter instanceof FilterWrapper) {
            return ((FilterWrapper)filter).getFilter().getClass().getName();
        }
        return filter.getClass().getName();
    }

    @Override
    public boolean isSame(AbstractInfo<Filter> other) {
        if (!super.isSame(other)) {
            return false;
        }
        FilterInfo o = (FilterInfo)other;
        return Objects.equals(this.name, o.name) && Arrays.equals(this.patterns, o.patterns) && Arrays.equals(this.servletNames, o.servletNames) && Arrays.equals(this.regexs, o.regexs) && this.asyncSupported == o.asyncSupported && Arrays.equals(this.dispatcher, o.dispatcher) && Objects.equals(this.initParams, o.initParams);
    }
}

