/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jakartawrappers;

import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.PushBuilder;
import org.apache.felix.http.jakartawrappers.CookieWrapper;
import org.apache.felix.http.jakartawrappers.HttpServletMappingWrapper;
import org.apache.felix.http.jakartawrappers.HttpSessionWrapper;
import org.apache.felix.http.jakartawrappers.PartWrapper;
import org.apache.felix.http.jakartawrappers.PushBuilderWrapper;
import org.apache.felix.http.jakartawrappers.ServletExceptionUtil;
import org.apache.felix.http.jakartawrappers.ServletRequestWrapper;
import org.apache.felix.http.javaxwrappers.ServletResponseWrapper;
import org.jetbrains.annotations.NotNull;

public class HttpServletRequestWrapper
extends ServletRequestWrapper
implements HttpServletRequest {
    private final javax.servlet.http.HttpServletRequest request;

    public HttpServletRequestWrapper(@NotNull javax.servlet.http.HttpServletRequest r) {
        super((ServletRequest)r);
        this.request = r;
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public Cookie[] getCookies() {
        return CookieWrapper.wrap(this.request.getCookies());
    }

    public long getDateHeader(String name) {
        return this.request.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this.request.getIntHeader(name);
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public String getPathTranslated() {
        return this.request.getPathTranslated();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.request.getRequestURL();
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public jakarta.servlet.http.HttpSession getSession(boolean create) {
        HttpSession session = this.request.getSession(create);
        if (session != null) {
            return new HttpSessionWrapper(session);
        }
        return null;
    }

    public jakarta.servlet.http.HttpSession getSession() {
        return new HttpSessionWrapper(this.request.getSession());
    }

    public String changeSessionId() {
        return this.request.changeSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.request.isRequestedSessionIdFromUrl();
    }

    public boolean authenticate(jakarta.servlet.http.HttpServletResponse response) throws IOException, jakarta.servlet.ServletException {
        try {
            return this.request.authenticate((HttpServletResponse)ServletResponseWrapper.getWrapper((ServletResponse)response));
        }
        catch (ServletException e) {
            throw ServletExceptionUtil.getServletException(e);
        }
    }

    public void login(String username, String password) throws jakarta.servlet.ServletException {
        try {
            this.request.login(username, password);
        }
        catch (ServletException e) {
            throw ServletExceptionUtil.getServletException(e);
        }
    }

    public void logout() throws jakarta.servlet.ServletException {
        try {
            this.request.logout();
        }
        catch (ServletException e) {
            throw ServletExceptionUtil.getServletException(e);
        }
    }

    public Collection<Part> getParts() throws IOException, jakarta.servlet.ServletException {
        try {
            ArrayList<Part> result = new ArrayList<Part>();
            for (javax.servlet.http.Part p : this.request.getParts()) {
                result.add(new PartWrapper(p));
            }
            return result;
        }
        catch (ServletException e) {
            throw ServletExceptionUtil.getServletException(e);
        }
    }

    public Part getPart(String name) throws IOException, jakarta.servlet.ServletException {
        try {
            return new PartWrapper(this.request.getPart(name));
        }
        catch (ServletException e) {
            throw ServletExceptionUtil.getServletException(e);
        }
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, jakarta.servlet.ServletException {
        throw new UnsupportedOperationException();
    }

    public HttpServletMapping getHttpServletMapping() {
        return new HttpServletMappingWrapper(this.request.getHttpServletMapping());
    }

    public jakarta.servlet.http.PushBuilder newPushBuilder() {
        PushBuilder builder = this.request.newPushBuilder();
        if (builder != null) {
            return new PushBuilderWrapper(builder);
        }
        return null;
    }

    public Map<String, String> getTrailerFields() {
        return this.request.getTrailerFields();
    }

    public boolean isTrailerFieldsReady() {
        return this.request.isTrailerFieldsReady();
    }
}

