/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.generalchecks;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.felix.hc.annotation.HealthCheckService;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.felix.hc.generalchecks.scrutil.DsRootCauseAnalyzer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true)
@HealthCheckService(name="Services Ready Check", tags={"systemalive"})
@Designate(ocd=Config.class, factory=true)
public class ServicesCheck
implements HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(ServicesCheck.class);
    public static final String HC_NAME = "Services Ready Check";
    public static final String HC_DEFAULT_TAG = "systemalive";
    private List<String> servicesList;
    private Result.Status statusForMissing;
    private Map<String, Tracker> trackers;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private DsRootCauseAnalyzer analyzer;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ServiceComponentRuntime scr;

    @Activate
    public void activate(BundleContext ctx, Config config) throws InterruptedException {
        this.servicesList = Arrays.asList(config.services_list());
        this.trackers = this.servicesList.stream().collect(Collectors.toMap(Function.identity(), serviceName -> new Tracker(ctx, (String)serviceName)));
        this.statusForMissing = config.statusForMissing();
        LOG.debug("Activated Services HC for servicesList={}", this.servicesList);
    }

    @Deactivate
    protected void deactivate() {
        this.trackers.values().stream().forEach(Tracker::close);
        this.trackers.clear();
    }

    public Result execute() {
        FormattingResultLog log = new FormattingResultLog();
        List<String> missingServiceNames = this.getMissingServiceNames(log);
        Collection<ComponentDescriptionDTO> dtos = this.getDTOs(missingServiceNames, log);
        for (String missingServiceName : missingServiceNames) {
            if (!missingServiceName.startsWith("(") && dtos != null) {
                this.analyzer.logMissingService(log, missingServiceName, dtos);
                continue;
            }
            log.info("Service '{}' is missing", new Object[]{missingServiceName});
        }
        if (missingServiceNames.isEmpty()) {
            log.info("All {} required services are available", new Object[]{this.servicesList.size()});
        } else {
            log.add(new ResultLog.Entry(this.statusForMissing, "Not all required services are available (" + missingServiceNames.size() + " are missing)"));
        }
        return new Result((ResultLog)log);
    }

    private Collection<ComponentDescriptionDTO> getDTOs(List<String> missingServiceNames, FormattingResultLog log) {
        boolean needsDTOs = false;
        for (String missingServiceName : missingServiceNames) {
            if (missingServiceName.startsWith("(")) continue;
            needsDTOs = true;
            break;
        }
        if (needsDTOs) {
            try {
                return this.scr.getComponentDescriptionDTOs(new Bundle[0]);
            }
            catch (Throwable e) {
                log.temporarilyUnavailable("Exception while getting ds component dtos {}", new Object[]{e.getMessage(), e});
            }
        }
        return null;
    }

    private List<String> getMissingServiceNames(FormattingResultLog log) {
        LinkedList<String> missingServicesNames = new LinkedList<String>();
        for (Map.Entry<String, Tracker> entry : this.trackers.entrySet()) {
            if (!entry.getValue().present()) {
                missingServicesNames.add(entry.getKey());
                continue;
            }
            log.debug("Found {} services for '{}'", new Object[]{entry.getValue().getTrackingCount(), entry.getKey()});
        }
        return missingServicesNames;
    }

    public class Tracker
    implements Closeable {
        private ServiceTracker<?, ?> stracker;

        public Tracker(BundleContext context, String nameOrFilter) {
            Filter filter;
            String filterSt = nameOrFilter.startsWith("(") ? nameOrFilter : String.format("(objectClass=%s)", nameOrFilter);
            try {
                filter = FrameworkUtil.createFilter((String)filterSt);
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException("Error creating filter for " + nameOrFilter);
            }
            this.stracker = new ServiceTracker(context, filter, null);
            this.stracker.open();
        }

        public boolean present() {
            return this.getTrackingCount() > 0;
        }

        public int getTrackingCount() {
            return this.stracker.getTrackingCount();
        }

        @Override
        public void close() {
            this.stracker.close();
        }
    }

    @ObjectClassDefinition(name="Health Check: Services Ready Check", description="System ready check that checks a list of DS components and provides root cause analysis in case of errors")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="Name of this health check")
        public String hc_name() default "Services Ready Check";

        @AttributeDefinition(name="Tags", description="List of tags for this health check, used to select subsets of health checks for execution e.g. by a composite health check.")
        public String[] hc_tags() default {"systemalive"};

        @AttributeDefinition(name="Services list", description="The services that need to be registered for the check to pass. This can be either the service name (objectClass) or an arbitrary filter expression if the expression starts with '(' (for that case at least one service for the filter needs to be available)")
        public String[] services_list();

        @AttributeDefinition(name="Status for missing services", description="Status in case services are missing")
        public Result.Status statusForMissing() default Result.Status.TEMPORARILY_UNAVAILABLE;

        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "{hc.name}: {services.list} / missing -> {statusForMissing}";
    }
}

