/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.execution.HealthCheckExecutionOptions;
import org.apache.felix.hc.api.execution.HealthCheckExecutionResult;
import org.apache.felix.hc.api.execution.HealthCheckExecutor;
import org.apache.felix.hc.api.execution.HealthCheckSelector;
import org.apache.felix.hc.core.impl.executor.CombinedExecutionResult;
import org.apache.felix.hc.core.impl.servlet.ResultTxtVerboseSerializer;
import org.apache.felix.hc.core.impl.util.AdhocStatusHealthCheck;
import org.apache.felix.hc.core.impl.util.lang.StringUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class, factory=true)
public class AdhocResultDuringRequestProcessingFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AdhocResultDuringRequestProcessingFilter.class);
    private BundleContext bundleContext;
    private Result.Status statusDuringRequestProcessing;
    private String hcNameDuringRequestProcessing;
    private String[] hcTagsDuringRequestProcessing;
    private Long delayProcessingInSec;
    private String[] tagsDuringDelayedProcessing;
    private String[] waitAfterProcessingForTags;
    private long waitAfterProcessingInitialWait;
    private long waitAfterProcessingMaxDelay;
    private String requiredMethod;
    private Pattern userAgentRegEx;
    @Reference
    private HealthCheckExecutor executor;
    @Reference
    ResultTxtVerboseSerializer verboseTxtSerializer;

    @Activate
    protected final void activate(ComponentContext context, Config config) {
        this.bundleContext = context.getBundleContext();
        this.statusDuringRequestProcessing = config.statusDuringRequestProcessing();
        this.hcNameDuringRequestProcessing = config.hcName();
        this.hcTagsDuringRequestProcessing = config.tags();
        this.delayProcessingInSec = config.delayProcessingInSec() > 0L ? Long.valueOf(config.delayProcessingInSec()) : null;
        this.tagsDuringDelayedProcessing = config.tagsDuringDelayedProcessing();
        this.waitAfterProcessingForTags = config.waitAfterProcessing_forTags();
        this.waitAfterProcessingInitialWait = config.waitAfterProcessing_initialWait();
        this.waitAfterProcessingMaxDelay = config.waitAfterProcessing_maxDelay();
        this.requiredMethod = StringUtils.defaultIfBlank(config.method(), null);
        this.userAgentRegEx = StringUtils.isNotBlank(config.userAgentRegEx()) ? Pattern.compile(config.userAgentRegEx()) : null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        boolean isRelevantRequest;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String requestPath = httpServletRequest.getRequestURI();
        String userAgent = httpServletRequest.getHeader("User-Agent");
        String method = httpServletRequest.getMethod();
        boolean bl = isRelevantRequest = !(this.requiredMethod != null && !this.requiredMethod.equals(method) || this.userAgentRegEx != null && !this.userAgentRegEx.matcher(userAgent).matches());
        if (isRelevantRequest) {
            this.processRelevantRequest(request, response, filterChain, requestPath);
        } else {
            filterChain.doFilter(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRelevantRequest(ServletRequest request, ServletResponse response, FilterChain filterChain, String requestPath) throws IOException, ServletException {
        AdhocStatusHealthCheck adhocStatusHealthCheck = null;
        try {
            String mainHcMsg = "Request " + requestPath + " is being processed";
            if (this.delayProcessingInSec != null) {
                String hcNameDuringDelay = this.hcNameDuringRequestProcessing + " (waiting)";
                AdhocStatusHealthCheck adhocStatusHealthCheckDelayedProcessing = null;
                try {
                    adhocStatusHealthCheckDelayedProcessing = this.registerDynamicHealthCheck(this.statusDuringRequestProcessing, this.tagsDuringDelayedProcessing, hcNameDuringDelay, "Waiting " + this.delayProcessingInSec + "sec until continuing request " + requestPath);
                    LOG.info("Delaying processing of request {} for {}sec", (Object)requestPath, (Object)this.delayProcessingInSec);
                    try {
                        Thread.sleep(this.delayProcessingInSec * 1000L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Exception during delaying processing of request {} for {}sec", new Object[]{requestPath, this.delayProcessingInSec, e});
                    }
                    adhocStatusHealthCheck = this.registerDynamicHealthCheck(this.statusDuringRequestProcessing, this.hcTagsDuringRequestProcessing, this.hcNameDuringRequestProcessing, mainHcMsg);
                    this.unregisterDynamicHealthCheck(adhocStatusHealthCheckDelayedProcessing);
                }
                catch (Throwable throwable) {
                    adhocStatusHealthCheck = this.registerDynamicHealthCheck(this.statusDuringRequestProcessing, this.hcTagsDuringRequestProcessing, this.hcNameDuringRequestProcessing, mainHcMsg);
                    this.unregisterDynamicHealthCheck(adhocStatusHealthCheckDelayedProcessing);
                    throw throwable;
                }
            }
            adhocStatusHealthCheck = this.registerDynamicHealthCheck(this.statusDuringRequestProcessing, this.hcTagsDuringRequestProcessing, this.hcNameDuringRequestProcessing, mainHcMsg);
            filterChain.doFilter(request, response);
            LOG.info("Request {} is processed", (Object)requestPath);
            if (this.waitAfterProcessingForTags.length > 0) {
                String initialWaitMsg = "Request " + requestPath + ": Waiting for tags " + Arrays.asList(this.waitAfterProcessingForTags) + ": initial wait " + this.waitAfterProcessingInitialWait + "sec";
                adhocStatusHealthCheck.updateMessage(initialWaitMsg);
                this.wait(requestPath, this.waitAfterProcessingInitialWait * 1000L);
                long startTime = System.currentTimeMillis();
                while (true) {
                    List executionResults = this.executor.execute(HealthCheckSelector.tags((String[])this.waitAfterProcessingForTags).withNames(new String[]{"-" + this.hcNameDuringRequestProcessing}), new HealthCheckExecutionOptions().setCombineTagsWithOr(true).setForceInstantExecution(true));
                    CombinedExecutionResult combinedExecutionResult = new CombinedExecutionResult(executionResults);
                    Result overallResult = combinedExecutionResult.getHealthCheckResult();
                    String verboseTxtResult = this.verboseTxtSerializer.serialize(overallResult, (List<HealthCheckExecutionResult>)executionResults, false);
                    String msg = "Request " + requestPath + ": Waiting for tags " + Arrays.asList(this.waitAfterProcessingForTags) + ": " + overallResult.getStatus();
                    LOG.info(msg);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("\n" + verboseTxtResult);
                    }
                    adhocStatusHealthCheck.updateMessage(msg);
                    if (overallResult.isOk()) break;
                    if (System.currentTimeMillis() - startTime > this.waitAfterProcessingMaxDelay * 1000L) {
                        LOG.warn("Maximum delay time {}sec for tags {} exceeded - continuing anyway", (Object)this.waitAfterProcessingMaxDelay, Arrays.asList(this.waitAfterProcessingForTags));
                        throw new ServletException("Maximum wait time " + this.waitAfterProcessingMaxDelay + "sec for tags " + Arrays.asList(this.waitAfterProcessingForTags) + " exceeded:\n" + verboseTxtResult);
                    }
                    LOG.info("Waiting for tags {} before returning from {}", (Object)this.waitAfterProcessingForTags, (Object)requestPath);
                    this.wait(requestPath, 500L);
                }
            }
            this.unregisterDynamicHealthCheck(adhocStatusHealthCheck);
        }
        catch (Throwable throwable) {
            this.unregisterDynamicHealthCheck(adhocStatusHealthCheck);
            throw throwable;
        }
    }

    private void wait(String requestPath, long waitTime) {
        try {
            Thread.sleep(waitTime);
        }
        catch (InterruptedException e) {
            LOG.warn("Exception during delaying processing of request {} for {}sec", new Object[]{requestPath, this.delayProcessingInSec, e});
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    private AdhocStatusHealthCheck registerDynamicHealthCheck(Result.Status status, String[] tags, String hcName, String msg) {
        AdhocStatusHealthCheck healthCheck = new AdhocStatusHealthCheck(status, msg);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("hc.name", hcName);
        ((Dictionary)props).put("hc.tags", tags);
        ServiceRegistration registration = this.bundleContext.registerService(HealthCheck.class, (Object)healthCheck, props);
        healthCheck.setServiceRegistration((ServiceRegistration<HealthCheck>)registration);
        return healthCheck;
    }

    private synchronized void unregisterDynamicHealthCheck(AdhocStatusHealthCheck healthCheck) {
        ServiceRegistration<HealthCheck> serviceRegistration;
        ServiceRegistration<HealthCheck> serviceRegistration2 = serviceRegistration = healthCheck != null ? healthCheck.getServiceRegistration() : null;
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
            LOG.debug("Unregistered adhoc HC");
        }
    }

    @ObjectClassDefinition(name="Health Check Adhoc Result during Request Processing", description="Registers an health check with an adhoc result during request processing")
    public static @interface Config {
        @AttributeDefinition(name="Filter Request Path RegEx", description="Regex to be matched against request path")
        public String osgi_http_whiteboard_filter_regex();

        @AttributeDefinition(name="Filter Context", description="Needs to be set to correct whiteboard context filter (e.g. '(osgi.http.whiteboard.context.name=default)'")
        public String osgi_http_whiteboard_context_select() default "(osgi.http.whiteboard.context.name=*)";

        @AttributeDefinition(name="Request Method", description="Relevant request method (leave empty to not restrict to a method)")
        public String method() default "";

        @AttributeDefinition(name="User Agent RegEx", description="Relevant user agent header (leave emtpy to not restrict to a user agent)")
        public String userAgentRegEx() default "";

        @AttributeDefinition(name="Health Check Name", description="Name of health check during request processing")
        public String hcName() default "Ongoing request";

        @AttributeDefinition(name="Tags to register", description="List of tags the adhoc result shall be registered for (tags are not active during configured delay in case 'delayProcessingInSec' is configured)")
        public String[] tags() default {};

        @AttributeDefinition(name="Status during request processing", description="Status to be sent during request processing")
        public Result.Status statusDuringRequestProcessing() default Result.Status.TEMPORARILY_UNAVAILABLE;

        @AttributeDefinition(name="Delay before request processing", description="Time to delay processing of request in sec (the default 0 turns the delay off). Use together with 'tagsDuringDelayedProcessing' advertise request processing before actual action (e.g. to signal a deployment request to a periodically querying load balancer before deployment starts)")
        public long delayProcessingInSec() default 0L;

        @AttributeDefinition(name="Tags to register during delay before processing", description="List of tags the adhoc result is be registered also during waiting for the configured delay")
        public String[] tagsDuringDelayedProcessing() default {};

        @AttributeDefinition(name="Tags to wait for after processing", description="List of tags to be waited for after processing (leave empty to not wait). While waiting the tags from property 'tags' remain in configured state.")
        public String[] waitAfterProcessing_forTags() default {};

        @AttributeDefinition(name="Initial waiting time", description="Initial waiting time until 'waitAfterProcessing.forTags' are checked for the first time.")
        public long waitAfterProcessing_initialWait() default 3L;

        @AttributeDefinition(name="Maximum delay after processing", description="Maximum delay that can be caused when 'waitAfterProcessing.forTags' is configured (waiting is aborted after that time)")
        public long waitAfterProcessing_maxDelay() default 120L;

        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "{hc.name} ({osgi.http.whiteboard.filter.regex} {method} {userAgentRegEx}) -> {statusDuringRequestProcessing} for tags {tags} {tagsDuringDelayedProcessing}";
    }
}

