/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.servlet;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;

@ObjectClassDefinition(name="Apache Felix Health Check Executor Servlet", description="Serializes health check results into html, json or txt format")
@interface HealthCheckExecutorServletConfiguration {
    public static final String SERVLET_PATH_DEFAULT = "/system/health";

    @AttributeDefinition(name="Path", description="Servlet path (defaults to /system/health in order to not be accessible via Apache/Internet)")
    public String servletPath() default "/system/health";

    @AttributeDefinition(name="Http Status Mapping", description="Maps HC result status values to http response codes. Can be overwritten via request parameter 'httpStatus'")
    public String httpStatusMapping() default "OK:200,WARN:200,CRITICAL:503,TEMPORARILY_UNAVAILABLE:503,HEALTH_CHECK_ERROR:500";

    @AttributeDefinition(name="Timeout", description="Timeout for health check executor. If not configured (left to -1), the default from health check executor's configuration is taken. The setting can always be overwritten by request parameter 'timeout'")
    public long timeout() default -1L;

    @AttributeDefinition(name="Default Tags", description="Default tags if no tags are provided in URL.")
    public String[] tags() default {};

    @AttributeDefinition(name="Combine Tags with OR", description="If true, will execute checks that have any of the given tags. If false, will only execute checks that have *all* of the given tags.")
    public boolean combineTagsWithOr() default true;

    @AttributeDefinition(name="Default Format", description="Default format if format is not provided in URL", options={@Option(label="HTML", value="html"), @Option(label="JSON", value="json"), @Option(label="JSONP", value="jsonp"), @Option(label="TXT", value="txt"), @Option(label="VERBOSE TXT", value="verbose.txt")})
    public String format() default "html";

    @AttributeDefinition(name="Allowed Formats", description="Allow list for formats passed in via the URL", options={@Option(label="HTML", value="html"), @Option(label="JSON", value="json"), @Option(label="JSONP", value="jsonp"), @Option(label="TXT", value="txt"), @Option(label="VERBOSE TXT", value="verbose.txt")})
    public String[] allowed_formats() default {"html", "json", "jsonp", "txt", "verbose.txt"};

    @AttributeDefinition(name="Disabled", description="Allows to disable the servlet if required for security reasons")
    public boolean disabled() default false;

    @AttributeDefinition(name="CORS Access-Control-Allow-Origin", description="Sets the Access-Control-Allow-Origin CORS header. If blank no header is sent.")
    public String cors_accessControlAllowOrigin() default "*";

    @AttributeDefinition(name="Disable Request Configuration", description="If set, parameters passed in via the request are ignored (except for format)")
    public boolean disable_request_configuration() default false;

    @AttributeDefinition
    public String webconsole_configurationFactory_nameHint() default "{servletPath} default format:{format} default tags:{tags} ";
}

