/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.felix.hc.api.execution.HealthCheckExecutionOptions;
import org.apache.felix.hc.api.execution.HealthCheckExecutor;
import org.apache.felix.hc.api.execution.HealthCheckMetadata;
import org.apache.felix.hc.api.execution.HealthCheckSelector;
import org.apache.felix.hc.core.impl.CompositeHealthCheckConfiguration;
import org.apache.felix.hc.core.impl.CompositeResult;
import org.apache.felix.hc.core.impl.util.HealthCheckFilter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={HealthCheck.class}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=CompositeHealthCheckConfiguration.class, factory=true)
public class CompositeHealthCheck
implements HealthCheck {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    static final String PROP_FILTER_TAGS = "filter.tags";
    private String[] filterTags;
    private boolean combineTagsWithOr;
    @Reference
    private HealthCheckExecutor healthCheckExecutor;
    private BundleContext bundleContext;
    private HealthCheckFilter healthCheckFilter;
    private volatile ComponentContext componentContext;

    @Activate
    protected void activate(CompositeHealthCheckConfiguration configuration, ComponentContext ctx) {
        this.bundleContext = ctx.getBundleContext();
        this.componentContext = ctx;
        this.healthCheckFilter = new HealthCheckFilter(this.bundleContext);
        this.filterTags = configuration.filter_tags();
        this.combineTagsWithOr = configuration.filter_combineTagsWithOr();
        this.log.debug("Activated, will select HealthCheck having tags {} {}", Arrays.asList(this.filterTags), (Object)(this.combineTagsWithOr ? "using OR" : "using AND"));
    }

    @Deactivate
    protected void deactivate() {
        this.bundleContext = null;
        this.healthCheckFilter = null;
        this.componentContext = null;
    }

    public Result execute() {
        Result result;
        ComponentContext localCtx = this.componentContext;
        ServiceReference referenceToThis = localCtx == null ? null : localCtx.getServiceReference();
        Result result2 = result = referenceToThis == null ? null : this.checkForRecursion(referenceToThis, new HashSet<String>());
        if (result != null) {
            return result;
        }
        FormattingResultLog resultLog = new FormattingResultLog();
        HealthCheckExecutionOptions options = new HealthCheckExecutionOptions();
        options.setCombineTagsWithOr(this.combineTagsWithOr);
        List executionResults = this.healthCheckExecutor.execute(HealthCheckSelector.tags((String[])this.filterTags), options);
        resultLog.debug("Executing {} HealthChecks selected by tags {}", new Object[]{executionResults.size(), Arrays.asList(this.filterTags)});
        result = new CompositeResult((ResultLog)resultLog, executionResults);
        return result;
    }

    Result checkForRecursion(ServiceReference hcReference, Set<String> alreadyBannedTags) {
        ServiceReference<HealthCheck>[] hcRefsOfCompositeCheck;
        HealthCheckMetadata thisCheckMetadata = new HealthCheckMetadata(hcReference);
        HashSet<String> bannedTagsForThisCompositeCheck = new HashSet<String>();
        bannedTagsForThisCompositeCheck.addAll(alreadyBannedTags);
        bannedTagsForThisCompositeCheck.addAll(thisCheckMetadata.getTags());
        String[] tagsForIncludedChecksArr = CompositeHealthCheck.toStringArray(hcReference.getProperty(PROP_FILTER_TAGS), new String[0]);
        HashSet<String> tagsForIncludedChecks = new HashSet<String>(Arrays.asList(tagsForIncludedChecksArr));
        this.log.debug("HC {} has banned tags {}", (Object)thisCheckMetadata.getName(), bannedTagsForThisCompositeCheck);
        this.log.debug("tagsForIncludedChecks {}", tagsForIncludedChecks);
        HashSet<String> intersection = new HashSet<String>();
        intersection.addAll(bannedTagsForThisCompositeCheck);
        intersection.retainAll(tagsForIncludedChecks);
        if (!intersection.isEmpty()) {
            return new Result(Result.Status.HEALTH_CHECK_ERROR, "INVALID CONFIGURATION: Cycle detected in composite health check hierarchy. Health check '" + thisCheckMetadata.getName() + "' (" + hcReference.getProperty("service.id") + ") must not have tag(s) " + intersection + " as a composite check in the hierarchy is itself already tagged alike (tags assigned to composite checks: " + bannedTagsForThisCompositeCheck + ")");
        }
        for (ServiceReference<HealthCheck> hcRefOfCompositeCheck : hcRefsOfCompositeCheck = this.healthCheckFilter.getHealthCheckServiceReferences(HealthCheckSelector.tags((String[])tagsForIncludedChecksArr), this.combineTagsWithOr)) {
            if (!CompositeHealthCheck.class.getName().equals(hcRefOfCompositeCheck.getProperty("component.name"))) continue;
            this.log.debug("Checking sub composite HC {}, {}", hcRefOfCompositeCheck, hcRefOfCompositeCheck.getProperty("component.name"));
            Result result = this.checkForRecursion(hcRefOfCompositeCheck, bannedTagsForThisCompositeCheck);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static String[] toStringArray(Object propValue, String[] defaultArray) {
        if (propValue instanceof String[]) {
            return (String[])propValue;
        }
        if (propValue instanceof String) {
            return new String[]{(String)propValue};
        }
        if (propValue == null) {
            return defaultArray;
        }
        return defaultArray;
    }

    void setHealthCheckFilter(HealthCheckFilter healthCheckFilter) {
        this.healthCheckFilter = healthCheckFilter;
    }

    void setFilterTags(String[] filterTags) {
        this.filterTags = filterTags;
    }

    void setCombineTagsWithOr(boolean combineTagsWithOr) {
        this.combineTagsWithOr = combineTagsWithOr;
    }

    void setHealthCheckExecutor(HealthCheckExecutor healthCheckExecutor) {
        this.healthCheckExecutor = healthCheckExecutor;
    }

    void setComponentContext(ComponentContext ctx) {
        this.componentContext = ctx;
    }
}

