/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.json.io.impl;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.apache.felix.cm.json.io.Configurations;
import org.osgi.util.converter.Converters;

public class JsonSupport {
    public static Object convertToObject(JsonValue value) {
        if (value == null) {
            return null;
        }
        switch (value.getValueType()) {
            case NULL: {
                return null;
            }
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
            case STRING: {
                return ((JsonString)value).getString();
            }
            case NUMBER: {
                JsonNumber num = (JsonNumber)value;
                if (num.isIntegral()) {
                    return num.longValue();
                }
                return num.doubleValue();
            }
            case ARRAY: {
                JsonArray array = value.asJsonArray();
                JsonValue.ValueType arrayType = JsonSupport.detectArrayType(array);
                Object objArray = arrayType == JsonValue.ValueType.FALSE || arrayType == JsonValue.ValueType.TRUE ? new Boolean[array.size()] : (arrayType == JsonValue.ValueType.NUMBER ? new Object[array.size()] : (arrayType == JsonValue.ValueType.STRING || arrayType == JsonValue.ValueType.OBJECT ? new String[array.size()] : null));
                if (objArray != null) {
                    boolean isLong = true;
                    for (int i = 0; i < array.size(); ++i) {
                        objArray[i] = JsonSupport.convertToObject((JsonValue)array.get(i));
                        if (arrayType != JsonValue.ValueType.NUMBER || objArray[i] instanceof Long) continue;
                        isLong = false;
                    }
                    if (arrayType == JsonValue.ValueType.NUMBER) {
                        if (isLong) {
                            return Converters.standardConverter().convert(objArray).to(Long[].class);
                        }
                        return Converters.standardConverter().convert(objArray).to(Double[].class);
                    }
                    return objArray;
                }
                return array.toString();
            }
        }
        return value.asJsonObject().toString();
    }

    private static JsonValue.ValueType detectArrayType(JsonArray array) {
        if (array.size() == 0) {
            return JsonValue.ValueType.STRING;
        }
        JsonValue.ValueType vt = ((JsonValue)array.get(0)).getValueType();
        for (int i = 1; i < array.size(); ++i) {
            JsonValue.ValueType ct = ((JsonValue)array.get(i)).getValueType();
            boolean isSame = false;
            if (ct == vt) {
                isSame = true;
            } else if (vt == JsonValue.ValueType.TRUE && ct == JsonValue.ValueType.FALSE) {
                isSame = true;
            } else if (vt == JsonValue.ValueType.FALSE && ct == JsonValue.ValueType.TRUE) {
                isSame = true;
            }
            if (isSame) continue;
            return null;
        }
        return vt;
    }

    public static JsonValue convertToJson(Object object) {
        if (object == null) {
            return JsonValue.NULL;
        }
        if (object instanceof String) {
            return Json.createValue((String)((String)object));
        }
        if (object instanceof Long) {
            return Json.createValue((long)((Long)object));
        }
        if (object instanceof Integer) {
            return Json.createValue((int)((Integer)object));
        }
        if (object instanceof Short) {
            return Json.createValue((int)((Short)object).shortValue());
        }
        if (object instanceof Byte) {
            return Json.createValue((int)((Byte)object).byteValue());
        }
        if (object instanceof Float) {
            return Json.createValue((double)((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return Json.createValue((double)((Double)object));
        }
        if (object instanceof Boolean) {
            Boolean value = (Boolean)object;
            return value != false ? JsonValue.TRUE : JsonValue.FALSE;
        }
        if (object instanceof Map) {
            boolean valid = true;
            JsonObjectBuilder builder = Json.createObjectBuilder();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                JsonValue value = JsonSupport.convertToJson(entry.getValue());
                if (entry.getKey() instanceof String) {
                    builder.add(entry.getKey().toString(), value);
                    continue;
                }
                valid = false;
                break;
            }
            if (valid) {
                return builder.build();
            }
        } else {
            if (object instanceof Collection) {
                JsonArrayBuilder builder = Json.createArrayBuilder();
                for (Object obj : (Collection)object) {
                    builder.add(JsonSupport.convertToJson(obj));
                }
                return builder.build();
            }
            if (object.getClass().isArray()) {
                JsonArrayBuilder builder = Json.createArrayBuilder();
                for (int i = 0; i < Array.getLength(object); ++i) {
                    builder.add(JsonSupport.convertToJson(Array.get(object, i)));
                }
                return builder.build();
            }
        }
        return Json.createValue((String)object.toString());
    }

    public static JsonObject parseJson(String identifier, Reader contentsReader) throws IOException {
        Throwable throwable = null;
        try (JsonReader reader = Json.createReader((Reader)Configurations.jsonCommentAwareReader(new FilterReader(contentsReader){

            @Override
            public void close() throws IOException {
            }
        }));){
            JsonStructure obj = reader.read();
            if (obj != null && obj.getValueType() == JsonValue.ValueType.OBJECT) {
                JsonObject jsonObject = (JsonObject)obj;
                return jsonObject;
            }
            try {
                String msg = "Invalid JSON, no root object";
                if (identifier != null) {
                    throw new IOException(identifier.concat(" : ").concat("Invalid JSON, no root object"));
                }
                throw new IOException("Invalid JSON, no root object");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static Reader createCommentRemovingReader(Reader reader) throws IOException {
        return new CommentRemovingReader(reader);
    }

    private static class CommentRemovingReader
    extends FilterReader {
        private boolean closed = false;
        private boolean insideComment = false;
        private boolean insideLineComment = false;

        public CommentRemovingReader(Reader reader) {
            super(new BufferedReader(reader));
        }

        @Override
        public int read() throws IOException {
            return 0;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int charsRead = super.read(cbuf, off, len);
            if (charsRead > 0) {
                StringBuilder filteredContent = new StringBuilder();
                StringBuilder currentLine = new StringBuilder();
                for (int i = off; i < off + charsRead; ++i) {
                    char c = cbuf[i];
                    if (!this.insideComment && c == '/' && i < off + charsRead - 1) {
                        if (cbuf[i + 1] == '*') {
                            this.insideComment = true;
                            ++i;
                            continue;
                        }
                        if (cbuf[i + 1] == '/') {
                            this.insideLineComment = true;
                            ++i;
                            continue;
                        }
                    }
                    if (this.insideComment && !this.insideLineComment && c == '\n') {
                        currentLine.append(c);
                        continue;
                    }
                    if (this.insideComment && c == '*' && i < off + charsRead - 1 && cbuf[i + 1] == '/') {
                        this.insideComment = false;
                        ++i;
                        continue;
                    }
                    if (this.insideLineComment && c == '\n') {
                        this.insideLineComment = false;
                    }
                    if (this.insideComment || this.insideLineComment) continue;
                    currentLine.append(c);
                }
                filteredContent.append(currentLine.toString());
                char[] filteredChars = filteredContent.toString().toCharArray();
                int filteredLen = Math.min(filteredChars.length, len);
                System.arraycopy(filteredChars, 0, cbuf, off, filteredLen);
                return filteredLen;
            }
            return charsRead;
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                this.in.close();
                super.close();
            }
        }
    }
}

