/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.xml;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.exceptions.EmpireException;
import org.apache.empire.exceptions.FileParseException;
import org.apache.empire.exceptions.FileReadException;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.xml.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLConfiguration {
    private static final Logger log = LoggerFactory.getLogger(XMLConfiguration.class);
    private Element configRootNode = null;
    protected final String VAR_BEGIN;
    protected final char VAR_END;
    protected final char VAR_DEFAULT;
    private static String EOL = "\r\n";
    private static String EOC = "----------------------------------------\r\n";

    public XMLConfiguration() {
        this(null);
    }

    public XMLConfiguration(String varIndicator) {
        this.VAR_BEGIN = varIndicator != null ? (varIndicator.endsWith("{") ? varIndicator : varIndicator + "{") : null;
        this.VAR_END = (char)125;
        this.VAR_DEFAULT = (char)124;
    }

    public void init(String filename, boolean fromResource) {
        this.readConfiguration(filename, fromResource);
    }

    public Element getRootNode() {
        return this.configRootNode;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readConfiguration(String fileName, boolean fromResource) {
        FileReader reader = null;
        InputStream inputStream = null;
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = null;
            if (fromResource) {
                log.info("reading resource file: " + fileName);
                inputStream = this.getClass().getClassLoader().getResourceAsStream(fileName);
                doc = docBuilder.parse(inputStream);
            } else {
                log.info("reading configuration file: " + fileName);
                reader = new FileReader(fileName);
                doc = docBuilder.parse(new InputSource(reader));
            }
            this.configRootNode = doc.getDocumentElement();
            this.close(reader);
            this.close(inputStream);
            return;
        }
        catch (FileNotFoundException e) {
            try {
                log.error("Configuration file {} not found!", (Object)fileName, (Object)e);
                throw new FileReadException(fileName, e);
                catch (IOException e2) {
                    log.error("Error reading configuration file {}", (Object)fileName, (Object)e2);
                    throw new FileReadException(fileName, e2);
                }
                catch (SAXException e3) {
                    log.error("Invalid XML in configuration file {}", (Object)fileName, (Object)e3);
                    throw new FileParseException(fileName, e3);
                }
                catch (ParserConfigurationException e4) {
                    log.error("ParserConfigurationException: {}", (Object)e4.getMessage(), (Object)e4);
                    throw new InternalException(e4);
                }
            }
            catch (Throwable throwable) {
                this.close(reader);
                this.close(inputStream);
                throw throwable;
            }
        }
    }

    public void readProperties(Object bean, String ... propertiesNodeNames) {
        if (this.configRootNode == null) {
            throw new ObjectNotValidException(this);
        }
        if (bean == null) {
            throw new InvalidArgumentException("bean", bean);
        }
        Element propertiesNode = this.configRootNode;
        for (String nodeName : propertiesNodeNames) {
            if (StringUtils.isEmpty(nodeName)) {
                throw new InvalidArgumentException("propertiesNodeNames", null);
            }
            if ((propertiesNode = XMLUtil.findFirstChild(propertiesNode, nodeName)) != null) continue;
            log.warn("Property-Node {} has not been found.", (Object)nodeName);
            throw new ItemNotFoundException((Object)nodeName);
        }
        this.readProperties(bean, propertiesNode);
    }

    public void readProperties(Object bean, Element propertiesNode) {
        if (propertiesNode == null) {
            throw new InvalidArgumentException("propertiesNode", propertiesNode);
        }
        if (bean == null) {
            throw new InvalidArgumentException("bean", bean);
        }
        log.info("reading bean properties from node: {}", (Object)propertiesNode.getNodeName());
        NodeList nodeList = propertiesNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node item = nodeList.item(i);
            if (item.getNodeType() != 1 || !(item instanceof Element) || !this.isProperty((Element)item)) continue;
            this.setPropertyValue(bean, (Element)item);
        }
    }

    protected boolean isProperty(Element item) {
        String value = item.getAttribute("property");
        if (value == null || value.length() == 0) {
            return true;
        }
        return ObjectUtils.getBoolean(value);
    }

    protected void setPropertyValue(Object bean, Element item) {
        String name;
        String prop = name = item.getNodeName();
        try {
            Class valueType = PropertyUtils.getPropertyType((Object)bean, (String)name);
            if (valueType == null) {
                log.info("Element <{}> has no Property in Class {}", (Object)name, (Object)bean.getClass().getName());
                return;
            }
            if (item.hasAttributes() && Map.class.isAssignableFrom(valueType)) {
                HashMap<String, Object> map;
                Object value = PropertyUtils.getNestedProperty((Object)bean, (String)name);
                if (value instanceof Map) {
                    map = (HashMap<String, Object>)value;
                } else {
                    map = new HashMap<String, Object>();
                    PropertyUtils.setProperty((Object)bean, (String)name, map);
                }
                NamedNodeMap nm = item.getAttributes();
                for (int i = 0; i < nm.getLength(); ++i) {
                    Node attrib = nm.item(i);
                    prop = attrib.getNodeName();
                    String propVal = attrib.getNodeValue();
                    map.put(prop, this.resolveValue(valueType, propVal));
                    log.info("Configuration Map property '{}' has been set to \"{}\"", (Object)prop, map.get(prop));
                }
                return;
            }
            Object newValue = this.resolveValue(valueType, XMLUtil.getElementText(item));
            this.setPropertyValue(bean, name, newValue);
        }
        catch (IllegalAccessException e) {
            log.error("Config error: Access to '{}' in {} denied.", new Object[]{prop, bean.getClass().getName(), e});
        }
        catch (InvocationTargetException e) {
            log.error("Config error: Unable to set value for '{}' in {}", new Object[]{prop, bean.getClass().getName(), e});
        }
        catch (NoSuchMethodException e) {
            log.error("Config error: Property '{}' in {} not found. Property is ignored.", new Object[]{prop, bean.getClass().getName(), e});
        }
        catch (EmpireException e) {
            log.error("Config error: Invalid Value for '{}' in {}", new Object[]{prop, bean.getClass().getName(), e});
        }
    }

    protected void setPropertyValue(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        BeanUtils.setProperty((Object)bean, (String)name, (Object)value);
        Object newValue = PropertyUtils.getProperty((Object)bean, (String)name);
        if (ObjectUtils.compareEqual(newValue, value)) {
            log.info("Configuration property '{}' has been set to \"{}\"", (Object)name, value);
        } else {
            log.error("Config error: Failed to set '{}' to \"{}\" in {}. Value is \"{}\" instead.", new Object[]{name, value, bean.getClass().getName(), value});
        }
    }

    protected Object resolveValue(Class<?> valueType, String value) {
        String varVal;
        int beg;
        if (value == null) {
            return null;
        }
        int n = beg = StringUtils.isNotEmpty(this.VAR_BEGIN) ? value.indexOf(this.VAR_BEGIN) : -1;
        if (beg < 0) {
            return value;
        }
        int end = this.findVarEnd(value, beg + 2);
        if (end < 0) {
            throw new InvalidArgumentException("value", value);
        }
        String defaultValue = null;
        String var = value.substring(beg + 2, end);
        int def = var.indexOf(this.VAR_DEFAULT);
        if (def > 0) {
            defaultValue = (String)this.resolveValue(String.class, var.substring(def + 1));
            var = var.substring(0, def);
        }
        if ((varVal = this.resolveVariable(var, defaultValue)) == null) {
            throw new ItemNotFoundException((Object)var);
        }
        StringBuilder b = new StringBuilder(value.length() + varVal.length() - (end - beg) - 1);
        b.append(value.substring(0, beg));
        b.append(varVal);
        b.append(value.substring(end + 1));
        return this.resolveValue(valueType, b.toString());
    }

    protected String resolveVariable(String var, String defaultValue) {
        log.debug("Config: Resolving variable {}", (Object)var);
        String value = System.getProperty(var);
        return value != null ? value : defaultValue;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(EOC);
        for (Class<?> clazz = this.getClass(); clazz != null && clazz != XMLConfiguration.class; clazz = clazz.getSuperclass()) {
            this.appendConfigProperties(clazz, this, b, true);
        }
        return b.toString();
    }

    protected void appendConfigProperties(Class<?> clazz, Object object, StringBuilder b, boolean appendClassInfo) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
            try {
                Object value = PropertyUtils.getProperty((Object)object, (String)field.getName());
                if (value != null && !(value instanceof Map)) {
                    boolean simple;
                    Class<?> vc = value.getClass();
                    boolean bl = simple = vc.isPrimitive() || vc.isEnum() || vc == String.class || vc == Character.class || vc == Byte.class || vc == Integer.class || vc == Long.class || vc == Short.class || vc == Double.class || vc == Float.class || vc == Boolean.class || vc == Class.class;
                    if (!simple) {
                        b.append(EOC);
                        b.append(field.getName());
                        b.append("[");
                        b.append(clazz.getName());
                        b.append("]=");
                        b.append(EOL);
                        this.appendConfigProperties(value.getClass(), value, b, false);
                        return;
                    }
                }
                if (appendClassInfo) {
                    appendClassInfo = false;
                    b.append("[Properties of ");
                    b.append(clazz.getName());
                    b.append("]");
                    b.append(EOL);
                }
                b.append(field.getName());
                b.append("=");
                b.append(String.valueOf(value));
                b.append(EOL);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Field {} is ignored due to Exception {}", (Object)field.getName(), (Object)e.toString());
            }
        }
        if (!appendClassInfo) {
            b.append(EOC);
        }
    }

    private int findVarEnd(String value, int from) {
        char NEST_CHAR = this.VAR_BEGIN.charAt(this.VAR_BEGIN.length() - 1);
        int nestCount = 0;
        while (from < value.length()) {
            char c = value.charAt(from);
            if (c == this.VAR_END) {
                if (nestCount == 0) {
                    return from;
                }
                --nestCount;
            }
            if (c == NEST_CHAR) {
                ++nestCount;
            }
            ++from;
        }
        return -1;
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                log.error("Failed to close stream: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

