/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.sqlserver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBRelation;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.exceptions.EmpireSQLException;
import org.apache.empire.db.validation.DBModelChecker;
import org.apache.empire.db.validation.DBModelParser;
import org.apache.empire.dbms.DBMSFeature;
import org.apache.empire.dbms.DBMSHandlerBase;
import org.apache.empire.dbms.DBSqlPhrase;
import org.apache.empire.dbms.sqlserver.MSSqlDBModelParser;
import org.apache.empire.dbms.sqlserver.MSSqlDDLGenerator;
import org.apache.empire.exceptions.InvalidPropertyException;
import org.apache.empire.exceptions.NotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBMSHandlerMSSQL
extends DBMSHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(DBMSHandlerMSSQL.class);
    private String databaseName = null;
    private String objectOwner = "dbo";
    private String sequenceTableName = "Sequences";
    private boolean useSequenceTable = false;
    private boolean useUnicodePrefix = true;
    private boolean useDateTime2 = true;
    protected DBDDLGenerator<?> ddlGenerator = null;
    protected static final String[] MSSQL_SQL_KEYWORDS = new String[]{"type", "key", "plan"};

    public DBMSHandlerMSSQL() {
        for (String keyWord : MSSQL_SQL_KEYWORDS) {
            this.reservedSQLKeywords.add(keyWord);
        }
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getObjectOwner() {
        return this.objectOwner;
    }

    public void setObjectOwner(String objectOwner) {
        this.objectOwner = objectOwner;
    }

    public boolean isUseSequenceTable() {
        return this.useSequenceTable;
    }

    public void setUseSequenceTable(boolean useSequenceTable) {
        this.useSequenceTable = useSequenceTable;
    }

    public String getSequenceTableName() {
        return this.sequenceTableName;
    }

    public void setSequenceTableName(String sequenceTableName) {
        this.sequenceTableName = sequenceTableName;
    }

    public boolean isUseUnicodePrefix() {
        return this.useUnicodePrefix;
    }

    public void setUseUnicodePrefix(boolean useUnicodePrefix) {
        this.useUnicodePrefix = useUnicodePrefix;
    }

    public boolean isUseDateTime2() {
        return this.useDateTime2;
    }

    public void setUseDateTime2(boolean useDateTime2) {
        this.useDateTime2 = useDateTime2;
    }

    @Override
    public boolean checkExists(DBDatabase db, Connection conn) {
        try {
            if (StringUtils.isNotEmpty(this.databaseName)) {
                this.executeSQL("USE " + this.databaseName, null, conn, null);
            }
            return super.checkExists(db, conn);
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public void attachDatabase(DBDatabase db, Connection conn) {
        try {
            String schema;
            if (StringUtils.isNotEmpty(this.databaseName)) {
                this.executeSQL("USE " + this.databaseName, null, conn, null);
            }
            this.executeSQL("set dateformat ymd", null, conn, null);
            if (this.useSequenceTable && db.getTable(this.sequenceTableName) == null) {
                new DBMSHandlerBase.DBSeqTable(this.sequenceTableName, db);
            }
            if (StringUtils.isNotEmpty(schema = db.getSchema()) && schema.indexOf(46) < 0 && StringUtils.isNotEmpty(this.objectOwner)) {
                db.setSchema(schema + "." + this.objectOwner);
            }
            super.attachDatabase(db, conn);
        }
        catch (SQLException e) {
            throw new EmpireSQLException(this, e);
        }
    }

    @Override
    public DBCommand createCommand(boolean autoPrepareStmt) {
        return new DBCommandMSSQL(this, autoPrepareStmt);
    }

    @Override
    public DBSQLBuilder createSQLBuilder() {
        return new DBSQLBuilderMSSQL(this);
    }

    @Override
    public boolean isSupported(DBMSFeature type) {
        switch (type) {
            case CREATE_SCHEMA: {
                return true;
            }
            case SEQUENCES: {
                return this.useSequenceTable;
            }
            case QUERY_LIMIT_ROWS: {
                return true;
            }
            case QUERY_SKIP_ROWS: {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getSQLPhrase(DBSqlPhrase phrase) {
        switch (phrase) {
            case SQL_NULL: {
                return "null";
            }
            case SQL_PARAMETER: {
                return " ? ";
            }
            case SQL_RENAME_TABLE: {
                return " ";
            }
            case SQL_RENAME_COLUMN: {
                return " AS ";
            }
            case SQL_DATABASE_LINK: {
                return "@";
            }
            case SQL_QUOTES_OPEN: {
                return "[";
            }
            case SQL_QUOTES_CLOSE: {
                return "]";
            }
            case SQL_CONCAT_EXPR: {
                return " + ";
            }
            case SQL_PSEUDO_TABLE: {
                return "";
            }
            case SQL_BOOLEAN_TRUE: {
                return "1";
            }
            case SQL_BOOLEAN_FALSE: {
                return "0";
            }
            case SQL_CURRENT_DATE: {
                return "convert(char, getdate(), 111)";
            }
            case SQL_DATE_PATTERN: {
                return "yyyy-MM-dd";
            }
            case SQL_DATE_TEMPLATE: {
                return "convert(date, '{0}', 111)";
            }
            case SQL_CURRENT_TIME: {
                return "convert(time, getdate())";
            }
            case SQL_TIME_PATTERN: {
                return "HH:mm:ss";
            }
            case SQL_TIME_TEMPLATE: {
                return "convert(time, '{0}')";
            }
            case SQL_DATETIME_PATTERN: {
                return "yyyy-MM-dd HH:mm:ss.SSS";
            }
            case SQL_DATETIME_TEMPLATE: {
                return this.isUseDateTime2() ? "convert(datetime2, '{0}', 121)" : "convert(datetime,  '{0}', 121)";
            }
            case SQL_CURRENT_TIMESTAMP: {
                return "getdate()";
            }
            case SQL_TIMESTAMP_PATTERN: {
                return "yyyy-MM-dd HH:mm:ss.SSS";
            }
            case SQL_TIMESTAMP_TEMPLATE: {
                return this.isUseDateTime2() ? "convert(datetime2, '{0}', 121)" : "convert(datetime,  '{0}', 121)";
            }
            case SQL_FUNC_COALESCE: {
                return "coalesce(?, {0})";
            }
            case SQL_FUNC_SUBSTRING: {
                return "substring(?, {0}, 4000)";
            }
            case SQL_FUNC_SUBSTRINGEX: {
                return "substring(?, {0}, {1})";
            }
            case SQL_FUNC_REPLACE: {
                return "replace(?, {0}, {1})";
            }
            case SQL_FUNC_REVERSE: {
                return "reverse(?)";
            }
            case SQL_FUNC_STRINDEX: {
                return "charindex({0}, ?)";
            }
            case SQL_FUNC_STRINDEXFROM: {
                return "charindex({0}, ?, {1})";
            }
            case SQL_FUNC_LENGTH: {
                return "len(?)";
            }
            case SQL_FUNC_UPPER: {
                return "upper(?)";
            }
            case SQL_FUNC_LOWER: {
                return "lower(?)";
            }
            case SQL_FUNC_TRIM: {
                return "trim(?)";
            }
            case SQL_FUNC_LTRIM: {
                return "ltrim(?)";
            }
            case SQL_FUNC_RTRIM: {
                return "rtrim(?)";
            }
            case SQL_FUNC_ESCAPE: {
                return "? escape {0:VARCHAR}";
            }
            case SQL_FUNC_ABS: {
                return "abs(?)";
            }
            case SQL_FUNC_ROUND: {
                return "round(?,{0})";
            }
            case SQL_FUNC_TRUNC: {
                return "trunc(?,{0})";
            }
            case SQL_FUNC_CEILING: {
                return "ceiling(?)";
            }
            case SQL_FUNC_FLOOR: {
                return "floor(?)";
            }
            case SQL_FUNC_MOD: {
                return "((?) % {0})";
            }
            case SQL_FUNC_FORMAT: {
                return "format(?, {0:VARCHAR})";
            }
            case SQL_FUNC_DAY: {
                return "day(?)";
            }
            case SQL_FUNC_MONTH: {
                return "month(?)";
            }
            case SQL_FUNC_YEAR: {
                return "year(?)";
            }
            case SQL_FUNC_SUM: {
                return "sum(?)";
            }
            case SQL_FUNC_MAX: {
                return "max(?)";
            }
            case SQL_FUNC_MIN: {
                return "min(?)";
            }
            case SQL_FUNC_AVG: {
                return "avg(?)";
            }
            case SQL_FUNC_STRAGG: {
                return "string_agg(?,{0}) WITHIN GROUP (ORDER BY {1})";
            }
            case SQL_FUNC_DECODE: {
                return "case ? {0} end";
            }
            case SQL_FUNC_DECODE_SEP: {
                return " ";
            }
            case SQL_FUNC_DECODE_PART: {
                return "when {0} then {1}";
            }
            case SQL_FUNC_DECODE_ELSE: {
                return "else {0}";
            }
        }
        return phrase.getSqlDefault();
    }

    @Override
    public String getConvertPhrase(DataType destType, DataType srcType, Object format) {
        switch (destType) {
            case BOOL: {
                return "convert(bit, ?)";
            }
            case INTEGER: {
                return "convert(int, ?)";
            }
            case DECIMAL: {
                if (format instanceof Number) {
                    return "convert(decimal(" + format.toString().replace('.', ',') + "), ?)";
                }
                return "convert(decimal, ?)";
            }
            case FLOAT: {
                return "convert(float, ?)";
            }
            case DATE: {
                return "convert(date, ?, 111)";
            }
            case TIME: {
                return "convert(time, ?)";
            }
            case DATETIME: 
            case TIMESTAMP: {
                return this.isUseDateTime2() ? "convert(datetime2, ?, 121)" : "convert(datetime,  ?, 121)";
            }
            case VARCHAR: 
            case CHAR: 
            case CLOB: {
                if (srcType == DataType.DATE) {
                    return "convert(nvarchar, ?, 111)";
                }
                if (srcType == DataType.DATETIME || srcType == DataType.TIMESTAMP) {
                    return "convert(nvarchar, ?, 120)";
                }
                return "convert(nvarchar, ?)";
            }
            case BLOB: {
                return "convert(varbinary, ?)";
            }
        }
        log.error("getConvertPhrase: unknown type " + (Object)((Object)destType));
        return "?";
    }

    @Override
    public Object getNextSequenceValue(DBDatabase db, String seqName, int minValue, Connection conn) {
        if (this.useSequenceTable) {
            DBTable t = db.getTable(this.sequenceTableName);
            return ((DBMSHandlerBase.DBSeqTable)t).getNextValue(seqName, minValue, conn);
        }
        return null;
    }

    @Override
    public DBColumnExpr getNextSequenceValueExpr(DBTableColumn column) {
        if (this.isUseSequenceTable()) {
            throw new NotSupportedException(this, "getNextSequenceValueExpr");
        }
        return null;
    }

    @Override
    public Timestamp getUpdateTimestamp(Connection conn) {
        GregorianCalendar cal = new GregorianCalendar();
        return new Timestamp(cal.getTimeInMillis());
    }

    @Override
    public Object getColumnAutoValue(DBDatabase db, DBTableColumn column, Connection conn) {
        if (column.getDataType() == DataType.UNIQUEID) {
            return this.querySingleValue("select newid()", null, DataType.UNIQUEID, conn);
        }
        return super.getColumnAutoValue(db, column, conn);
    }

    @Override
    protected void addStatementParam(PreparedStatement pstmt, int paramIndex, Object value) throws SQLException {
        if (value instanceof Timestamp && !this.isUseDateTime2()) {
            Timestamp ts = (Timestamp)value;
            if (ts.getNanos() != 0) {
                String tsAsString = ts.toString();
                int nano = tsAsString.lastIndexOf(46);
                int milliLength = nano + 4;
                if (nano > 0 && tsAsString.length() > milliLength) {
                    tsAsString = tsAsString.substring(0, milliLength);
                }
                pstmt.setObject(paramIndex, tsAsString);
            } else {
                pstmt.setTimestamp(paramIndex, ts);
            }
        } else {
            super.addStatementParam(pstmt, paramIndex, value);
        }
    }

    @Override
    public void getDDLScript(DBDDLGenerator.DDLActionType type, DBObject dbo, DBSQLScript script) {
        if (this.ddlGenerator == null) {
            this.ddlGenerator = new MSSqlDDLGenerator(this);
        }
        this.ddlGenerator.getDDLScript(type, dbo, script);
    }

    @Override
    public void appendEnableRelationStmt(DBRelation r, boolean enable, DBSQLScript script) {
        DBSQLBuilder sql = this.createSQLBuilder();
        sql.append("ALTER TABLE ");
        r.getForeignKeyTable().addSQL(sql, 2L);
        sql.append(enable ? " CHECK " : " NOCHECK ");
        sql.append("CONSTRAINT ");
        sql.append(r.getName());
        script.addStmt(sql);
    }

    @Override
    public DBModelParser createModelParser(String catalog, String schema) {
        return new MSSqlDBModelParser(catalog, schema);
    }

    @Override
    public DBModelChecker createModelChecker(DBDatabase db) {
        String catalog;
        String string = catalog = db != null ? StringUtils.coalesce(db.getSchema(), this.databaseName) : this.databaseName;
        if (StringUtils.isEmpty(catalog)) {
            throw new InvalidPropertyException("databaseName", (Object)null);
        }
        String schema = "DBO";
        int schemaSep = catalog.indexOf(46);
        if (schemaSep > 0) {
            catalog = catalog.substring(schemaSep);
            schema = catalog.substring(schemaSep + 1);
        }
        return new DBModelChecker(this.createModelParser(catalog, schema));
    }

    public static class DBSQLBuilderMSSQL
    extends DBSQLBuilder {
        private final boolean useUnicodePrefix;

        public DBSQLBuilderMSSQL(DBMSHandlerMSSQL dbms) {
            super(dbms);
            this.useUnicodePrefix = dbms.useUnicodePrefix;
        }

        @Override
        protected void appendStringLiteral(DataType type, Object value) {
            if (value == null) {
                this.append(DBSqlPhrase.SQL_NULL);
                return;
            }
            String text = value.toString();
            this.sql.append(this.useUnicodePrefix ? "N'" : "'");
            if (!"\u0000".equals(text)) {
                this.escapeAndAppendLiteral(text);
            }
            this.sql.append('\'');
        }
    }

    public static class DBCommandMSSQL
    extends DBCommand {
        protected int limit = -1;
        protected int skipRows = -1;

        public DBCommandMSSQL(DBMSHandlerMSSQL dbms, boolean autoPrepareStmt) {
            super(dbms, autoPrepareStmt);
        }

        @Override
        public DBCommand limitRows(int numRows) {
            this.limit = numRows;
            return this;
        }

        @Override
        public DBCommand skipRows(int skipRows) {
            this.skipRows = skipRows;
            return this;
        }

        @Override
        public void clearLimit() {
            this.limit = -1;
            this.skipRows = -1;
        }

        @Override
        public void getSelect(DBSQLBuilder sql, int flags) {
            super.getSelect(sql, flags);
            if (this.skipRows >= 0 && this.not(flags, 32)) {
                sql.append("\r\nOFFSET ");
                sql.append(String.valueOf(this.skipRows));
                sql.append(" ROWS");
                if (this.limit >= 0) {
                    sql.append(" FETCH NEXT ");
                    sql.append(String.valueOf(this.limit));
                    sql.append(" ROWS ONLY");
                }
            }
        }

        @Override
        protected void addSelect(DBSQLBuilder sql) {
            sql.append("SELECT ");
            if (this.selectDistinct) {
                sql.append("DISTINCT ");
            }
            if (this.limit >= 0 && this.skipRows < 0) {
                sql.append("TOP ");
                sql.append(String.valueOf(this.limit));
                sql.append(" ");
            }
            this.addListExpr(sql, this.select, 15L, ", ");
        }
    }
}

