/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.list;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.empire.commons.ClassUtils;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBContext;
import org.apache.empire.db.DBRecord;
import org.apache.empire.db.DBRecordBase;
import org.apache.empire.db.DBRecordBean;
import org.apache.empire.db.DBRecordData;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.list.DBRecordListFactory;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.InvalidPropertyException;
import org.apache.empire.exceptions.UnsupportedTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBRecordListFactoryImpl<T extends DBRecordBase>
implements DBRecordListFactory<T> {
    protected static final Logger log = LoggerFactory.getLogger(DBRecordListFactoryImpl.class);
    protected final Constructor<T> constructor;
    protected final DBRowSet rowset;
    protected final int timestampIndex;

    protected static <T extends DBRecordBase> Constructor<T> findRecordConstructor(Class<T> recordClass, Class<? extends DBContext> contextClass, Class<? extends DBRowSet> rowsetClass) {
        Constructor<T> constructor;
        if (DBRecordBean.class.isAssignableFrom(recordClass)) {
            constructor = ClassUtils.findMatchingConstructor(recordClass, 0, new Class[0]);
        } else {
            constructor = ClassUtils.findMatchingConstructor(recordClass, 1, contextClass, rowsetClass);
            if (constructor == null) {
                throw new UnsupportedTypeException(recordClass);
            }
        }
        return constructor;
    }

    public DBRecordListFactoryImpl(Constructor<T> constructor, DBRowSet rowset) {
        this.constructor = constructor;
        this.rowset = rowset;
        DBColumn timestampCol = rowset.getTimestampColumn();
        this.timestampIndex = timestampCol != null ? rowset.getColumnIndex(timestampCol) : -1;
    }

    public DBRecordListFactoryImpl(Class<T> recordClass, Class<? extends DBContext> contextClass, DBRowSet rowset) {
        this(DBRecordListFactoryImpl.findRecordConstructor(recordClass, contextClass, rowset.getClass()), rowset);
    }

    @Override
    public void prepareQuery(DBCommand cmd, DBContext context) {
        if (cmd.hasSelectExpr()) {
            return;
        }
        cmd.select(this.rowset.getColumns());
    }

    @Override
    public List<T> newList(int capacity) {
        return new ArrayList(capacity);
    }

    @Override
    public T newRecord(int rownum, DBRecordData recData) {
        try {
            DBRecordBase record;
            DBRecordBase.State state = this.detectRecordState(recData);
            if (state == null) {
                return null;
            }
            switch (this.constructor.getParameterCount()) {
                case 2: {
                    record = (DBRecordBase)this.constructor.newInstance(recData.getContext(), this.rowset);
                    break;
                }
                case 1: {
                    record = (DBRecordBase)this.constructor.newInstance(recData.getContext());
                    break;
                }
                case 0: {
                    record = (DBRecordBase)this.constructor.newInstance(new Object[0]);
                    break;
                }
                default: {
                    throw new UnsupportedTypeException(this.constructor.getClass());
                }
            }
            if (record instanceof DBRecord && !this.rowset.isSame(record.getRowSet())) {
                log.warn("DBRecordListFactoryImpl rowset ({}) and actual record rowset ({}) don't match!", (Object)this.rowset.getName(), (Object)record.getRowSet().getName());
                throw new InvalidPropertyException("rowset", record.getRowSet());
            }
            if (state != DBRecordBase.State.Invalid) {
                this.rowset.initRecord(record, recData, state == DBRecordBase.State.New);
            }
            return (T)record;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new InternalException(e);
        }
    }

    @Override
    public void completeQuery(List<T> list) {
    }

    protected DBRecordBase.State detectRecordState(DBRecordData recData) {
        if (this.timestampIndex >= 0 && recData.isNull(this.timestampIndex)) {
            return DBRecordBase.State.New;
        }
        return DBRecordBase.State.Valid;
    }
}

