/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Set;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.xml.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DBValueExpr
extends DBColumnExpr {
    private static final Logger log = LoggerFactory.getLogger(DBValueExpr.class);
    public final DBDatabase db;
    public final DataType type;
    protected Object value;
    private String name;

    public DBValueExpr(DBDatabase db, Object value, DataType type) {
        this.db = db;
        this.type = type;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        this.name = null;
    }

    public final DBDatabase getDatabase() {
        return this.db;
    }

    @Override
    public DataType getDataType() {
        return this.type;
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        if (this.value != null && this.value.getClass().isEnum()) {
            Class<Enum<?>> enumType = this.value.getClass();
            return enumType;
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            int i;
            String str = String.valueOf(this.value);
            int l = Math.min(str.length(), 20);
            boolean valid = true;
            for (i = 0; i < l; ++i) {
                char c = str.charAt(i);
                if (c == '-' && i == 0) continue;
                boolean bl = valid = c == ' ' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
                if (!valid) break;
            }
            if (StringUtils.isNotEmpty(str = str.substring(str.charAt(0) == '-' ? 1 : 0, i))) {
                char c = str.charAt(0);
                if (c >= '0' && c <= '9') {
                    str = "N" + str;
                }
                this.name = "VAL_" + str.replace(' ', '_').toUpperCase();
            } else {
                this.name = "VALUE";
            }
        }
        return this.name;
    }

    @Override
    public Element addXml(Element parent, long flags) {
        Element elem = XMLUtil.addElement(parent, "column");
        String name = this.getName();
        if (name != null) {
            elem.setAttribute("name", this.getName());
        }
        if (this.attributes != null) {
            this.attributes.addXml(elem, flags);
        }
        if (this.options != null) {
            this.options.addXml(elem, this.type);
        }
        elem.setAttribute("function", "value");
        return elem;
    }

    @Override
    public DBRowSet getRowSet() {
        return null;
    }

    @Override
    public DBColumn getUpdateColumn() {
        return null;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DBValueExpr) {
            Object otherValue = ((DBValueExpr)other).value;
            return ObjectUtils.compareEqual(this.value, otherValue);
        }
        return false;
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        if ((context & 4L) != 0L) {
            sql.appendValue(this.getDataType(), this.value);
        } else {
            log.warn("Cannot add SQL for DBValueExpr using context {}", (Object)context);
        }
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
    }
}

