/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.exceptions;

import org.apache.empire.commons.ErrorType;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.EntityType;
import org.apache.empire.data.Record;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.exceptions.EmpireException;

public abstract class RecordException
extends EmpireException {
    private static final long serialVersionUID = 1L;
    private static final Object[] NO_KEY = new Object[0];
    private final transient EntityType entityType;
    private final transient Object[] key;

    protected static Object[] getKey(Record rec) {
        try {
            if (!rec.isValid() || ObjectUtils.isEmpty(rec.getKeyColumns())) {
                return NO_KEY;
            }
            return rec.getKey();
        }
        catch (Exception e) {
            return NO_KEY;
        }
    }

    protected static EntityType getEntityType(Record record) {
        try {
            return record.getEntityType();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static String keyToString(Object[] key) {
        return key != null ? StringUtils.arrayToString(key, StringUtils.LIST_TEMPLATE) : "[]";
    }

    protected static String entityName(EntityType entity) {
        return entity != null ? entity.getEntityName() : "{Null}";
    }

    protected static String rowsetName(DBRowSet rowset) {
        return rowset != null ? StringUtils.coalesce(rowset.getName(), rowset.getAlias()) : "{Null}";
    }

    public RecordException(EntityType entityType, Object[] key, ErrorType errType, String[] params, Throwable cause) {
        super(errType, params, cause);
        this.entityType = entityType;
        this.key = key;
    }

    public RecordException(EntityType entity, Object[] key, ErrorType errType, String[] params) {
        this(entity, key, errType, params, null);
    }

    public RecordException(Record record, ErrorType errType, String[] params) {
        this(RecordException.getEntityType(record), RecordException.getKey(record), errType, params, null);
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public Object[] getKey() {
        return this.key;
    }
}

