/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.commons;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.empire.commons.Unwrappable;
import org.apache.empire.commons.ValueUtils;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.DataType;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ValueConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectUtils {
    private static final Logger log = LoggerFactory.getLogger(ObjectUtils.class);
    public static final NoValue NO_VALUE = new NoValue();
    private static ValueUtils valueUtils = new ValueUtils();

    public static ValueUtils getValueUtils() {
        return valueUtils;
    }

    public static void setValueUtils(ValueUtils valueUtils) {
        ObjectUtils.valueUtils = valueUtils;
    }

    private ObjectUtils() {
    }

    public static boolean isEmpty(Object o) {
        return valueUtils.isEmpty(o);
    }

    public static boolean isNotEmpty(Object o) {
        return !ObjectUtils.isEmpty(o);
    }

    public static boolean isZero(Number value) {
        return valueUtils.isZero(value);
    }

    public static boolean isNonZero(Number value) {
        return !ObjectUtils.isZero(value);
    }

    public static int lengthOf(Object o) {
        return valueUtils.lengthOf(o);
    }

    public static boolean compareEqual(Object o1, Object o2) {
        return valueUtils.compareEqual(o1, o2);
    }

    public static int compare(Object o1, Object o2) {
        return valueUtils.compare(o1, o2);
    }

    public static <T> T coalesce(T preferred, T alternative) {
        return preferred != null ? preferred : alternative;
    }

    @Deprecated
    public static int toInteger(Object v) {
        return valueUtils.toInteger(v);
    }

    public static int getInteger(Object v, int defValue) {
        if (ObjectUtils.isEmpty(v)) {
            return defValue;
        }
        try {
            return valueUtils.toInteger(v);
        }
        catch (NumberFormatException e) {
            log.error(String.format("Cannot convert value [%s] to int", v));
            return defValue;
        }
    }

    public static int getInteger(Object v) {
        return ObjectUtils.getInteger(v, 0);
    }

    @Deprecated
    public static long toLong(Object v) {
        return valueUtils.toLong(v);
    }

    public static long getLong(Object v, long defValue) {
        if (ObjectUtils.isEmpty(v)) {
            return defValue;
        }
        try {
            return valueUtils.toLong(v);
        }
        catch (NumberFormatException e) {
            log.error(String.format("Cannot convert value [%s] to long", v));
            return defValue;
        }
    }

    public static long getLong(Object v) {
        return ObjectUtils.getLong(v, 0L);
    }

    @Deprecated
    public static double toDouble(Object v) {
        return valueUtils.toDouble(v);
    }

    public static double getDouble(Object v, double defValue) {
        if (ObjectUtils.isEmpty(v)) {
            return defValue;
        }
        try {
            return valueUtils.toDouble(v);
        }
        catch (NumberFormatException e) {
            log.error(String.format("Cannot convert value [%s] to double", v));
            return defValue;
        }
    }

    public static double getDouble(Object v) {
        return ObjectUtils.getDouble(v, 0.0);
    }

    @Deprecated
    public static BigDecimal toDecimal(Object v) {
        return valueUtils.toDecimal(v);
    }

    public static BigDecimal getDecimal(Object v, BigDecimal defValue) {
        if (ObjectUtils.isEmpty(v)) {
            return defValue;
        }
        try {
            return valueUtils.toDecimal(v);
        }
        catch (NumberFormatException e) {
            log.error(String.format("Cannot convert value [%s] to BigDecimal", v));
            return defValue;
        }
    }

    public static BigDecimal getDecimal(Object v) {
        return ObjectUtils.getDecimal(v, BigDecimal.ZERO);
    }

    public static boolean getBoolean(Object v, boolean defValue) {
        return valueUtils.toBoolean(v, defValue);
    }

    public static boolean getBoolean(Object v) {
        return valueUtils.toBoolean(v, false);
    }

    public static <T extends Enum<?>> T getEnum(Class<T> enumType, Object value) {
        return valueUtils.toEnum(enumType, value);
    }

    public static <T extends Enum<?>> T getEnumByName(Class<T> enumType, String name) {
        return valueUtils.toEnumByName(enumType, name);
    }

    public static Object getEnumValue(Enum<?> enumValue, boolean isNumeric) {
        return valueUtils.enumToValue(enumValue, isNumeric);
    }

    public static String getString(Enum<?> enumValue) {
        return valueUtils.enumToString(enumValue);
    }

    public static String getString(Object value) {
        return valueUtils.toString(value);
    }

    public static Date getDate(Object v) {
        try {
            return valueUtils.toDate(v);
        }
        catch (ParseException e) {
            throw new ValueConversionException(Date.class, v, e);
        }
    }

    public static LocalDate getLocalDate(Object v) {
        try {
            return valueUtils.toLocalDate(v);
        }
        catch (DateTimeParseException e) {
            throw new ValueConversionException(LocalDate.class, v, e);
        }
    }

    public static LocalDateTime getLocalDateTime(Object v) {
        try {
            return valueUtils.toLocalDateTime(v);
        }
        catch (DateTimeParseException e) {
            throw new ValueConversionException(LocalDateTime.class, v, e);
        }
    }

    public static Timestamp getTimestamp(Object v) {
        try {
            return valueUtils.toTimestamp(v);
        }
        catch (DateTimeParseException e) {
            throw new ValueConversionException(Timestamp.class, v, e);
        }
    }

    public static String formatDate(Date date, boolean withTime) {
        return valueUtils.formatDate(date, withTime);
    }

    public static <T> T convert(Class<T> c, Object v) throws ClassCastException {
        return valueUtils.convertToJava(c, v);
    }

    public static Object convertValue(DataType type, Object value) {
        return valueUtils.convertToData(type, value);
    }

    public static boolean isAssignmentCompatible(Class<?> target, Class<?> source) {
        Class<Number> numberClass;
        if (target.isAssignableFrom(source)) {
            return true;
        }
        if (source.isPrimitive()) {
            if ((source = MethodUtils.getPrimitiveWrapper(source)) == null) {
                return false;
            }
            if (target.isAssignableFrom(source)) {
                return true;
            }
        }
        if (target.isPrimitive()) {
            if ((target = MethodUtils.getPrimitiveWrapper(target)) == null) {
                return false;
            }
            if (target.isAssignableFrom(source)) {
                return true;
            }
        }
        if ((numberClass = Number.class).isAssignableFrom(target) && numberClass.isAssignableFrom(source)) {
            return true;
        }
        return source == Character.class && target == String.class;
    }

    public static boolean compareEqual(Object[] array1, Object[] array2) {
        int len2;
        int len1 = array1 != null ? array1.length : 0;
        int n = len2 = array2 != null ? array2.length : 0;
        if (len1 != len2) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            if (ObjectUtils.compareEqual(array1[i], array2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean compareEqual(ColumnExpr expr, ColumnExpr other) {
        if (ObjectUtils.isWrapper(other) && !ObjectUtils.isWrapper(expr)) {
            return expr.equals(ObjectUtils.unwrap(other));
        }
        if (!ObjectUtils.isWrapper(other) && ObjectUtils.isWrapper(expr)) {
            return ObjectUtils.unwrap(expr).equals(other);
        }
        return expr.equals(other);
    }

    public static <T> List<T> convert(Class<T> t, Collection<? extends T> source) {
        if (source == null) {
            return null;
        }
        ArrayList<T> target = new ArrayList<T>(source.size());
        target.addAll(source);
        return target;
    }

    @SafeVarargs
    public static <T> T[] toArray(Class<T> t, T ... values) {
        if (values.length == 0) {
            throw new InvalidArgumentException("values", values);
        }
        return values;
    }

    public static String[] toStringArray(Object[] objArray, String defValue) {
        if (objArray == null) {
            return null;
        }
        String[] strArray = new String[objArray.length];
        for (int i = 0; i < objArray.length; ++i) {
            strArray[i] = objArray[i] != null ? objArray[i].toString() : defValue;
        }
        return strArray;
    }

    public static <T> List<T> arrayToList(Class<T> t, T[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    public static <T> T[] listToArray(Class<? extends T[]> type, List<? extends T> list) {
        if (list == null) {
            return null;
        }
        Object[] arr = type == Object[].class ? new Object[list.size()] : (Object[])Array.newInstance(type.getComponentType(), list.size());
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = list.get(i);
        }
        return arr;
    }

    public static boolean isWrapper(Object object) {
        return object instanceof Unwrappable && ((Unwrappable)object).isWrapper();
    }

    public static <T> T unwrap(T object) {
        if (object instanceof Unwrappable && ((Unwrappable)object).isWrapper()) {
            return ObjectUtils.unwrap(((Unwrappable)object).unwrap());
        }
        return object;
    }

    public static <T> int indexOf(T[] array, T item) {
        T ai;
        int i;
        if (array == null || array.length == 0) {
            return -1;
        }
        for (i = 0; i < array.length; ++i) {
            if (array[i] != item) continue;
            return i;
        }
        for (i = 0; i < array.length; ++i) {
            ai = array[i];
            if (ai == null || !ai.equals(item)) continue;
            return i;
        }
        for (i = 0; i < array.length; ++i) {
            Object unwrapped;
            ai = array[i];
            if (!(ai instanceof Unwrappable) || !((Unwrappable)ai).isWrapper() || (unwrapped = ((Unwrappable)ai).unwrap()) != item && !unwrapped.equals(item)) continue;
            return i;
        }
        if (item instanceof Unwrappable && ((Unwrappable)item).isWrapper()) {
            return ObjectUtils.indexOf(array, ((Unwrappable)item).unwrap());
        }
        return -1;
    }

    public static <T> boolean contains(T[] array, T item) {
        return ObjectUtils.indexOf(array, item) >= 0;
    }

    public static <T> T[] combine(T[] left, T[] right) {
        if (left == null || left.length == 0) {
            return right;
        }
        if (right == null || right.length == 0) {
            return left;
        }
        T[] result = Arrays.copyOf(left, left.length + right.length);
        System.arraycopy(right, 0, result, left.length, right.length);
        return result;
    }

    public static <T> T[] append(T[] array, T element) {
        if (array == null) {
            throw new InvalidArgumentException("array", array);
        }
        T[] result = Arrays.copyOf(array, array.length + 1);
        result[array.length] = element;
        return result;
    }

    private static final class NoValue
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private NoValue() {
        }

        public String toString() {
            return "[NO-VALUE]";
        }
    }
}

