/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.jsf2.components.TabViewTag;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.apache.empire.jsf2.utils.TagEncodingHelperFactory;
import org.apache.empire.jsf2.utils.TagStyleClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabPageTag
extends UIOutput
implements NamingContainer {
    private static final Logger log = LoggerFactory.getLogger(TabPageTag.class);
    public static final String LABEL_FACET_NAME = "label";
    protected final TagEncodingHelper helper = TagEncodingHelperFactory.create(this, TagStyleClass.TAB_PAGE.get());
    private TabViewTag.TabViewMode mode;

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    public void setParent(UIComponent parent) {
        super.setParent(parent);
        UIComponent tabView = parent;
        if (parent instanceof UIPanel) {
            tabView = parent.getParent();
        }
        if (tabView instanceof TabViewTag && !this.helper.hasComponentId()) {
            String tabViewId = tabView.getId();
            if (tabViewId.startsWith("j_id")) {
                tabViewId = "tab";
            }
            String tabId = StringUtils.concat((String[])new String[]{tabViewId, "_", String.valueOf(parent.getChildCount() - 1)});
            super.setId(tabId);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        this.mode = this.detectTabViewMode();
        ResponseWriter writer = context.getResponseWriter();
        if (this.mode.PAGE_WRAP_TAG != null) {
            writer.startElement(this.mode.PAGE_WRAP_TAG, (UIComponent)this);
            writer.writeAttribute("id", (Object)this.getClientId(), null);
        }
        writer.startElement(this.mode.PAGE_TAG, (UIComponent)this);
        if (this.mode.PAGE_WRAP_TAG == null) {
            writer.writeAttribute("id", (Object)this.getClientId(), null);
        }
        writer.writeAttribute("class", (Object)this.helper.getSimpleStyleClass(), null);
    }

    public boolean getRendersChildren() {
        return super.getRendersChildren();
    }

    public void encodeChildren(FacesContext context) throws IOException {
        super.encodeChildren(context);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement(this.mode.PAGE_TAG);
        if (this.mode.PAGE_WRAP_TAG != null) {
            writer.endElement(this.mode.PAGE_WRAP_TAG);
        }
    }

    public String getTabLabel() {
        String label = this.helper.getTagAttributeString(LABEL_FACET_NAME);
        if (label == null && this.getFacet(LABEL_FACET_NAME) == null && (label = this.helper.getTagAttributeString("title")) != null) {
            log.info("TabPage \"{}\": attribute \"title\" was provided instead of \"label\". This is deprecated and may be removed in the future!", (Object)label);
        }
        return label;
    }

    public String getTabTitle() {
        String label = this.helper.getTagAttributeString(LABEL_FACET_NAME);
        if (label == null && this.getFacet(LABEL_FACET_NAME) == null) {
            return null;
        }
        return this.helper.getTagAttributeString("title");
    }

    protected TabViewTag.TabViewMode detectTabViewMode() {
        TabPageTag parent = this;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof TabViewTag)) continue;
            return ((TabViewTag)((Object)parent)).getViewMode();
        }
        log.warn("TabViewTag not found! Unable to detect TabViewMode.");
        return TabViewTag.TabViewMode.GRID;
    }
}

