/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.jsf2.components.ControlTag;
import org.apache.empire.jsf2.utils.ControlRenderInfo;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.apache.empire.jsf2.utils.TagEncodingHelperFactory;
import org.apache.empire.jsf2.utils.TagStyleClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormGridTag
extends UIOutput {
    private static final Logger log = LoggerFactory.getLogger(FormGridTag.class);
    protected final TagEncodingHelper helper = TagEncodingHelperFactory.create(this, TagStyleClass.FORM_GRID.get());
    protected ControlRenderInfo controlRenderInfo = null;
    private FormGridMode mode;

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        this.mode = FormGridMode.detect(this.helper.getTagAttributeString("mode", FormGridMode.GRID.name()));
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement(this.mode.GRID_TAG, (UIComponent)this);
        this.helper.writeComponentId(writer);
        this.helper.writeStyleClass(writer);
        this.helper.writeAttribute(writer, "style", this.helper.getTagAttributeString("style"));
    }

    public boolean getRendersChildren() {
        return super.getRendersChildren();
    }

    public void encodeChildren(FacesContext context) throws IOException {
        super.encodeChildren(context);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement(this.mode.GRID_TAG);
    }

    public ControlRenderInfo getControlRenderInfo() {
        if (this.controlRenderInfo != null) {
            return this.controlRenderInfo;
        }
        if (this.mode == null) {
            this.mode = FormGridMode.detect(this.helper.getTagAttributeString("mode", FormGridMode.GRID.name()));
        }
        Character autoControlId = null;
        String autoId = this.helper.getTagAttributeString("autoControlId");
        if (autoId != null) {
            String id = autoId.toString();
            if ("true".equalsIgnoreCase(id)) {
                autoControlId = Character.valueOf('*');
            } else if (id.length() == 1 && StringUtils.indexOfAny((String)id, (char[])TagEncodingHelper.ALLOWED_COLUMN_PH) >= 0) {
                autoControlId = Character.valueOf(id.charAt(0));
            } else if (!"false".equalsIgnoreCase(id)) {
                log.warn("FormGridTag: Invalid value \"{}\" for attribute \"autoControlId\". Allowed values are *|@|&", (Object)id);
            }
        }
        this.controlRenderInfo = this.createControlRenderInfo(this.mode, autoControlId);
        return this.controlRenderInfo;
    }

    protected ControlRenderInfo createControlRenderInfo(FormGridMode gridMode, Character autoControlId) {
        UIComponent placeholderFacet = this.getFacet("placeholder");
        boolean renderPlaceholder = placeholderFacet == null ? ControlRenderInfo.isRenderPlaceholder((UIComponent)this) : false;
        return new FromGridRenderInfo(gridMode, placeholderFacet, renderPlaceholder, autoControlId);
    }

    protected static class FromGridRenderInfo
    extends ControlRenderInfo {
        private final UIComponent placeholderFacet;
        private final boolean renderPlaceholder;

        public FromGridRenderInfo(FormGridMode mode, UIComponent placeholderFacet, boolean renderPlaceholder, Character autoControlId) {
            super(mode.CONTROL_TAG, mode.LABEL_TAG, mode.INPUT_TAG, autoControlId);
            this.placeholderFacet = placeholderFacet;
            this.renderPlaceholder = renderPlaceholder;
        }

        @Override
        public void renderPlaceholder(FacesContext context, ControlTag controlTag) throws IOException {
            if (this.placeholderFacet != null) {
                this.placeholderFacet.encodeAll(context);
            } else if (this.renderPlaceholder || FromGridRenderInfo.isRenderPlaceholder((UIComponent)controlTag)) {
                ResponseWriter writer = context.getResponseWriter();
                String placeholderTag = this.CONTROL_TAG != null ? this.CONTROL_TAG : this.INPUT_WRAPPER_TAG;
                writer.startElement(placeholderTag, (UIComponent)controlTag);
                if (this.CONTROL_TAG != null && TagEncodingHelper.hasComponentId((UIComponent)controlTag)) {
                    writer.writeAttribute("id", (Object)controlTag.getClientId(), null);
                }
                String controlClass = controlTag.helper.getTagAttributeStringEx("controlClass", true);
                String styleClass = controlTag.helper.getTagAttributeString("styleClass");
                controlTag.helper.writeStyleClass(writer, TagStyleClass.CONTROL_PLACEHOLDER.get(), controlClass, styleClass);
                if (this.CONTROL_TAG == null && "td".equalsIgnoreCase(placeholderTag)) {
                    writer.writeAttribute("colspan", (Object)2, null);
                }
                writer.endElement(placeholderTag);
            }
        }
    }

    private static enum FormGridMode {
        LEGACY("div", null, "td", "td"),
        TABLE("table", "tr", "td", "td"),
        GRID("div", "div", "div", "div"),
        LEAN("div", "div", null, "div"),
        FLAT("div", "div", null, null);

        public final String GRID_TAG;
        public final String CONTROL_TAG;
        public final String LABEL_TAG;
        public final String INPUT_TAG;

        private FormGridMode(String gridTag, String controlTag, String labelTag, String inputTag) {
            this.GRID_TAG = gridTag;
            this.CONTROL_TAG = controlTag;
            this.LABEL_TAG = labelTag;
            this.INPUT_TAG = inputTag;
        }

        public static FormGridMode detect(String mode) {
            if (mode == null || mode.length() == 0) {
                return LEGACY;
            }
            FormGridMode[] values = FormGridMode.values();
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].name().equalsIgnoreCase(mode)) continue;
                return values[i];
            }
            log.warn("FormGridMode \"{}\" not found. Using default!", (Object)mode);
            return LEGACY;
        }

        public String toString() {
            return this.name();
        }
    }
}

