/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.list;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.empire.commons.ClassUtils;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBContext;
import org.apache.empire.db.DBRecordData;
import org.apache.empire.db.exceptions.CommandWithoutSelectException;
import org.apache.empire.db.list.DBBeanListFactory;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.UnsupportedTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBBeanListFactoryImpl<T>
implements DBBeanListFactory<T> {
    private static final Logger log = LoggerFactory.getLogger(DBBeanListFactoryImpl.class);
    protected final Constructor<T> constructor;
    protected final Class<?>[] parameterTypes;
    protected final List<? extends DBColumnExpr> constructorParams;
    protected final List<? extends DBColumnExpr> setterColumns;

    protected static <T> Constructor<T> findBeanConstructor(Class<T> beanType, List<? extends DBColumnExpr> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        Class[] paramTypes = new Class[params.size()];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramTypes[i] = params.get(i).getJavaType();
        }
        return ClassUtils.findMatchingConstructor(beanType, -1, paramTypes);
    }

    protected static <T> Constructor<T> findBeanConstructor(Class<T> beanType) {
        return ClassUtils.findMatchingConstructor(beanType, 0, new Class[0]);
    }

    protected static Class<?>[] getParameterTypes(Constructor<?> constructor) {
        if (constructor == null) {
            return null;
        }
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (!parameterTypes[i].isPrimitive()) continue;
            parameterTypes[i] = MethodUtils.getPrimitiveWrapper(parameterTypes[i]);
        }
        return parameterTypes;
    }

    public DBBeanListFactoryImpl(Constructor<T> constructor, List<? extends DBColumnExpr> constructorParams, List<? extends DBColumnExpr> setterColumns) {
        this.constructor = constructor;
        this.parameterTypes = DBBeanListFactoryImpl.getParameterTypes(constructor);
        this.constructorParams = constructorParams;
        this.setterColumns = setterColumns;
        if (constructor != null && constructor.getParameterCount() > 0 && (constructorParams == null || constructor.getParameterCount() < constructorParams.size())) {
            throw new InvalidArgumentException("constructor||constructorParams", constructor);
        }
        if (constructor != null && log.isDebugEnabled()) {
            log.debug("{}: using constructor with {} params", (Object)constructor.getDeclaringClass().getName(), (Object)constructor.getParameterCount());
        }
    }

    public DBBeanListFactoryImpl(Class<T> beanType, List<? extends DBColumnExpr> selectColumns) {
        Constructor<T> constructor = DBBeanListFactoryImpl.findBeanConstructor(beanType, selectColumns);
        if (constructor != null) {
            this.constructorParams = selectColumns;
            this.setterColumns = null;
        } else {
            constructor = DBBeanListFactoryImpl.findBeanConstructor(beanType);
            if (constructor == null) {
                throw new UnsupportedTypeException(beanType);
            }
            this.constructorParams = null;
            this.setterColumns = selectColumns;
        }
        this.constructor = constructor;
        this.parameterTypes = DBBeanListFactoryImpl.getParameterTypes(constructor);
        if (constructor != null && log.isDebugEnabled()) {
            log.debug("{}: using bean constructor with {} params", (Object)beanType.getName(), (Object)constructor.getParameterCount());
        }
    }

    protected DBBeanListFactoryImpl(Class<T> beanType, List<? extends DBColumnExpr> keyColumns, List<? extends DBColumnExpr> selectColumns) {
        Constructor<T> constructor = DBBeanListFactoryImpl.findBeanConstructor(beanType, selectColumns);
        if (constructor != null) {
            this.constructorParams = selectColumns;
            this.setterColumns = null;
        } else {
            constructor = DBBeanListFactoryImpl.findBeanConstructor(beanType, keyColumns);
            if (constructor != null) {
                this.constructorParams = keyColumns;
                this.setterColumns = selectColumns;
            } else {
                constructor = DBBeanListFactoryImpl.findBeanConstructor(beanType);
                if (constructor == null) {
                    throw new UnsupportedTypeException(beanType);
                }
                this.constructorParams = null;
                this.setterColumns = selectColumns;
            }
        }
        this.constructor = constructor;
        this.parameterTypes = DBBeanListFactoryImpl.getParameterTypes(constructor);
        if (constructor != null && log.isDebugEnabled()) {
            log.debug("{}: using bean constructor with {} params", (Object)beanType.getName(), (Object)constructor.getParameterCount());
        }
    }

    public DBBeanListFactoryImpl(Class<T> beanType, Column[] keyColumns, List<? extends DBColumnExpr> selectColumns) {
        this(beanType, ObjectUtils.arrayToList(DBColumn.class, (DBColumn[])keyColumns), selectColumns);
    }

    @Override
    public Class<?> getBeanType() {
        return this.constructor.getDeclaringClass();
    }

    @Override
    public void prepareQuery(DBCommandExpr cmd, DBContext context) {
        boolean hasSelect = cmd.hasSelectExpr();
        if (this.constructorParams != null) {
            for (DBColumnExpr dBColumnExpr : this.constructorParams) {
                if (cmd.hasSelectExpr(dBColumnExpr)) continue;
                if (cmd instanceof DBCommand) {
                    ((DBCommand)cmd).select(dBColumnExpr);
                    continue;
                }
                throw new InvalidArgumentException("cmd", cmd);
            }
        }
        if (this.setterColumns != null && !hasSelect && cmd instanceof DBCommand) {
            for (DBColumnExpr dBColumnExpr : this.setterColumns) {
                if (this.constructorParams != null && this.constructorParams.contains(dBColumnExpr) || cmd.hasSelectExpr(dBColumnExpr)) continue;
                ((DBCommand)cmd).select(dBColumnExpr);
            }
        }
        if (!cmd.hasSelectExpr()) {
            throw new CommandWithoutSelectException(cmd);
        }
    }

    @Override
    public List<T> newList(int capacity) {
        return new ArrayList(capacity);
    }

    @Override
    public T newItem(int rownum, DBRecordData recData) {
        try {
            T bean;
            if (this.constructorParams != null && this.constructor.getParameterCount() > 0) {
                Object[] params = new Object[this.constructor.getParameterCount()];
                int i = 0;
                for (DBColumnExpr dBColumnExpr : this.constructorParams) {
                    Class<?> valueType;
                    Class<Enum<?>> enumType = dBColumnExpr.getEnumType();
                    params[i] = enumType != null ? recData.getEnum(dBColumnExpr, enumType) : recData.get(dBColumnExpr);
                    if (params[i] != null && !this.parameterTypes[i].isAssignableFrom(valueType = params[i].getClass())) {
                        if (log.isDebugEnabled()) {
                            log.debug("{} type of param {} doesn't match: expected \"{}\" got \"{}\"", new Object[]{this.constructor.getDeclaringClass().getName(), i, this.parameterTypes[i].getName(), valueType.getName()});
                        }
                        params[i] = ObjectUtils.convert(this.parameterTypes[i], params[i]);
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("{}: constructor param '{}' is {}", new Object[]{this.constructor.getDeclaringClass().getName(), StringUtils.coalesce(dBColumnExpr.getName(), String.valueOf(i)), params[i]});
                    }
                    ++i;
                }
                bean = this.constructor.newInstance(params);
                if (params.length < recData.getFieldCount()) {
                    recData.setBeanProperties(bean, this.constructorParams);
                }
            } else {
                bean = this.constructor.newInstance(new Object[0]);
                recData.setBeanProperties(bean);
            }
            return bean;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new InternalException(e);
        }
    }

    @Override
    public void completeQuery(List<T> list) {
    }
}

