/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Set;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.expr.column.DBAbstractFuncExpr;
import org.apache.empire.dbms.DBSqlPhrase;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.NotSupportedException;

public class DBFuncExpr
extends DBAbstractFuncExpr {
    protected final DBSqlPhrase phrase;
    protected final Object[] params;
    protected String template;

    public DBFuncExpr(DBColumnExpr expr, DBSqlPhrase phrase, Object[] params, DataType dataType) {
        super(expr, phrase.isAggregate(), dataType);
        this.phrase = phrase;
        this.params = params;
        Object db = expr.getDatabase();
        if (((DBDatabase)db).isOpen()) {
            this.template = ((DBDatabase)db).getDbms().getSQLPhrase(phrase);
            if (StringUtils.isEmpty(this.template)) {
                throw new NotSupportedException(this.getDbms(), phrase.name());
            }
        }
        if (phrase == DBSqlPhrase.SQL_FUNC_COALESCE) {
            log.warn("DBFuncExpr should not be used for SQL_FUNC_COALESCE. Use DBCoalesceExpr instead.");
        }
    }

    public DBFuncExpr(DBColumnExpr expr, String template, Object[] params, boolean isAggregate, DataType dataType) {
        super(expr, isAggregate, dataType);
        if (template == null) {
            throw new InvalidArgumentException("template", template);
        }
        this.template = template;
        this.params = params;
        this.phrase = null;
    }

    @Override
    protected String getFunctionName() {
        if (this.phrase != null) {
            return this.phrase.getFuncName();
        }
        if (this.template != null) {
            int i;
            String s = this.template.trim();
            for (i = 0; i < s.length() && s.charAt(i) >= 'A'; ++i) {
            }
            if (i > 0) {
                return s.substring(0, i);
            }
        }
        return "FUNC";
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        if (this.phrase == DBSqlPhrase.SQL_FUNC_COALESCE) {
            return this.expr.getEnumType();
        }
        return super.getEnumType();
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        super.addReferencedColumns(list);
        if (this.params == null) {
            return;
        }
        for (int i = 0; i < this.params.length; ++i) {
            if (!(this.params[i] instanceof DBExpr)) continue;
            ((DBExpr)this.params[i]).addReferencedColumns(list);
        }
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        if (this.template == null) {
            this.template = this.getDbms().getSQLPhrase(this.phrase);
            if (StringUtils.isEmpty(this.template)) {
                throw new NotSupportedException(this.getDbms(), this.phrase.name());
            }
        }
        super.addSQL(sql, this.template, this.params, context);
    }
}

