/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBContext;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBRecordBase;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.expr.column.DBValueExpr;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemExistsException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.xml.XMLUtil;
import org.w3c.dom.Element;

public abstract class DBView
extends DBRowSet
implements Cloneable {
    private static AtomicInteger viewCount = new AtomicInteger(0);
    private final String name;
    private String alias;
    private DBViewColumn[] keyColumns;
    private boolean updateable;
    private Boolean quoteName = null;

    protected String generateAlias(String prefix) {
        return prefix + String.valueOf(viewCount.incrementAndGet());
    }

    public DBView(String name, DBDatabase db, boolean isUpdateable, String alias) {
        super(db);
        if (StringUtils.isEmpty(alias)) {
            alias = this.generateAlias("v");
        }
        this.name = name;
        this.alias = alias;
        this.updateable = isUpdateable;
        if (db != null && name != null) {
            db.addView(this);
        }
    }

    public DBView(String name, DBDatabase db, boolean isUpdateable) {
        this(name, db, isUpdateable, null);
    }

    public DBView(String name, DBDatabase db) {
        this(name, db, false);
    }

    public Object clone() throws CloneNotSupportedException {
        DBView clone = (DBView)super.clone();
        this.initClonedFields(clone);
        clone.keyColumns = this.cloneKeyColumns(clone);
        clone.alias = this.generateAlias("v");
        log.info("clone: Table " + this.name + " cloned! Alias old=" + this.alias + " new=" + clone.alias);
        this.db.addView(clone);
        return clone;
    }

    public <T extends DBView> T clone(String newAlias) {
        try {
            DBView clone = (DBView)super.clone();
            this.initClonedFields(clone);
            clone.keyColumns = this.cloneKeyColumns(clone);
            clone.alias = StringUtils.isEmpty(newAlias) ? this.generateAlias("v") : newAlias;
            log.info("clone: Table " + this.name + " cloned! Alias old=" + this.alias + " new=" + clone.alias);
            this.db.addView(clone);
            return (T)clone;
        }
        catch (CloneNotSupportedException e) {
            log.error("Unable to clone table " + this.getName());
            throw new RuntimeException(e);
        }
    }

    @Override
    protected DBColumn cloneColumn(DBRowSet clone, DBColumn sourceColumn) {
        DBViewColumn newCol = new DBViewColumn((DBView)clone, (DBViewColumn)sourceColumn);
        return newCol;
    }

    protected DBViewColumn[] cloneKeyColumns(DBView clone) {
        if (this.keyColumns == null) {
            return null;
        }
        DBViewColumn[] columns = new DBViewColumn[this.keyColumns.length];
        for (int i = 0; i < this.keyColumns.length; ++i) {
            columns[i] = (DBViewColumn)clone.getColumn(this.getColumnIndex(this.keyColumns[i]));
        }
        return columns;
    }

    @Override
    public DBColumn[] getKeyColumns() {
        return this.keyColumns;
    }

    protected void setKeyColumns(DBViewColumn ... keyColumns) {
        this.keyColumns = keyColumns;
    }

    protected void setKeyColumn(DBViewColumn keyColumn) {
        if (keyColumn != null) {
            this.setKeyColumns(keyColumn);
        } else {
            this.setKeyColumns(null);
        }
    }

    protected DBCommand newCommand() {
        return this.db.getDbms().createCommand(false);
    }

    public abstract DBCommandExpr createCommand();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        String schema = this.db.getSchema();
        return schema != null ? StringUtils.concat(schema, ".", this.name) : this.name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public boolean isUpdateable() {
        return this.updateable;
    }

    protected void addViewColumn(DBViewColumn col) {
        if (col == null || col.getRowSet() != this) {
            throw new InvalidArgumentException("col", col);
        }
        if (this.getColumn(col.getName()) != null) {
            throw new ItemExistsException((Object)col.getName());
        }
        this.columns.add(col);
    }

    protected final DBViewColumn addColumn(String columnName, DataType dataType, double size) {
        return new DBViewColumn(this, columnName, new DBValueExpr(this.db, null, dataType), size);
    }

    protected final DBViewColumn addColumn(String columnName, DataType dataType) {
        return new DBViewColumn(this, columnName, new DBValueExpr(this.db, null, dataType), 0.0);
    }

    protected final DBViewColumn addColumn(String columnName, DBColumnExpr columnExpr) {
        return new DBViewColumn(this, columnName, columnExpr, 0.0);
    }

    protected final DBViewColumn addColumn(DBTableColumn sourceColumn) {
        return new DBViewColumn(this, sourceColumn.getName(), sourceColumn, sourceColumn.getSize());
    }

    protected final DBViewColumn addColumn(DBViewColumn sourceColumn) {
        return new DBViewColumn(this, sourceColumn.getName(), sourceColumn, sourceColumn.getSize());
    }

    public DBViewColumn findViewColumn(DBColumnExpr expr) {
        for (int i = 0; i < this.columns.size(); ++i) {
            DBViewColumn vc = (DBViewColumn)this.columns.get(i);
            if (!vc.expr.equals(expr)) continue;
            return vc;
        }
        return null;
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        if ((context & 1L | 2L) != 0L) {
            this.db.appendQualifiedName(sql, this.name, this.quoteName);
        }
        if ((context & 8L) != 0L && this.alias != null) {
            sql.append(this.getRenameTablePhrase());
            sql.append(this.alias);
        }
    }

    public void updateRecord(DBRecordBase rec) {
        if (!this.updateable) {
            throw new NotSupportedException(this, "updateRecord");
        }
        super.updateRecord(rec);
    }

    @Override
    public void createRecord(DBRecordBase record, Object[] initalKey, boolean deferredInit) {
        throw new NotSupportedException(this, "createRecord");
    }

    @Override
    public void deleteRecord(Object[] key, DBContext context) {
        throw new NotSupportedException(this, "deleteRecord");
    }

    public static class DBViewColumn
    extends DBColumn {
        protected final DBColumnExpr expr;
        protected final DataType dataType;
        protected final DBColumn updateColumn;
        protected final double size;

        protected DBViewColumn(DBView view, String name, DBColumnExpr expr, double size) {
            super(view, name);
            this.expr = expr;
            DataType exprType = expr.getDataType();
            if (exprType == DataType.AUTOINC) {
                exprType = DataType.INTEGER;
            }
            this.dataType = exprType;
            this.updateColumn = expr.getUpdateColumn();
            this.size = this.updateColumn != null ? this.updateColumn.getSize() : size;
            Class<Enum<?>> enumType = expr.getEnumType();
            if (enumType != null) {
                this.setAttribute("enumType", enumType);
            }
            if (view != null) {
                view.addViewColumn(this);
            }
        }

        protected DBViewColumn(DBView view, DBViewColumn other) {
            super(view, other.getName());
            this.expr = other.expr;
            this.dataType = other.dataType;
            this.updateColumn = other.updateColumn;
            this.size = other.size;
            Class<Enum<?>> enumType = other.getEnumType();
            if (enumType != null) {
                this.setAttribute("enumType", enumType);
            }
            if (view != null) {
                view.addViewColumn(this);
            }
        }

        public DBColumnExpr getSourceColumnExpr() {
            return this.expr;
        }

        public DBView getView() {
            return (DBView)this.getRowSet();
        }

        @Override
        public DataType getDataType() {
            return this.dataType;
        }

        @Override
        public double getSize() {
            return this.size;
        }

        @Override
        public boolean isAutoGenerated() {
            if (this.updateColumn == null) {
                return false;
            }
            return this.updateColumn.isAutoGenerated();
        }

        @Override
        public boolean isReadOnly() {
            if (this.updateColumn != null) {
                return this.updateColumn.isReadOnly();
            }
            return this.isAutoGenerated();
        }

        @Override
        public boolean isRequired() {
            if (this.updateColumn == null) {
                return false;
            }
            return this.updateColumn.isRequired();
        }

        @Override
        public Object getAttribute(String name) {
            if (this.attributes != null && this.attributes.contains(name)) {
                return this.attributes.get(name);
            }
            return this.expr.getAttribute(name);
        }

        @Override
        public Options getOptions() {
            if (this.options != null) {
                return this.options;
            }
            return this.expr.getOptions();
        }

        @Override
        public Object validateValue(Object value) {
            if (this.updateColumn == null) {
                return value;
            }
            return this.updateColumn.validateValue(value);
        }

        @Override
        public Element addXml(Element parent, long flags) {
            Options fieldOptions;
            double size;
            Element elem = XMLUtil.addElement(parent, "column");
            elem.setAttribute("name", this.name);
            if (this.updateColumn != null) {
                elem.setAttribute("source", this.updateColumn.getFullName());
            }
            if ((size = this.getSize()) > 0.0) {
                elem.setAttribute("size", String.valueOf(size));
            }
            if (this.attributes != null) {
                this.attributes.addXml(elem, flags);
            }
            if ((fieldOptions = this.getOptions()) != null) {
                fieldOptions.addXml(elem, this.dataType);
            }
            return elem;
        }

        public void setEnumOptions(Class<?> enumType) {
            DBRowSet.log.debug("Adding enum options of type {} for column {}.", (Object)enumType.getName(), (Object)this.getName());
            this.options = new Options(enumType);
            this.setAttribute("enumType", enumType);
        }
    }
}

